(ns ch.codesmith.blocks.postgres
  (:require [ch.codesmith.blocks.core :as cb]
            [ch.codesmith.blocks.jdbc :as cbjdbc]))

(derive ::datasource cbjdbc/jdbc-datasource)

(def config-defaults
  {:db-spec {:dbtype                "postgres"
             :reWriteBatchedInserts true}})

(defmethod cb/start-block! ::datasource
  [_ _ config _]
  (cbjdbc/start-hikaricp-pool!
    (cb/deep-merge
      config-defaults
      config)))

(defmethod cb/stop-block! ::datasource [_ ds]
  (cbjdbc/halt! ds))

