(ns ch.codesmith.blocks.postgres.dev
  (:require [ch.codesmith.blocks.jdbc :as cbjdbc]
            [ch.codesmith.blocks.postgres :as cbp]
            [integrant.core :as ig])
  (:import (com.zaxxer.hikari HikariDataSource)
           (io.zonky.test.db.postgres.embedded EmbeddedPostgres)))

(defmethod ig/init-key ::embedded [_ {:keys [port] :as config}]
  (let [builder (EmbeddedPostgres/builder)
        builder (if port (.setPort builder port) builder)
        ^EmbeddedPostgres embedded-postgres (.start builder)
        jdbc-url (.getJdbcUrl embedded-postgres "postgres" "postgres")
        config (update config :datasource
                       #(assoc %
                          :jdbcUrl jdbc-url
                          :password "postgres"))
        ^HikariDataSource ds (cbjdbc/init config)]
    {:datasource        ds
     :embedded-postgres embedded-postgres}))

(defmethod ig/resolve-key ::embedded [_ instance]
  (:datasource instance))

(defmethod ig/halt-key! ::embedded [_ {:keys [^HikariDataSource datasource ^EmbeddedPostgres embedded-postgres]}]
  (.close datasource)
  (.close embedded-postgres))

(derive ::embedded cbp/postgres-datasource)
