(ns ch.codesmith.blocks.postgres.dev
  (:require [ch.codesmith.blocks.postgres :as cbp]
            [next.jdbc.connection :as conn])
  (:import (com.zaxxer.hikari HikariDataSource)
           (io.zonky.test.db.postgres.embedded EmbeddedPostgres)))

(def postgres cbp/postgres)

(defmethod cbp/postgres :embedded-dev
  [_ {:keys [port migratus]}]
  {:instance         (let [builder                             (EmbeddedPostgres/builder)
                           builder                             (if port (.setPort builder port) builder)
                           ^EmbeddedPostgres embedded-postgres (.start builder)
                           ^HikariDataSource ds                (conn/->pool HikariDataSource
                                                                            (merge
                                                                              (cbp/config->db-spec {:connection-url (.getJdbcUrl embedded-postgres "postgres" "postgres")})
                                                                              {:password "postgres"}))]
                       (cbp/migrate-db! ds migratus)
                       {:datasource        ds
                        :embedded-postgres embedded-postgres})
   :resolve-instance :datasource
   :halt             (fn [_ {:keys [datasource embedded-postgres]}]
                       (.close datasource)
                       (.close embedded-postgres))})
