(ns ch.codesmith.blocks.jdbc.liquibase
  (:require [next.jdbc :as jdbc])
  (:import (liquibase Liquibase)
           (liquibase.database.jvm JdbcConnection)
           (liquibase.resource ClassLoaderResourceAccessor)))

(defn liquibase-migrate-function [ds {:keys [^String change-log-file ^String version]}]
  (jdbc/on-connection [conn ds]
    (let [db-conn   (JdbcConnection. conn)
          liquibase (Liquibase.
                      change-log-file
                      (ClassLoaderResourceAccessor.)
                      db-conn)]
      (.update liquibase)
      (when version
        (.tag liquibase version)))))
