/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import com.sun.tracing.Provider;
import com.sun.tracing.ProviderName;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import sun.tracing.ProbeSkeleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderSkeleton
implements InvocationHandler,
Provider {
    protected boolean active = false;
    protected Class<? extends Provider> providerType;
    protected HashMap<Method, ProbeSkeleton> probes;

    protected abstract ProbeSkeleton createProbe(Method var1);

    protected ProviderSkeleton(Class<? extends Provider> type) {
        this.providerType = type;
        this.probes = new HashMap();
    }

    public void init() {
        Method[] methods;
        for (Method m : methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return ProviderSkeleton.this.providerType.getDeclaredMethods();
            }
        })) {
            if (m.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Return value of method is not void");
            }
            this.probes.put(m, this.createProbe(m));
        }
        this.active = true;
    }

    public <T extends Provider> T newProxyInstance() {
        return (T)((Provider)Proxy.newProxyInstance(this.providerType.getClassLoader(), new Class[]{this.providerType}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        block7: {
            ProbeSkeleton p;
            if (method.getDeclaringClass() != this.providerType) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (IllegalAccessException e) {
                    assert (false);
                    break block7;
                }
                catch (InvocationTargetException e) {
                    assert (false);
                    break block7;
                }
            }
            if (this.active && (p = this.probes.get(method)) != null) {
                p.uncheckedTrigger(args);
            }
        }
        return null;
    }

    @Override
    public Probe getProbe(Method m) {
        return this.active ? this.probes.get(m) : null;
    }

    @Override
    public void dispose() {
        this.active = false;
        this.probes.clear();
    }

    protected String getProviderName() {
        return ProviderSkeleton.getAnnotationString(this.providerType, ProviderName.class, this.providerType.getSimpleName());
    }

    protected static String getAnnotationString(AnnotatedElement element, Class<? extends Annotation> annotation, String defaultValue) {
        String ret = (String)ProviderSkeleton.getAnnotationValue(element, annotation, "value", defaultValue);
        return ret.isEmpty() ? defaultValue : ret;
    }

    protected static Object getAnnotationValue(AnnotatedElement element, Class<? extends Annotation> annotation, String methodName, Object defaultValue) {
        Object ret;
        block8: {
            ret = defaultValue;
            try {
                Method m = annotation.getMethod(methodName, new Class[0]);
                Annotation a = element.getAnnotation(annotation);
                ret = m.invoke((Object)a, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
            catch (InvocationTargetException e) {
                assert (false);
            }
            catch (NullPointerException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return ret;
    }
}

