/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tracing;

import com.sun.tracing.Provider;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import sun.security.action.GetPropertyAction;
import sun.tracing.MultiplexProviderFactory;
import sun.tracing.NullProviderFactory;
import sun.tracing.PrintStreamProviderFactory;
import sun.tracing.dtrace.DTraceProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderFactory {
    protected ProviderFactory() {
    }

    public abstract <T extends Provider> T createProvider(Class<T> var1);

    public static ProviderFactory getDefaultFactory() {
        HashSet<ProviderFactory> factories = new HashSet<ProviderFactory>();
        String prop = AccessController.doPrivileged(new GetPropertyAction("com.sun.tracing.dtrace"));
        if ((prop == null || !prop.equals("disable")) && DTraceProviderFactory.isSupported()) {
            factories.add(new DTraceProviderFactory());
        }
        if ((prop = AccessController.doPrivileged(new GetPropertyAction("sun.tracing.stream"))) != null) {
            for (String spec : prop.split(",")) {
                PrintStream ps = ProviderFactory.getPrintStreamFromSpec(spec);
                if (ps == null) continue;
                factories.add(new PrintStreamProviderFactory(ps));
            }
        }
        if (factories.size() == 0) {
            return new NullProviderFactory();
        }
        if (factories.size() == 1) {
            return factories.toArray(new ProviderFactory[1])[0];
        }
        return new MultiplexProviderFactory(factories);
    }

    private static PrintStream getPrintStreamFromSpec(final String spec) {
        try {
            final int fieldpos = spec.lastIndexOf(46);
            final Class<?> cls = Class.forName(spec.substring(0, fieldpos));
            Field f = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws NoSuchFieldException {
                    return cls.getField(spec.substring(fieldpos + 1));
                }
            });
            return (PrintStream)f.get(null);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError((Object)e);
        }
    }
}

