goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = ((typeof window !== 'undefined')?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$IElement$_to_dom$arity$1 == null))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4211__auto__ = (((this$ == null))?null:this$);
var m__4212__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto__.call(null,this$));
} else {
var m__4212__auto____$1 = (shadow.dom._to_dom["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if(((!((this$ == null))) && (!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4211__auto__ = (((this$ == null))?null:this$);
var m__4212__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto__.call(null,this$));
} else {
var m__4212__auto____$1 = (shadow.dom._to_svg["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__34944 = coll;
var G__34945 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__34944,G__34945) : shadow.dom.lazy_native_coll_seq.call(null,G__34944,G__34945));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__3922__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode([cljs.core.str.cljs$core$IFn$_invoke$arity$1(el)].join(''));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__34977 = arguments.length;
switch (G__34977) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__34985 = arguments.length;
switch (G__34985) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__34998 = arguments.length;
switch (G__34998) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__35005 = arguments.length;
switch (G__35005) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__35024 = arguments.length;
switch (G__35024) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__35026 = document;
var G__35027 = shadow.dom.dom_node(el);
return goog.dom.contains(G__35026,G__35027);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__35030 = shadow.dom.dom_node(parent);
var G__35031 = shadow.dom.dom_node(el);
return goog.dom.contains(G__35030,G__35031);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__35042 = shadow.dom.dom_node(el);
var G__35043 = cls;
return goog.dom.classlist.add(G__35042,G__35043);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__35048 = shadow.dom.dom_node(el);
var G__35049 = cls;
return goog.dom.classlist.remove(G__35048,G__35049);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__35051 = arguments.length;
switch (G__35051) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__35052 = shadow.dom.dom_node(el);
var G__35053 = cls;
return goog.dom.classlist.toggle(G__35052,G__35053);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__3922__auto__ = !(typeof document !== 'undefined');
if(or__3922__auto__){
return or__3922__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e35059){if((e35059 instanceof Object)){
var e = e35059;
return console.log("didnt support attachEvent",el,e);
} else {
throw e35059;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__3922__auto__ = !(typeof document !== 'undefined');
if(or__3922__auto__){
return or__3922__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__35063 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__35064 = null;
var count__35065 = (0);
var i__35066 = (0);
while(true){
if((i__35066 < count__35065)){
var el = chunk__35064.cljs$core$IIndexed$_nth$arity$2(null,i__35066);
var handler_35073__$1 = ((function (seq__35063,chunk__35064,count__35065,i__35066,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__35063,chunk__35064,count__35065,i__35066,el))
;
var G__35067_35074 = el;
var G__35068_35075 = cljs.core.name(ev);
var G__35069_35076 = handler_35073__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__35067_35074,G__35068_35075,G__35069_35076) : shadow.dom.dom_listen.call(null,G__35067_35074,G__35068_35075,G__35069_35076));


var G__35077 = seq__35063;
var G__35078 = chunk__35064;
var G__35079 = count__35065;
var G__35080 = (i__35066 + (1));
seq__35063 = G__35077;
chunk__35064 = G__35078;
count__35065 = G__35079;
i__35066 = G__35080;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35063);
if(temp__5457__auto__){
var seq__35063__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35063__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__35063__$1);
var G__35081 = cljs.core.chunk_rest(seq__35063__$1);
var G__35082 = c__4319__auto__;
var G__35083 = cljs.core.count(c__4319__auto__);
var G__35084 = (0);
seq__35063 = G__35081;
chunk__35064 = G__35082;
count__35065 = G__35083;
i__35066 = G__35084;
continue;
} else {
var el = cljs.core.first(seq__35063__$1);
var handler_35085__$1 = ((function (seq__35063,chunk__35064,count__35065,i__35066,el,seq__35063__$1,temp__5457__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__35063,chunk__35064,count__35065,i__35066,el,seq__35063__$1,temp__5457__auto__))
;
var G__35070_35086 = el;
var G__35071_35087 = cljs.core.name(ev);
var G__35072_35088 = handler_35085__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__35070_35086,G__35071_35087,G__35072_35088) : shadow.dom.dom_listen.call(null,G__35070_35086,G__35071_35087,G__35072_35088));


var G__35089 = cljs.core.next(seq__35063__$1);
var G__35090 = null;
var G__35091 = (0);
var G__35092 = (0);
seq__35063 = G__35089;
chunk__35064 = G__35090;
count__35065 = G__35091;
i__35066 = G__35092;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__35094 = arguments.length;
switch (G__35094) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__35095 = shadow.dom.dom_node(el);
var G__35096 = cljs.core.name(ev);
var G__35097 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__35095,G__35096,G__35097) : shadow.dom.dom_listen.call(null,G__35095,G__35096,G__35097));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__35102 = shadow.dom.dom_node(el);
var G__35103 = cljs.core.name(ev);
var G__35104 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__35102,G__35103,G__35104) : shadow.dom.dom_listen_remove.call(null,G__35102,G__35103,G__35104));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__35106 = cljs.core.seq(events);
var chunk__35107 = null;
var count__35108 = (0);
var i__35109 = (0);
while(true){
if((i__35109 < count__35108)){
var vec__35110 = chunk__35107.cljs$core$IIndexed$_nth$arity$2(null,i__35109);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35110,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35110,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35116 = seq__35106;
var G__35117 = chunk__35107;
var G__35118 = count__35108;
var G__35119 = (i__35109 + (1));
seq__35106 = G__35116;
chunk__35107 = G__35117;
count__35108 = G__35118;
i__35109 = G__35119;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35106);
if(temp__5457__auto__){
var seq__35106__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35106__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__35106__$1);
var G__35120 = cljs.core.chunk_rest(seq__35106__$1);
var G__35121 = c__4319__auto__;
var G__35122 = cljs.core.count(c__4319__auto__);
var G__35123 = (0);
seq__35106 = G__35120;
chunk__35107 = G__35121;
count__35108 = G__35122;
i__35109 = G__35123;
continue;
} else {
var vec__35113 = cljs.core.first(seq__35106__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35113,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35113,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__35126 = cljs.core.next(seq__35106__$1);
var G__35127 = null;
var G__35128 = (0);
var G__35129 = (0);
seq__35106 = G__35126;
chunk__35107 = G__35127;
count__35108 = G__35128;
i__35109 = G__35129;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__35133 = cljs.core.seq(styles);
var chunk__35134 = null;
var count__35135 = (0);
var i__35136 = (0);
while(true){
if((i__35136 < count__35135)){
var vec__35138 = chunk__35134.cljs$core$IIndexed$_nth$arity$2(null,i__35136);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35138,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35138,(1),null);
var G__35142_35152 = dom;
var G__35143_35153 = cljs.core.name(k);
var G__35144_35154 = (((v == null))?"":v);
goog.style.setStyle(G__35142_35152,G__35143_35153,G__35144_35154);


var G__35155 = seq__35133;
var G__35156 = chunk__35134;
var G__35157 = count__35135;
var G__35158 = (i__35136 + (1));
seq__35133 = G__35155;
chunk__35134 = G__35156;
count__35135 = G__35157;
i__35136 = G__35158;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35133);
if(temp__5457__auto__){
var seq__35133__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35133__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__35133__$1);
var G__35159 = cljs.core.chunk_rest(seq__35133__$1);
var G__35160 = c__4319__auto__;
var G__35161 = cljs.core.count(c__4319__auto__);
var G__35162 = (0);
seq__35133 = G__35159;
chunk__35134 = G__35160;
count__35135 = G__35161;
i__35136 = G__35162;
continue;
} else {
var vec__35146 = cljs.core.first(seq__35133__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35146,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35146,(1),null);
var G__35149_35163 = dom;
var G__35150_35164 = cljs.core.name(k);
var G__35151_35165 = (((v == null))?"":v);
goog.style.setStyle(G__35149_35163,G__35150_35164,G__35151_35165);


var G__35166 = cljs.core.next(seq__35133__$1);
var G__35167 = null;
var G__35168 = (0);
var G__35169 = (0);
seq__35133 = G__35166;
chunk__35134 = G__35167;
count__35135 = G__35168;
i__35136 = G__35169;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__35170_35172 = key;
var G__35170_35173__$1 = (((G__35170_35172 instanceof cljs.core.Keyword))?G__35170_35172.fqn:null);
switch (G__35170_35173__$1) {
case "id":
el.id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "class":
el.className = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join('');

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_35176 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__3922__auto__ = goog.string.startsWith(ks_35176,"data-");
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return goog.string.startsWith(ks_35176,"aria-");
}
})())){
el.setAttribute(ks_35176,value);
} else {
(el[ks_35176] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__35178 = shadow.dom.dom_node(el);
var G__35179 = cls;
return goog.dom.classlist.contains(G__35178,G__35179);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__35206){
var map__35207 = p__35206;
var map__35207__$1 = ((((!((map__35207 == null)))?(((((map__35207.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35207.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35207):map__35207);
var props = map__35207__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35207__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__35209 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35209,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35209,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35209,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__35212 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__35212,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__35212;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__35214 = arguments.length;
switch (G__35214) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5457__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5457__auto__)){
var n = temp__5457__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__35222){
var vec__35223 = p__35222;
var seq__35224 = cljs.core.seq(vec__35223);
var first__35225 = cljs.core.first(seq__35224);
var seq__35224__$1 = cljs.core.next(seq__35224);
var nn = first__35225;
var first__35225__$1 = cljs.core.first(seq__35224__$1);
var seq__35224__$2 = cljs.core.next(seq__35224__$1);
var np = first__35225__$1;
var nc = seq__35224__$2;
var node = vec__35223;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35226 = nn;
var G__35227 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35226,G__35227) : create_fn.call(null,G__35226,G__35227));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35229 = nn;
var G__35230 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35229,G__35230) : create_fn.call(null,G__35229,G__35230));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__35239 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35239,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35239,(1),null);
var seq__35242_35264 = cljs.core.seq(node_children);
var chunk__35243_35265 = null;
var count__35244_35266 = (0);
var i__35245_35267 = (0);
while(true){
if((i__35245_35267 < count__35244_35266)){
var child_struct_35268 = chunk__35243_35265.cljs$core$IIndexed$_nth$arity$2(null,i__35245_35267);
var children_35269 = shadow.dom.dom_node(child_struct_35268);
if(cljs.core.seq_QMARK_(children_35269)){
var seq__35247_35270 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35269));
var chunk__35249_35271 = null;
var count__35250_35272 = (0);
var i__35251_35273 = (0);
while(true){
if((i__35251_35273 < count__35250_35272)){
var child_35274 = chunk__35249_35271.cljs$core$IIndexed$_nth$arity$2(null,i__35251_35273);
if(cljs.core.truth_(child_35274)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35274);


var G__35275 = seq__35247_35270;
var G__35276 = chunk__35249_35271;
var G__35277 = count__35250_35272;
var G__35278 = (i__35251_35273 + (1));
seq__35247_35270 = G__35275;
chunk__35249_35271 = G__35276;
count__35250_35272 = G__35277;
i__35251_35273 = G__35278;
continue;
} else {
var G__35279 = seq__35247_35270;
var G__35280 = chunk__35249_35271;
var G__35281 = count__35250_35272;
var G__35282 = (i__35251_35273 + (1));
seq__35247_35270 = G__35279;
chunk__35249_35271 = G__35280;
count__35250_35272 = G__35281;
i__35251_35273 = G__35282;
continue;
}
} else {
var temp__5457__auto___35283 = cljs.core.seq(seq__35247_35270);
if(temp__5457__auto___35283){
var seq__35247_35285__$1 = temp__5457__auto___35283;
if(cljs.core.chunked_seq_QMARK_(seq__35247_35285__$1)){
var c__4319__auto___35286 = cljs.core.chunk_first(seq__35247_35285__$1);
var G__35287 = cljs.core.chunk_rest(seq__35247_35285__$1);
var G__35288 = c__4319__auto___35286;
var G__35289 = cljs.core.count(c__4319__auto___35286);
var G__35290 = (0);
seq__35247_35270 = G__35287;
chunk__35249_35271 = G__35288;
count__35250_35272 = G__35289;
i__35251_35273 = G__35290;
continue;
} else {
var child_35291 = cljs.core.first(seq__35247_35285__$1);
if(cljs.core.truth_(child_35291)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35291);


var G__35292 = cljs.core.next(seq__35247_35285__$1);
var G__35293 = null;
var G__35294 = (0);
var G__35295 = (0);
seq__35247_35270 = G__35292;
chunk__35249_35271 = G__35293;
count__35250_35272 = G__35294;
i__35251_35273 = G__35295;
continue;
} else {
var G__35296 = cljs.core.next(seq__35247_35285__$1);
var G__35297 = null;
var G__35298 = (0);
var G__35299 = (0);
seq__35247_35270 = G__35296;
chunk__35249_35271 = G__35297;
count__35250_35272 = G__35298;
i__35251_35273 = G__35299;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35269);
}


var G__35300 = seq__35242_35264;
var G__35301 = chunk__35243_35265;
var G__35302 = count__35244_35266;
var G__35303 = (i__35245_35267 + (1));
seq__35242_35264 = G__35300;
chunk__35243_35265 = G__35301;
count__35244_35266 = G__35302;
i__35245_35267 = G__35303;
continue;
} else {
var temp__5457__auto___35304 = cljs.core.seq(seq__35242_35264);
if(temp__5457__auto___35304){
var seq__35242_35305__$1 = temp__5457__auto___35304;
if(cljs.core.chunked_seq_QMARK_(seq__35242_35305__$1)){
var c__4319__auto___35306 = cljs.core.chunk_first(seq__35242_35305__$1);
var G__35307 = cljs.core.chunk_rest(seq__35242_35305__$1);
var G__35308 = c__4319__auto___35306;
var G__35309 = cljs.core.count(c__4319__auto___35306);
var G__35310 = (0);
seq__35242_35264 = G__35307;
chunk__35243_35265 = G__35308;
count__35244_35266 = G__35309;
i__35245_35267 = G__35310;
continue;
} else {
var child_struct_35311 = cljs.core.first(seq__35242_35305__$1);
var children_35312 = shadow.dom.dom_node(child_struct_35311);
if(cljs.core.seq_QMARK_(children_35312)){
var seq__35256_35313 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_35312));
var chunk__35258_35314 = null;
var count__35259_35315 = (0);
var i__35260_35316 = (0);
while(true){
if((i__35260_35316 < count__35259_35315)){
var child_35317 = chunk__35258_35314.cljs$core$IIndexed$_nth$arity$2(null,i__35260_35316);
if(cljs.core.truth_(child_35317)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35317);


var G__35318 = seq__35256_35313;
var G__35319 = chunk__35258_35314;
var G__35320 = count__35259_35315;
var G__35321 = (i__35260_35316 + (1));
seq__35256_35313 = G__35318;
chunk__35258_35314 = G__35319;
count__35259_35315 = G__35320;
i__35260_35316 = G__35321;
continue;
} else {
var G__35322 = seq__35256_35313;
var G__35323 = chunk__35258_35314;
var G__35324 = count__35259_35315;
var G__35325 = (i__35260_35316 + (1));
seq__35256_35313 = G__35322;
chunk__35258_35314 = G__35323;
count__35259_35315 = G__35324;
i__35260_35316 = G__35325;
continue;
}
} else {
var temp__5457__auto___35326__$1 = cljs.core.seq(seq__35256_35313);
if(temp__5457__auto___35326__$1){
var seq__35256_35327__$1 = temp__5457__auto___35326__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35256_35327__$1)){
var c__4319__auto___35328 = cljs.core.chunk_first(seq__35256_35327__$1);
var G__35329 = cljs.core.chunk_rest(seq__35256_35327__$1);
var G__35330 = c__4319__auto___35328;
var G__35331 = cljs.core.count(c__4319__auto___35328);
var G__35332 = (0);
seq__35256_35313 = G__35329;
chunk__35258_35314 = G__35330;
count__35259_35315 = G__35331;
i__35260_35316 = G__35332;
continue;
} else {
var child_35333 = cljs.core.first(seq__35256_35327__$1);
if(cljs.core.truth_(child_35333)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_35333);


var G__35334 = cljs.core.next(seq__35256_35327__$1);
var G__35335 = null;
var G__35336 = (0);
var G__35337 = (0);
seq__35256_35313 = G__35334;
chunk__35258_35314 = G__35335;
count__35259_35315 = G__35336;
i__35260_35316 = G__35337;
continue;
} else {
var G__35338 = cljs.core.next(seq__35256_35327__$1);
var G__35339 = null;
var G__35340 = (0);
var G__35341 = (0);
seq__35256_35313 = G__35338;
chunk__35258_35314 = G__35339;
count__35259_35315 = G__35340;
i__35260_35316 = G__35341;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_35312);
}


var G__35342 = cljs.core.next(seq__35242_35305__$1);
var G__35343 = null;
var G__35344 = (0);
var G__35345 = (0);
seq__35242_35264 = G__35342;
chunk__35243_35265 = G__35343;
count__35244_35266 = G__35344;
i__35245_35267 = G__35345;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__35346 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__35346);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if(((!((node == null)))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__35348 = cljs.core.seq(node);
var chunk__35349 = null;
var count__35350 = (0);
var i__35351 = (0);
while(true){
if((i__35351 < count__35350)){
var n = chunk__35349.cljs$core$IIndexed$_nth$arity$2(null,i__35351);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35352 = seq__35348;
var G__35353 = chunk__35349;
var G__35354 = count__35350;
var G__35355 = (i__35351 + (1));
seq__35348 = G__35352;
chunk__35349 = G__35353;
count__35350 = G__35354;
i__35351 = G__35355;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35348);
if(temp__5457__auto__){
var seq__35348__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35348__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__35348__$1);
var G__35356 = cljs.core.chunk_rest(seq__35348__$1);
var G__35357 = c__4319__auto__;
var G__35358 = cljs.core.count(c__4319__auto__);
var G__35359 = (0);
seq__35348 = G__35356;
chunk__35349 = G__35357;
count__35350 = G__35358;
i__35351 = G__35359;
continue;
} else {
var n = cljs.core.first(seq__35348__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__35360 = cljs.core.next(seq__35348__$1);
var G__35361 = null;
var G__35362 = (0);
var G__35363 = (0);
seq__35348 = G__35360;
chunk__35349 = G__35361;
count__35350 = G__35362;
i__35351 = G__35363;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__35364 = shadow.dom.dom_node(new$);
var G__35365 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__35364,G__35365);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__35367 = arguments.length;
switch (G__35367) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__35370 = arguments.length;
switch (G__35370) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__35384 = arguments.length;
switch (G__35384) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__3922__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(key))].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)].join(''));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4502__auto__ = [];
var len__4499__auto___35405 = arguments.length;
var i__4500__auto___35406 = (0);
while(true){
if((i__4500__auto___35406 < len__4499__auto___35405)){
args__4502__auto__.push((arguments[i__4500__auto___35406]));

var G__35407 = (i__4500__auto___35406 + (1));
i__4500__auto___35406 = G__35407;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__35401_35408 = cljs.core.seq(nodes);
var chunk__35402_35409 = null;
var count__35403_35410 = (0);
var i__35404_35411 = (0);
while(true){
if((i__35404_35411 < count__35403_35410)){
var node_35412 = chunk__35402_35409.cljs$core$IIndexed$_nth$arity$2(null,i__35404_35411);
fragment.appendChild(shadow.dom._to_dom(node_35412));


var G__35413 = seq__35401_35408;
var G__35414 = chunk__35402_35409;
var G__35415 = count__35403_35410;
var G__35416 = (i__35404_35411 + (1));
seq__35401_35408 = G__35413;
chunk__35402_35409 = G__35414;
count__35403_35410 = G__35415;
i__35404_35411 = G__35416;
continue;
} else {
var temp__5457__auto___35417 = cljs.core.seq(seq__35401_35408);
if(temp__5457__auto___35417){
var seq__35401_35418__$1 = temp__5457__auto___35417;
if(cljs.core.chunked_seq_QMARK_(seq__35401_35418__$1)){
var c__4319__auto___35419 = cljs.core.chunk_first(seq__35401_35418__$1);
var G__35420 = cljs.core.chunk_rest(seq__35401_35418__$1);
var G__35421 = c__4319__auto___35419;
var G__35422 = cljs.core.count(c__4319__auto___35419);
var G__35423 = (0);
seq__35401_35408 = G__35420;
chunk__35402_35409 = G__35421;
count__35403_35410 = G__35422;
i__35404_35411 = G__35423;
continue;
} else {
var node_35424 = cljs.core.first(seq__35401_35418__$1);
fragment.appendChild(shadow.dom._to_dom(node_35424));


var G__35425 = cljs.core.next(seq__35401_35418__$1);
var G__35426 = null;
var G__35427 = (0);
var G__35428 = (0);
seq__35401_35408 = G__35425;
chunk__35402_35409 = G__35426;
count__35403_35410 = G__35427;
i__35404_35411 = G__35428;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq35400){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35400));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__35429_35443 = cljs.core.seq(scripts);
var chunk__35430_35444 = null;
var count__35431_35445 = (0);
var i__35432_35446 = (0);
while(true){
if((i__35432_35446 < count__35431_35445)){
var vec__35433_35447 = chunk__35430_35444.cljs$core$IIndexed$_nth$arity$2(null,i__35432_35446);
var script_tag_35448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35433_35447,(0),null);
var script_body_35449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35433_35447,(1),null);
eval(script_body_35449);


var G__35450 = seq__35429_35443;
var G__35451 = chunk__35430_35444;
var G__35452 = count__35431_35445;
var G__35453 = (i__35432_35446 + (1));
seq__35429_35443 = G__35450;
chunk__35430_35444 = G__35451;
count__35431_35445 = G__35452;
i__35432_35446 = G__35453;
continue;
} else {
var temp__5457__auto___35454 = cljs.core.seq(seq__35429_35443);
if(temp__5457__auto___35454){
var seq__35429_35455__$1 = temp__5457__auto___35454;
if(cljs.core.chunked_seq_QMARK_(seq__35429_35455__$1)){
var c__4319__auto___35456 = cljs.core.chunk_first(seq__35429_35455__$1);
var G__35457 = cljs.core.chunk_rest(seq__35429_35455__$1);
var G__35458 = c__4319__auto___35456;
var G__35459 = cljs.core.count(c__4319__auto___35456);
var G__35460 = (0);
seq__35429_35443 = G__35457;
chunk__35430_35444 = G__35458;
count__35431_35445 = G__35459;
i__35432_35446 = G__35460;
continue;
} else {
var vec__35436_35461 = cljs.core.first(seq__35429_35455__$1);
var script_tag_35462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35436_35461,(0),null);
var script_body_35463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35436_35461,(1),null);
eval(script_body_35463);


var G__35464 = cljs.core.next(seq__35429_35455__$1);
var G__35465 = null;
var G__35466 = (0);
var G__35467 = (0);
seq__35429_35443 = G__35464;
chunk__35430_35444 = G__35465;
count__35431_35445 = G__35466;
i__35432_35446 = G__35467;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__35439){
var vec__35440 = p__35439;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35440,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35440,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__35472 = shadow.dom.dom_node(el);
var G__35473 = cls;
return goog.dom.getAncestorByClass(G__35472,G__35473);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35475 = arguments.length;
switch (G__35475) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__35476 = shadow.dom.dom_node(el);
var G__35477 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__35476,G__35477);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__35478 = shadow.dom.dom_node(el);
var G__35479 = cljs.core.name(tag);
var G__35480 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__35478,G__35479,G__35480);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__35482 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__35482);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__35483 = shadow.dom.dom_node(dom);
var G__35484 = value;
return goog.dom.forms.setValue(G__35483,G__35484);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35485 = cljs.core.seq(style_keys);
var chunk__35486 = null;
var count__35487 = (0);
var i__35488 = (0);
while(true){
if((i__35488 < count__35487)){
var it = chunk__35486.cljs$core$IIndexed$_nth$arity$2(null,i__35488);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35489 = seq__35485;
var G__35490 = chunk__35486;
var G__35491 = count__35487;
var G__35492 = (i__35488 + (1));
seq__35485 = G__35489;
chunk__35486 = G__35490;
count__35487 = G__35491;
i__35488 = G__35492;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__35485);
if(temp__5457__auto__){
var seq__35485__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35485__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__35485__$1);
var G__35493 = cljs.core.chunk_rest(seq__35485__$1);
var G__35494 = c__4319__auto__;
var G__35495 = cljs.core.count(c__4319__auto__);
var G__35496 = (0);
seq__35485 = G__35493;
chunk__35486 = G__35494;
count__35487 = G__35495;
i__35488 = G__35496;
continue;
} else {
var it = cljs.core.first(seq__35485__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35497 = cljs.core.next(seq__35485__$1);
var G__35498 = null;
var G__35499 = (0);
var G__35500 = (0);
seq__35485 = G__35497;
chunk__35486 = G__35498;
count__35487 = G__35499;
i__35488 = G__35500;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12143__auto__,k__12144__auto__){
var self__ = this;
var this__12143__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12143__auto____$1,k__12144__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12145__auto__,k35502,else__12146__auto__){
var self__ = this;
var this__12145__auto____$1 = this;
var G__35506 = k35502;
var G__35506__$1 = (((G__35506 instanceof cljs.core.Keyword))?G__35506.fqn:null);
switch (G__35506__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35502,else__12146__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12157__auto__,writer__12158__auto__,opts__12159__auto__){
var self__ = this;
var this__12157__auto____$1 = this;
var pr_pair__12160__auto__ = ((function (this__12157__auto____$1){
return (function (keyval__12161__auto__){
return cljs.core.pr_sequential_writer(writer__12158__auto__,cljs.core.pr_writer,""," ","",opts__12159__auto__,keyval__12161__auto__);
});})(this__12157__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12158__auto__,pr_pair__12160__auto__,"#shadow.dom.Coordinate{",", ","}",opts__12159__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35501){
var self__ = this;
var G__35501__$1 = this;
return (new cljs.core.RecordIter((0),G__35501__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__12141__auto__){
var self__ = this;
var this__12141__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__12138__auto__){
var self__ = this;
var this__12138__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12147__auto__){
var self__ = this;
var this__12147__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__12139__auto__){
var self__ = this;
var this__12139__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = (function (){var fexpr__35516 = ((function (h__4030__auto__,this__12139__auto____$1){
return (function (coll__12140__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__12140__auto__));
});})(h__4030__auto__,this__12139__auto____$1))
;
return fexpr__35516(this__12139__auto____$1);
})();
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35503,other35504){
var self__ = this;
var this35503__$1 = this;
return ((!((other35504 == null))) && ((this35503__$1.constructor === other35504.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35503__$1.x,other35504.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35503__$1.y,other35504.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35503__$1.__extmap,other35504.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12152__auto__,k__12153__auto__){
var self__ = this;
var this__12152__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__12153__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12152__auto____$1),self__.__meta),k__12153__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12153__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12150__auto__,k__12151__auto__,G__35501){
var self__ = this;
var this__12150__auto____$1 = this;
var pred__35518 = cljs.core.keyword_identical_QMARK_;
var expr__35519 = k__12151__auto__;
if(cljs.core.truth_((function (){var G__35521 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__35522 = expr__35519;
return (pred__35518.cljs$core$IFn$_invoke$arity$2 ? pred__35518.cljs$core$IFn$_invoke$arity$2(G__35521,G__35522) : pred__35518.call(null,G__35521,G__35522));
})())){
return (new shadow.dom.Coordinate(G__35501,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__35523 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__35524 = expr__35519;
return (pred__35518.cljs$core$IFn$_invoke$arity$2 ? pred__35518.cljs$core$IFn$_invoke$arity$2(G__35523,G__35524) : pred__35518.call(null,G__35523,G__35524));
})())){
return (new shadow.dom.Coordinate(self__.x,G__35501,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12151__auto__,G__35501),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12155__auto__){
var self__ = this;
var this__12155__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12142__auto__,G__35501){
var self__ = this;
var this__12142__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35501,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12148__auto__,entry__12149__auto__){
var self__ = this;
var this__12148__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12149__auto__)){
return cljs.core._assoc(this__12148__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12149__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12149__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12148__auto____$1,entry__12149__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4208__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4208__auto__,writer__4209__auto__){
return cljs.core._write(writer__4209__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35505){
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35505),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35505),null,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35505,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0))),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__35569 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__35569);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__35579 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__35579);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__35580 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__35580);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12143__auto__,k__12144__auto__){
var self__ = this;
var this__12143__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12143__auto____$1,k__12144__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12145__auto__,k35592,else__12146__auto__){
var self__ = this;
var this__12145__auto____$1 = this;
var G__35607 = k35592;
var G__35607__$1 = (((G__35607 instanceof cljs.core.Keyword))?G__35607.fqn:null);
switch (G__35607__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35592,else__12146__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12157__auto__,writer__12158__auto__,opts__12159__auto__){
var self__ = this;
var this__12157__auto____$1 = this;
var pr_pair__12160__auto__ = ((function (this__12157__auto____$1){
return (function (keyval__12161__auto__){
return cljs.core.pr_sequential_writer(writer__12158__auto__,cljs.core.pr_writer,""," ","",opts__12159__auto__,keyval__12161__auto__);
});})(this__12157__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12158__auto__,pr_pair__12160__auto__,"#shadow.dom.Size{",", ","}",opts__12159__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35591){
var self__ = this;
var G__35591__$1 = this;
return (new cljs.core.RecordIter((0),G__35591__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__12141__auto__){
var self__ = this;
var this__12141__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__12138__auto__){
var self__ = this;
var this__12138__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12147__auto__){
var self__ = this;
var this__12147__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__12139__auto__){
var self__ = this;
var this__12139__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = (function (){var fexpr__35608 = ((function (h__4030__auto__,this__12139__auto____$1){
return (function (coll__12140__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__12140__auto__));
});})(h__4030__auto__,this__12139__auto____$1))
;
return fexpr__35608(this__12139__auto____$1);
})();
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35593,other35594){
var self__ = this;
var this35593__$1 = this;
return ((!((other35594 == null))) && ((this35593__$1.constructor === other35594.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35593__$1.w,other35594.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35593__$1.h,other35594.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35593__$1.__extmap,other35594.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12152__auto__,k__12153__auto__){
var self__ = this;
var this__12152__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__12153__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12152__auto____$1),self__.__meta),k__12153__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12153__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12150__auto__,k__12151__auto__,G__35591){
var self__ = this;
var this__12150__auto____$1 = this;
var pred__35609 = cljs.core.keyword_identical_QMARK_;
var expr__35610 = k__12151__auto__;
if(cljs.core.truth_((function (){var G__35612 = new cljs.core.Keyword(null,"w","w",354169001);
var G__35613 = expr__35610;
return (pred__35609.cljs$core$IFn$_invoke$arity$2 ? pred__35609.cljs$core$IFn$_invoke$arity$2(G__35612,G__35613) : pred__35609.call(null,G__35612,G__35613));
})())){
return (new shadow.dom.Size(G__35591,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__35614 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__35615 = expr__35610;
return (pred__35609.cljs$core$IFn$_invoke$arity$2 ? pred__35609.cljs$core$IFn$_invoke$arity$2(G__35614,G__35615) : pred__35609.call(null,G__35614,G__35615));
})())){
return (new shadow.dom.Size(self__.w,G__35591,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12151__auto__,G__35591),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12155__auto__){
var self__ = this;
var this__12155__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12142__auto__,G__35591){
var self__ = this;
var this__12142__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35591,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12148__auto__,entry__12149__auto__){
var self__ = this;
var this__12148__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12149__auto__)){
return cljs.core._assoc(this__12148__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12149__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12149__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12148__auto____$1,entry__12149__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4208__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4208__auto__,writer__4209__auto__){
return cljs.core._write(writer__4209__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35601){
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35601),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35601),null,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35601,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0))),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__35626 = shadow.dom.dom_node(el);
return goog.style.getSize(G__35626);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4373__auto__ = opts;
var l__4374__auto__ = a__4373__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4374__auto__)){
var G__35627 = (i + (1));
var G__35628 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35627;
ret = G__35628;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35629){
var vec__35630 = p__35629;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35630,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35630,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(k)),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent([cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35634 = arguments.length;
switch (G__35634) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__35636_35638 = new_node;
var G__35637_35639 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__35636_35638,G__35637_35639);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__35640_35642 = new_node;
var G__35641_35643 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__35640_35642,G__35641_35643);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5455__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5455__auto__)){
var child = temp__5455__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35644 = ps;
var G__35645 = (i + (1));
el__$1 = G__35644;
i = G__35645;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__35646 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__35646);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__35647 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__35647);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__35648 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__35648);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__35651 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35651,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35651,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35651,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__35655_35668 = cljs.core.seq(props);
var chunk__35656_35669 = null;
var count__35657_35670 = (0);
var i__35658_35671 = (0);
while(true){
if((i__35658_35671 < count__35657_35670)){
var vec__35659_35672 = chunk__35656_35669.cljs$core$IIndexed$_nth$arity$2(null,i__35658_35671);
var k_35673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35659_35672,(0),null);
var v_35674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35659_35672,(1),null);
el.setAttributeNS((function (){var temp__5457__auto__ = cljs.core.namespace(k_35673);
if(cljs.core.truth_(temp__5457__auto__)){
var ns = temp__5457__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35673),v_35674);


var G__35675 = seq__35655_35668;
var G__35676 = chunk__35656_35669;
var G__35677 = count__35657_35670;
var G__35678 = (i__35658_35671 + (1));
seq__35655_35668 = G__35675;
chunk__35656_35669 = G__35676;
count__35657_35670 = G__35677;
i__35658_35671 = G__35678;
continue;
} else {
var temp__5457__auto___35679 = cljs.core.seq(seq__35655_35668);
if(temp__5457__auto___35679){
var seq__35655_35680__$1 = temp__5457__auto___35679;
if(cljs.core.chunked_seq_QMARK_(seq__35655_35680__$1)){
var c__4319__auto___35681 = cljs.core.chunk_first(seq__35655_35680__$1);
var G__35682 = cljs.core.chunk_rest(seq__35655_35680__$1);
var G__35683 = c__4319__auto___35681;
var G__35684 = cljs.core.count(c__4319__auto___35681);
var G__35685 = (0);
seq__35655_35668 = G__35682;
chunk__35656_35669 = G__35683;
count__35657_35670 = G__35684;
i__35658_35671 = G__35685;
continue;
} else {
var vec__35664_35686 = cljs.core.first(seq__35655_35680__$1);
var k_35687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35664_35686,(0),null);
var v_35688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35664_35686,(1),null);
el.setAttributeNS((function (){var temp__5457__auto____$1 = cljs.core.namespace(k_35687);
if(cljs.core.truth_(temp__5457__auto____$1)){
var ns = temp__5457__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35687),v_35688);


var G__35689 = cljs.core.next(seq__35655_35680__$1);
var G__35690 = null;
var G__35691 = (0);
var G__35692 = (0);
seq__35655_35668 = G__35689;
chunk__35656_35669 = G__35690;
count__35657_35670 = G__35691;
i__35658_35671 = G__35692;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if(((!((el == null)))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__35694 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35694,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35694,(1),null);
var seq__35697_35716 = cljs.core.seq(node_children);
var chunk__35699_35717 = null;
var count__35700_35718 = (0);
var i__35701_35719 = (0);
while(true){
if((i__35701_35719 < count__35700_35718)){
var child_struct_35720 = chunk__35699_35717.cljs$core$IIndexed$_nth$arity$2(null,i__35701_35719);
if(!((child_struct_35720 == null))){
if(typeof child_struct_35720 === 'string'){
var text_35721 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35721),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_35720)].join(''));
} else {
var children_35722 = shadow.dom.svg_node(child_struct_35720);
if(cljs.core.seq_QMARK_(children_35722)){
var seq__35703_35723 = cljs.core.seq(children_35722);
var chunk__35705_35724 = null;
var count__35706_35725 = (0);
var i__35707_35726 = (0);
while(true){
if((i__35707_35726 < count__35706_35725)){
var child_35727 = chunk__35705_35724.cljs$core$IIndexed$_nth$arity$2(null,i__35707_35726);
if(cljs.core.truth_(child_35727)){
node.appendChild(child_35727);


var G__35728 = seq__35703_35723;
var G__35729 = chunk__35705_35724;
var G__35730 = count__35706_35725;
var G__35731 = (i__35707_35726 + (1));
seq__35703_35723 = G__35728;
chunk__35705_35724 = G__35729;
count__35706_35725 = G__35730;
i__35707_35726 = G__35731;
continue;
} else {
var G__35732 = seq__35703_35723;
var G__35733 = chunk__35705_35724;
var G__35734 = count__35706_35725;
var G__35735 = (i__35707_35726 + (1));
seq__35703_35723 = G__35732;
chunk__35705_35724 = G__35733;
count__35706_35725 = G__35734;
i__35707_35726 = G__35735;
continue;
}
} else {
var temp__5457__auto___35736 = cljs.core.seq(seq__35703_35723);
if(temp__5457__auto___35736){
var seq__35703_35737__$1 = temp__5457__auto___35736;
if(cljs.core.chunked_seq_QMARK_(seq__35703_35737__$1)){
var c__4319__auto___35738 = cljs.core.chunk_first(seq__35703_35737__$1);
var G__35739 = cljs.core.chunk_rest(seq__35703_35737__$1);
var G__35740 = c__4319__auto___35738;
var G__35741 = cljs.core.count(c__4319__auto___35738);
var G__35742 = (0);
seq__35703_35723 = G__35739;
chunk__35705_35724 = G__35740;
count__35706_35725 = G__35741;
i__35707_35726 = G__35742;
continue;
} else {
var child_35744 = cljs.core.first(seq__35703_35737__$1);
if(cljs.core.truth_(child_35744)){
node.appendChild(child_35744);


var G__35745 = cljs.core.next(seq__35703_35737__$1);
var G__35746 = null;
var G__35747 = (0);
var G__35748 = (0);
seq__35703_35723 = G__35745;
chunk__35705_35724 = G__35746;
count__35706_35725 = G__35747;
i__35707_35726 = G__35748;
continue;
} else {
var G__35750 = cljs.core.next(seq__35703_35737__$1);
var G__35751 = null;
var G__35752 = (0);
var G__35753 = (0);
seq__35703_35723 = G__35750;
chunk__35705_35724 = G__35751;
count__35706_35725 = G__35752;
i__35707_35726 = G__35753;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35722);
}
}


var G__35754 = seq__35697_35716;
var G__35755 = chunk__35699_35717;
var G__35756 = count__35700_35718;
var G__35757 = (i__35701_35719 + (1));
seq__35697_35716 = G__35754;
chunk__35699_35717 = G__35755;
count__35700_35718 = G__35756;
i__35701_35719 = G__35757;
continue;
} else {
var G__35758 = seq__35697_35716;
var G__35759 = chunk__35699_35717;
var G__35760 = count__35700_35718;
var G__35761 = (i__35701_35719 + (1));
seq__35697_35716 = G__35758;
chunk__35699_35717 = G__35759;
count__35700_35718 = G__35760;
i__35701_35719 = G__35761;
continue;
}
} else {
var temp__5457__auto___35762 = cljs.core.seq(seq__35697_35716);
if(temp__5457__auto___35762){
var seq__35697_35763__$1 = temp__5457__auto___35762;
if(cljs.core.chunked_seq_QMARK_(seq__35697_35763__$1)){
var c__4319__auto___35764 = cljs.core.chunk_first(seq__35697_35763__$1);
var G__35765 = cljs.core.chunk_rest(seq__35697_35763__$1);
var G__35766 = c__4319__auto___35764;
var G__35767 = cljs.core.count(c__4319__auto___35764);
var G__35768 = (0);
seq__35697_35716 = G__35765;
chunk__35699_35717 = G__35766;
count__35700_35718 = G__35767;
i__35701_35719 = G__35768;
continue;
} else {
var child_struct_35769 = cljs.core.first(seq__35697_35763__$1);
if(!((child_struct_35769 == null))){
if(typeof child_struct_35769 === 'string'){
var text_35770 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35770),cljs.core.str.cljs$core$IFn$_invoke$arity$1(child_struct_35769)].join(''));
} else {
var children_35771 = shadow.dom.svg_node(child_struct_35769);
if(cljs.core.seq_QMARK_(children_35771)){
var seq__35709_35772 = cljs.core.seq(children_35771);
var chunk__35711_35773 = null;
var count__35712_35774 = (0);
var i__35713_35775 = (0);
while(true){
if((i__35713_35775 < count__35712_35774)){
var child_35776 = chunk__35711_35773.cljs$core$IIndexed$_nth$arity$2(null,i__35713_35775);
if(cljs.core.truth_(child_35776)){
node.appendChild(child_35776);


var G__35777 = seq__35709_35772;
var G__35778 = chunk__35711_35773;
var G__35779 = count__35712_35774;
var G__35780 = (i__35713_35775 + (1));
seq__35709_35772 = G__35777;
chunk__35711_35773 = G__35778;
count__35712_35774 = G__35779;
i__35713_35775 = G__35780;
continue;
} else {
var G__35781 = seq__35709_35772;
var G__35782 = chunk__35711_35773;
var G__35783 = count__35712_35774;
var G__35784 = (i__35713_35775 + (1));
seq__35709_35772 = G__35781;
chunk__35711_35773 = G__35782;
count__35712_35774 = G__35783;
i__35713_35775 = G__35784;
continue;
}
} else {
var temp__5457__auto___35785__$1 = cljs.core.seq(seq__35709_35772);
if(temp__5457__auto___35785__$1){
var seq__35709_35786__$1 = temp__5457__auto___35785__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35709_35786__$1)){
var c__4319__auto___35787 = cljs.core.chunk_first(seq__35709_35786__$1);
var G__35788 = cljs.core.chunk_rest(seq__35709_35786__$1);
var G__35789 = c__4319__auto___35787;
var G__35790 = cljs.core.count(c__4319__auto___35787);
var G__35791 = (0);
seq__35709_35772 = G__35788;
chunk__35711_35773 = G__35789;
count__35712_35774 = G__35790;
i__35713_35775 = G__35791;
continue;
} else {
var child_35792 = cljs.core.first(seq__35709_35786__$1);
if(cljs.core.truth_(child_35792)){
node.appendChild(child_35792);


var G__35793 = cljs.core.next(seq__35709_35786__$1);
var G__35794 = null;
var G__35795 = (0);
var G__35796 = (0);
seq__35709_35772 = G__35793;
chunk__35711_35773 = G__35794;
count__35712_35774 = G__35795;
i__35713_35775 = G__35796;
continue;
} else {
var G__35797 = cljs.core.next(seq__35709_35786__$1);
var G__35798 = null;
var G__35799 = (0);
var G__35800 = (0);
seq__35709_35772 = G__35797;
chunk__35711_35773 = G__35798;
count__35712_35774 = G__35799;
i__35713_35775 = G__35800;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35771);
}
}


var G__35801 = cljs.core.next(seq__35697_35763__$1);
var G__35802 = null;
var G__35803 = (0);
var G__35804 = (0);
seq__35697_35716 = G__35801;
chunk__35699_35717 = G__35802;
count__35700_35718 = G__35803;
i__35701_35719 = G__35804;
continue;
} else {
var G__35805 = cljs.core.next(seq__35697_35763__$1);
var G__35806 = null;
var G__35807 = (0);
var G__35808 = (0);
seq__35697_35716 = G__35805;
chunk__35699_35717 = G__35806;
count__35700_35718 = G__35807;
i__35701_35719 = G__35808;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__35809_35815 = shadow.dom._to_svg;
var G__35810_35816 = "string";
var G__35811_35817 = ((function (G__35809_35815,G__35810_35816){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__35809_35815,G__35810_35816))
;
goog.object.set(G__35809_35815,G__35810_35816,G__35811_35817);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__35812_35818 = shadow.dom._to_svg;
var G__35813_35819 = "null";
var G__35814_35820 = ((function (G__35812_35818,G__35813_35819){
return (function (_){
return null;
});})(G__35812_35818,G__35813_35819))
;
goog.object.set(G__35812_35818,G__35813_35819,G__35814_35820);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4502__auto__ = [];
var len__4499__auto___35823 = arguments.length;
var i__4500__auto___35824 = (0);
while(true){
if((i__4500__auto___35824 < len__4499__auto___35823)){
args__4502__auto__.push((arguments[i__4500__auto___35824]));

var G__35825 = (i__4500__auto___35824 + (1));
i__4500__auto___35824 = G__35825;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq35821){
var G__35822 = cljs.core.first(seq35821);
var seq35821__$1 = cljs.core.next(seq35821);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35822,seq35821__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__35827 = arguments.length;
switch (G__35827) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__35839_35860 = shadow.dom.dom_node(el);
var G__35840_35861 = cljs.core.name(event);
var G__35841_35862 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__35839_35860,G__35840_35861,G__35841_35862) : shadow.dom.dom_listen.call(null,G__35839_35860,G__35840_35861,G__35841_35862));

if(cljs.core.truth_((function (){var and__3911__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__3911__auto__)){
return !(once_or_cleanup === true);
} else {
return and__3911__auto__;
}
})())){
var c__32612__auto___35863 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___35863,buf,chan,event_fn){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___35863,buf,chan,event_fn){
return (function (state_35847){
var state_val_35848 = (state_35847[(1)]);
if((state_val_35848 === (1))){
var state_35847__$1 = state_35847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35847__$1,(2),once_or_cleanup);
} else {
if((state_val_35848 === (2))){
var inst_35844 = (state_35847[(2)]);
var inst_35845 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_35847__$1 = (function (){var statearr_35849 = state_35847;
(statearr_35849[(7)] = inst_35844);

return statearr_35849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_35847__$1,inst_35845);
} else {
return null;
}
}
});})(c__32612__auto___35863,buf,chan,event_fn))
;
return ((function (switch__32540__auto__,c__32612__auto___35863,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__32541__auto__ = null;
var shadow$dom$state_machine__32541__auto____0 = (function (){
var statearr_35851 = [null,null,null,null,null,null,null,null];
(statearr_35851[(0)] = shadow$dom$state_machine__32541__auto__);

(statearr_35851[(1)] = (1));

return statearr_35851;
});
var shadow$dom$state_machine__32541__auto____1 = (function (state_35847){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_35847);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e35854){if((e35854 instanceof Object)){
var ex__32544__auto__ = e35854;
var statearr_35856_35867 = state_35847;
(statearr_35856_35867[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35854;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35868 = state_35847;
state_35847 = G__35868;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
shadow$dom$state_machine__32541__auto__ = function(state_35847){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__32541__auto____0.call(this);
case 1:
return shadow$dom$state_machine__32541__auto____1.call(this,state_35847);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
shadow$dom$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__32541__auto____0;
shadow$dom$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__32541__auto____1;
return shadow$dom$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___35863,buf,chan,event_fn))
})();
var state__32614__auto__ = (function (){var statearr_35857 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_35857[(6)] = c__32612__auto___35863);

return statearr_35857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___35863,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
