goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if(typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined'){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if(typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined'){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if(typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined'){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4502__auto__ = [];
var len__4499__auto___37868 = arguments.length;
var i__4500__auto___37869 = (0);
while(true){
if((i__4500__auto___37869 < len__4499__auto___37868)){
args__4502__auto__.push((arguments[i__4500__auto___37869]));

var G__37870 = (i__4500__auto___37869 + (1));
i__4500__auto___37869 = G__37870;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq37866){
var G__37867 = cljs.core.first(seq37866);
var seq37866__$1 = cljs.core.next(seq37866);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37867,seq37866__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5455__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5455__auto__)){
var s = temp__5455__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if(typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined'){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__37875){
var map__37876 = p__37875;
var map__37876__$1 = ((((!((map__37876 == null)))?(((((map__37876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37876):map__37876);
var src = map__37876__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37876__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37876__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__3922__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__3922__auto__){
return or__3922__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__37887 = cljs.core.seq(sources);
var chunk__37888 = null;
var count__37889 = (0);
var i__37890 = (0);
while(true){
if((i__37890 < count__37889)){
var map__37891 = chunk__37888.cljs$core$IIndexed$_nth$arity$2(null,i__37890);
var map__37891__$1 = ((((!((map__37891 == null)))?(((((map__37891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37891.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37891):map__37891);
var src = map__37891__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37891__$1,new cljs.core.Keyword(null,"js","js",1768080579));
SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__37906 = seq__37887;
var G__37907 = chunk__37888;
var G__37908 = count__37889;
var G__37909 = (i__37890 + (1));
seq__37887 = G__37906;
chunk__37888 = G__37907;
count__37889 = G__37908;
i__37890 = G__37909;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__37887);
if(temp__5457__auto__){
var seq__37887__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__37887__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__37887__$1);
var G__37910 = cljs.core.chunk_rest(seq__37887__$1);
var G__37911 = c__4319__auto__;
var G__37912 = cljs.core.count(c__4319__auto__);
var G__37913 = (0);
seq__37887 = G__37910;
chunk__37888 = G__37911;
count__37889 = G__37912;
i__37890 = G__37913;
continue;
} else {
var map__37898 = cljs.core.first(seq__37887__$1);
var map__37898__$1 = ((((!((map__37898 == null)))?(((((map__37898.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37898.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37898):map__37898);
var src = map__37898__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37898__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37898__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37898__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37898__$1,new cljs.core.Keyword(null,"js","js",1768080579));
SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__37923 = cljs.core.next(seq__37887__$1);
var G__37924 = null;
var G__37925 = (0);
var G__37926 = (0);
seq__37887 = G__37923;
chunk__37888 = G__37924;
count__37889 = G__37925;
i__37890 = G__37926;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__37941 = cljs.core.seq(js_requires);
var chunk__37942 = null;
var count__37943 = (0);
var i__37944 = (0);
while(true){
if((i__37944 < count__37943)){
var js_ns = chunk__37942.cljs$core$IIndexed$_nth$arity$2(null,i__37944);
var require_str_37950 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_37950);


var G__37951 = seq__37941;
var G__37952 = chunk__37942;
var G__37953 = count__37943;
var G__37954 = (i__37944 + (1));
seq__37941 = G__37951;
chunk__37942 = G__37952;
count__37943 = G__37953;
i__37944 = G__37954;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__37941);
if(temp__5457__auto__){
var seq__37941__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__37941__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__37941__$1);
var G__37955 = cljs.core.chunk_rest(seq__37941__$1);
var G__37956 = c__4319__auto__;
var G__37957 = cljs.core.count(c__4319__auto__);
var G__37958 = (0);
seq__37941 = G__37955;
chunk__37942 = G__37956;
count__37943 = G__37957;
i__37944 = G__37958;
continue;
} else {
var js_ns = cljs.core.first(seq__37941__$1);
var require_str_37959 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_37959);


var G__37960 = cljs.core.next(seq__37941__$1);
var G__37961 = null;
var G__37962 = (0);
var G__37963 = (0);
seq__37941 = G__37960;
chunk__37942 = G__37961;
count__37943 = G__37962;
i__37944 = G__37963;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__37964 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__37964) : callback.call(null,G__37964));
} else {
var G__37966 = shadow.cljs.devtools.client.env.files_url();
var G__37967 = ((function (G__37966){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__37966))
;
var G__37968 = "POST";
var G__37969 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__37970 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__37966,G__37967,G__37968,G__37969,G__37970);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__37982){
var map__37983 = p__37982;
var map__37983__$1 = ((((!((map__37983 == null)))?(((((map__37983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37983.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37983):map__37983);
var msg = map__37983__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37983__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37983__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__37986 = info;
var map__37986__$1 = ((((!((map__37986 == null)))?(((((map__37986.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37986.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37986):map__37986);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37986__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37986__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4292__auto__ = ((function (map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__37992(s__37993){
return (new cljs.core.LazySeq(null,((function (map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info){
return (function (){
var s__37993__$1 = s__37993;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__37993__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var map__37998 = cljs.core.first(xs__6012__auto__);
var map__37998__$1 = ((((!((map__37998 == null)))?(((((map__37998.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37998.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37998):map__37998);
var src = map__37998__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37998__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37998__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4288__auto__ = ((function (s__37993__$1,map__37998,map__37998__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__37992_$_iter__37994(s__37995){
return (new cljs.core.LazySeq(null,((function (s__37993__$1,map__37998,map__37998__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info){
return (function (){
var s__37995__$1 = s__37995;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__37995__$1);
if(temp__5457__auto____$1){
var s__37995__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__37995__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__37995__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__37997 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__37996 = (0);
while(true){
if((i__37996 < size__4291__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__37996);
cljs.core.chunk_append(b__37997,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__38074 = (i__37996 + (1));
i__37996 = G__38074;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37997),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__37992_$_iter__37994(cljs.core.chunk_rest(s__37995__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37997),null);
}
} else {
var warning = cljs.core.first(s__37995__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__37992_$_iter__37994(cljs.core.rest(s__37995__$2)));
}
} else {
return null;
}
break;
}
});})(s__37993__$1,map__37998,map__37998__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info))
,null,null));
});})(s__37993__$1,map__37998,map__37998__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info))
;
var fs__4289__auto__ = cljs.core.seq(iterys__4288__auto__(warnings));
if(fs__4289__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4289__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__37992(cljs.core.rest(s__37993__$1)));
} else {
var G__38075 = cljs.core.rest(s__37993__$1);
s__37993__$1 = G__38075;
continue;
}
} else {
var G__38076 = cljs.core.rest(s__37993__$1);
s__37993__$1 = G__38076;
continue;
}
} else {
return null;
}
break;
}
});})(map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info))
,null,null));
});})(map__37986,map__37986__$1,sources,compiled,map__37983,map__37983__$1,msg,info,reload_info))
;
return iter__4292__auto__(sources);
})()));
var seq__38007_38080 = cljs.core.seq(warnings);
var chunk__38008_38081 = null;
var count__38009_38082 = (0);
var i__38010_38083 = (0);
while(true){
if((i__38010_38083 < count__38009_38082)){
var map__38012_38084 = chunk__38008_38081.cljs$core$IIndexed$_nth$arity$2(null,i__38010_38083);
var map__38012_38085__$1 = ((((!((map__38012_38084 == null)))?(((((map__38012_38084.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38012_38084.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38012_38084):map__38012_38084);
var w_38086 = map__38012_38085__$1;
var msg_38087__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38012_38085__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_38088 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38012_38085__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_38089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38012_38085__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_38090 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38012_38085__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_38090)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_38088),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_38089),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_38087__$1)].join(''));


var G__38095 = seq__38007_38080;
var G__38096 = chunk__38008_38081;
var G__38097 = count__38009_38082;
var G__38098 = (i__38010_38083 + (1));
seq__38007_38080 = G__38095;
chunk__38008_38081 = G__38096;
count__38009_38082 = G__38097;
i__38010_38083 = G__38098;
continue;
} else {
var temp__5457__auto___38102 = cljs.core.seq(seq__38007_38080);
if(temp__5457__auto___38102){
var seq__38007_38103__$1 = temp__5457__auto___38102;
if(cljs.core.chunked_seq_QMARK_(seq__38007_38103__$1)){
var c__4319__auto___38104 = cljs.core.chunk_first(seq__38007_38103__$1);
var G__38105 = cljs.core.chunk_rest(seq__38007_38103__$1);
var G__38106 = c__4319__auto___38104;
var G__38107 = cljs.core.count(c__4319__auto___38104);
var G__38108 = (0);
seq__38007_38080 = G__38105;
chunk__38008_38081 = G__38106;
count__38009_38082 = G__38107;
i__38010_38083 = G__38108;
continue;
} else {
var map__38018_38109 = cljs.core.first(seq__38007_38103__$1);
var map__38018_38110__$1 = ((((!((map__38018_38109 == null)))?(((((map__38018_38109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38018_38109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38018_38109):map__38018_38109);
var w_38111 = map__38018_38110__$1;
var msg_38112__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38018_38110__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_38113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38018_38110__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_38114 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38018_38110__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_38115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38018_38110__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_38115)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_38113),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_38114),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_38112__$1)].join(''));


var G__38116 = cljs.core.next(seq__38007_38103__$1);
var G__38117 = null;
var G__38118 = (0);
var G__38119 = (0);
seq__38007_38080 = G__38116;
chunk__38008_38081 = G__38117;
count__38009_38082 = G__38118;
i__38010_38083 = G__38119;
continue;
}
} else {
}
}
break;
}

if(!(shadow.cljs.devtools.client.env.autoload)){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info){
return (function (p__38034){
var map__38038 = p__38034;
var map__38038__$1 = ((((!((map__38038 == null)))?(((((map__38038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38038):map__38038);
var src = map__38038__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38038__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38038__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info){
return (function (p__38051){
var map__38052 = p__38051;
var map__38052__$1 = ((((!((map__38052 == null)))?(((((map__38052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38052.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38052):map__38052);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38052__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info){
return (function (p__38059){
var map__38060 = p__38059;
var map__38060__$1 = ((((!((map__38060 == null)))?(((((map__38060.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38060.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38060):map__38060);
var rc = map__38060__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38060__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var or__3922__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format);
if(or__3922__auto__){
return or__3922__auto__;
} else {
return shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module);
}
});})(map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info){
return (function (p1__37981_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__37981_SHARP_,shadow.cljs.devtools.client.hud.load_end_success);
});})(sources_to_get,map__37986,map__37986__$1,sources,compiled,warnings,map__37983,map__37983__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__38129){
var map__38130 = p__38129;
var map__38130__$1 = ((((!((map__38130 == null)))?(((((map__38130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38130.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38130):map__38130);
var msg = map__38130__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38130__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__38132 = cljs.core.seq(updates);
var chunk__38134 = null;
var count__38135 = (0);
var i__38136 = (0);
while(true){
if((i__38136 < count__38135)){
var path = chunk__38134.cljs$core$IIndexed$_nth$arity$2(null,i__38136);
if(clojure.string.ends_with_QMARK_(path,"css")){
var temp__5457__auto___38148 = document.querySelector(["link[href^=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"\"]"].join(''));
if(cljs.core.truth_(temp__5457__auto___38148)){
var node_38149 = temp__5457__auto___38148;
var new_link_38150 = (function (){var G__38140 = document.createElement("link");
G__38140.setAttribute("rel","stylesheet");

G__38140.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__38140;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_38150,node_38149);

goog.dom.removeNode(node_38149);
} else {
}


var G__38151 = seq__38132;
var G__38152 = chunk__38134;
var G__38153 = count__38135;
var G__38154 = (i__38136 + (1));
seq__38132 = G__38151;
chunk__38134 = G__38152;
count__38135 = G__38153;
i__38136 = G__38154;
continue;
} else {
var G__38155 = seq__38132;
var G__38156 = chunk__38134;
var G__38157 = count__38135;
var G__38158 = (i__38136 + (1));
seq__38132 = G__38155;
chunk__38134 = G__38156;
count__38135 = G__38157;
i__38136 = G__38158;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__38132);
if(temp__5457__auto__){
var seq__38132__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38132__$1)){
var c__4319__auto__ = cljs.core.chunk_first(seq__38132__$1);
var G__38159 = cljs.core.chunk_rest(seq__38132__$1);
var G__38160 = c__4319__auto__;
var G__38161 = cljs.core.count(c__4319__auto__);
var G__38162 = (0);
seq__38132 = G__38159;
chunk__38134 = G__38160;
count__38135 = G__38161;
i__38136 = G__38162;
continue;
} else {
var path = cljs.core.first(seq__38132__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var temp__5457__auto___38168__$1 = document.querySelector(["link[href^=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"\"]"].join(''));
if(cljs.core.truth_(temp__5457__auto___38168__$1)){
var node_38169 = temp__5457__auto___38168__$1;
var new_link_38170 = (function (){var G__38145 = document.createElement("link");
G__38145.setAttribute("rel","stylesheet");

G__38145.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__38145;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_38170,node_38169);

goog.dom.removeNode(node_38169);
} else {
}


var G__38171 = cljs.core.next(seq__38132__$1);
var G__38172 = null;
var G__38173 = (0);
var G__38174 = (0);
seq__38132 = G__38171;
chunk__38134 = G__38172;
count__38135 = G__38173;
i__38136 = G__38174;
continue;
} else {
var G__38175 = cljs.core.next(seq__38132__$1);
var G__38176 = null;
var G__38177 = (0);
var G__38178 = (0);
seq__38132 = G__38175;
chunk__38134 = G__38176;
count__38135 = G__38177;
i__38136 = G__38178;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__38189){
var map__38190 = p__38189;
var map__38190__$1 = ((((!((map__38190 == null)))?(((((map__38190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38190.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38190):map__38190);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38190__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38190__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__38190,map__38190__$1,id,js){
return (function (){
return eval(js);
});})(map__38190,map__38190__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__38217){
var map__38218 = p__38217;
var map__38218__$1 = ((((!((map__38218 == null)))?(((((map__38218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38218.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38218):map__38218);
var msg = map__38218__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38218__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38218__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38218__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38218__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__38218,map__38218__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__38221){
var map__38223 = p__38221;
var map__38223__$1 = ((((!((map__38223 == null)))?(((((map__38223.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38223.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38223):map__38223);
var src = map__38223__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38223__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__3911__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__3911__auto__;
}
});})(map__38218,map__38218__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__38218,map__38218__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
});})(sources_to_load,map__38218,map__38218__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__38246){
var map__38248 = p__38246;
var map__38248__$1 = ((((!((map__38248 == null)))?(((((map__38248.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38248.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38248):map__38248);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38248__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38248__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(repl_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603),new cljs.core.Keyword(null,"ns","ns",441598760)], null)));

return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__38248,map__38248__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg("REPL init successful");
});})(map__38248,map__38248__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__38267){
var map__38268 = p__38267;
var map__38268__$1 = ((((!((map__38268 == null)))?(((((map__38268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38268):map__38268);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38268__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38268__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,ns);

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__38287){
var map__38289 = p__38287;
var map__38289__$1 = ((((!((map__38289 == null)))?(((((map__38289.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38289.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38289):map__38289);
var msg = map__38289__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38289__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var G__38291 = type;
var G__38291__$1 = (((G__38291 instanceof cljs.core.Keyword))?G__38291.fqn:null);
switch (G__38291__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require(msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init(msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

return shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

return shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

return shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"\" not running"].join(''));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__38297 = ["http",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((shadow.cljs.devtools.client.env.ssl)?"s":null)),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/browser"].join('');
var G__38298 = ((function (G__38297){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__38297))
;
var G__38299 = "POST";
var G__38300 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__38301 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__38297,G__38298,G__38299,G__38300,G__38301);
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)], 0)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__3922__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5457__auto___38367 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto___38367)){
var s_38368 = temp__5457__auto___38367;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_38368.onclose = ((function (s_38368,temp__5457__auto___38367){
return (function (e){
return null;
});})(s_38368,temp__5457__auto___38367))
;

s_38368.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close();
} else {
return null;
}
}));

shadow.cljs.devtools.client.browser.ws_connect();
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
