goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__28780__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__28777 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__28778 = cljs.core.seq(vec__28777);
var first__28779 = cljs.core.first(seq__28778);
var seq__28778__$1 = cljs.core.next(seq__28778);
var tag = first__28779;
var body = seq__28778__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__28780 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__28781__i = 0, G__28781__a = new Array(arguments.length -  0);
while (G__28781__i < G__28781__a.length) {G__28781__a[G__28781__i] = arguments[G__28781__i + 0]; ++G__28781__i;}
  args = new cljs.core.IndexedSeq(G__28781__a,0,null);
} 
return G__28780__delegate.call(this,args);};
G__28780.cljs$lang$maxFixedArity = 0;
G__28780.cljs$lang$applyTo = (function (arglist__28782){
var args = cljs.core.seq(arglist__28782);
return G__28780__delegate(args);
});
G__28780.cljs$core$IFn$_invoke$arity$variadic = G__28780__delegate;
return G__28780;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4292__auto__ = (function sablono$core$update_arglists_$_iter__28785(s__28786){
return (new cljs.core.LazySeq(null,(function (){
var s__28786__$1 = s__28786;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__28786__$1);
if(temp__5457__auto__){
var s__28786__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28786__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__28786__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__28788 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__28787 = (0);
while(true){
if((i__28787 < size__4291__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__28787);
cljs.core.chunk_append(b__28788,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__28797 = (i__28787 + (1));
i__28787 = G__28797;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28788),sablono$core$update_arglists_$_iter__28785(cljs.core.chunk_rest(s__28786__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28788),null);
}
} else {
var args = cljs.core.first(s__28786__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__28785(cljs.core.rest(s__28786__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4502__auto__ = [];
var len__4499__auto___28804 = arguments.length;
var i__4500__auto___28805 = (0);
while(true){
if((i__4500__auto___28805 < len__4499__auto___28804)){
args__4502__auto__.push((arguments[i__4500__auto___28805]));

var G__28806 = (i__4500__auto___28805 + (1));
i__4500__auto___28805 = G__28806;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4292__auto__ = (function sablono$core$iter__28800(s__28801){
return (new cljs.core.LazySeq(null,(function (){
var s__28801__$1 = s__28801;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__28801__$1);
if(temp__5457__auto__){
var s__28801__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28801__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__28801__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__28803 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__28802 = (0);
while(true){
if((i__28802 < size__4291__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__28802);
cljs.core.chunk_append(b__28803,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__28807 = (i__28802 + (1));
i__28802 = G__28807;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28803),sablono$core$iter__28800(cljs.core.chunk_rest(s__28801__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28803),null);
}
} else {
var style = cljs.core.first(s__28801__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__28800(cljs.core.rest(s__28801__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
sablono.core.include_css.cljs$lang$applyTo = (function (seq28799){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28799));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__28812 = goog.dom.getDocument().body;
var G__28813 = (function (){var G__28814 = "script";
var G__28815 = ({"src": src});
return goog.dom.createDom(G__28814,G__28815);
})();
return goog.dom.appendChild(G__28812,G__28813);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to28827 = (function sablono$core$link_to28827(var_args){
var args__4502__auto__ = [];
var len__4499__auto___28844 = arguments.length;
var i__4500__auto___28845 = (0);
while(true){
if((i__4500__auto___28845 < len__4499__auto___28844)){
args__4502__auto__.push((arguments[i__4500__auto___28845]));

var G__28846 = (i__4500__auto___28845 + (1));
i__4500__auto___28845 = G__28846;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to28827.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

sablono.core.link_to28827.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
});

sablono.core.link_to28827.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.link_to28827.cljs$lang$applyTo = (function (seq28831){
var G__28832 = cljs.core.first(seq28831);
var seq28831__$1 = cljs.core.next(seq28831);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28832,seq28831__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to28827);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to28848 = (function sablono$core$mail_to28848(var_args){
var args__4502__auto__ = [];
var len__4499__auto___28860 = arguments.length;
var i__4500__auto___28861 = (0);
while(true){
if((i__4500__auto___28861 < len__4499__auto___28860)){
args__4502__auto__.push((arguments[i__4500__auto___28861]));

var G__28862 = (i__4500__auto___28861 + (1));
i__4500__auto___28861 = G__28862;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to28848.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

sablono.core.mail_to28848.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__28852){
var vec__28853 = p__28852;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28853,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__3922__auto__ = content;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to28848.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.mail_to28848.cljs$lang$applyTo = (function (seq28849){
var G__28850 = cljs.core.first(seq28849);
var seq28849__$1 = cljs.core.next(seq28849);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28850,seq28849__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to28848);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list28873 = (function sablono$core$unordered_list28873(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4292__auto__ = (function sablono$core$unordered_list28873_$_iter__28875(s__28876){
return (new cljs.core.LazySeq(null,(function (){
var s__28876__$1 = s__28876;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__28876__$1);
if(temp__5457__auto__){
var s__28876__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28876__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__28876__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__28878 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__28877 = (0);
while(true){
if((i__28877 < size__4291__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__28877);
cljs.core.chunk_append(b__28878,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__28894 = (i__28877 + (1));
i__28877 = G__28894;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28878),sablono$core$unordered_list28873_$_iter__28875(cljs.core.chunk_rest(s__28876__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28878),null);
}
} else {
var x = cljs.core.first(s__28876__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list28873_$_iter__28875(cljs.core.rest(s__28876__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list28873);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list28895 = (function sablono$core$ordered_list28895(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4292__auto__ = (function sablono$core$ordered_list28895_$_iter__28896(s__28897){
return (new cljs.core.LazySeq(null,(function (){
var s__28897__$1 = s__28897;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__28897__$1);
if(temp__5457__auto__){
var s__28897__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__28897__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__28897__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__28899 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__28898 = (0);
while(true){
if((i__28898 < size__4291__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__28898);
cljs.core.chunk_append(b__28899,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__28903 = (i__28898 + (1));
i__28898 = G__28903;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__28899),sablono$core$ordered_list28895_$_iter__28896(cljs.core.chunk_rest(s__28897__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__28899),null);
}
} else {
var x = cljs.core.first(s__28897__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list28895_$_iter__28896(cljs.core.rest(s__28897__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list28895);
/**
 * Create an image element.
 */
sablono.core.image28904 = (function sablono$core$image28904(var_args){
var G__28906 = arguments.length;
switch (G__28906) {
case 1:
return sablono.core.image28904.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image28904.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image28904.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
});

sablono.core.image28904.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image28904.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image28904);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__28908_SHARP_,p2__28909_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28908_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__28909_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__28915_SHARP_,p2__28916_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__28915_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__28916_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__28922 = arguments.length;
switch (G__28922) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__3922__auto__ = value;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Creates a color input field.
 */
sablono.core.color_field28931 = (function sablono$core$color_field28931(var_args){
var G__28933 = arguments.length;
switch (G__28933) {
case 1:
return sablono.core.color_field28931.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field28931.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field28931.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__28769__auto__);
});

sablono.core.color_field28931.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.color_field28931.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field28931);

/**
 * Creates a date input field.
 */
sablono.core.date_field28938 = (function sablono$core$date_field28938(var_args){
var G__28940 = arguments.length;
switch (G__28940) {
case 1:
return sablono.core.date_field28938.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field28938.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field28938.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__28769__auto__);
});

sablono.core.date_field28938.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.date_field28938.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field28938);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field28944 = (function sablono$core$datetime_field28944(var_args){
var G__28950 = arguments.length;
switch (G__28950) {
case 1:
return sablono.core.datetime_field28944.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field28944.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field28944.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__28769__auto__);
});

sablono.core.datetime_field28944.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.datetime_field28944.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field28944);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field28958 = (function sablono$core$datetime_local_field28958(var_args){
var G__28960 = arguments.length;
switch (G__28960) {
case 1:
return sablono.core.datetime_local_field28958.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field28958.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field28958.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__28769__auto__);
});

sablono.core.datetime_local_field28958.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.datetime_local_field28958.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field28958);

/**
 * Creates a email input field.
 */
sablono.core.email_field28965 = (function sablono$core$email_field28965(var_args){
var G__28967 = arguments.length;
switch (G__28967) {
case 1:
return sablono.core.email_field28965.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field28965.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field28965.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__28769__auto__);
});

sablono.core.email_field28965.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.email_field28965.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field28965);

/**
 * Creates a file input field.
 */
sablono.core.file_field28976 = (function sablono$core$file_field28976(var_args){
var G__28979 = arguments.length;
switch (G__28979) {
case 1:
return sablono.core.file_field28976.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field28976.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field28976.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__28769__auto__);
});

sablono.core.file_field28976.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.file_field28976.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field28976);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field28980 = (function sablono$core$hidden_field28980(var_args){
var G__28986 = arguments.length;
switch (G__28986) {
case 1:
return sablono.core.hidden_field28980.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field28980.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field28980.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__28769__auto__);
});

sablono.core.hidden_field28980.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.hidden_field28980.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field28980);

/**
 * Creates a month input field.
 */
sablono.core.month_field28992 = (function sablono$core$month_field28992(var_args){
var G__28999 = arguments.length;
switch (G__28999) {
case 1:
return sablono.core.month_field28992.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field28992.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field28992.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__28769__auto__);
});

sablono.core.month_field28992.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.month_field28992.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field28992);

/**
 * Creates a number input field.
 */
sablono.core.number_field29001 = (function sablono$core$number_field29001(var_args){
var G__29003 = arguments.length;
switch (G__29003) {
case 1:
return sablono.core.number_field29001.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field29001.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field29001.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__28769__auto__);
});

sablono.core.number_field29001.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.number_field29001.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field29001);

/**
 * Creates a password input field.
 */
sablono.core.password_field29006 = (function sablono$core$password_field29006(var_args){
var G__29008 = arguments.length;
switch (G__29008) {
case 1:
return sablono.core.password_field29006.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field29006.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field29006.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__28769__auto__);
});

sablono.core.password_field29006.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.password_field29006.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field29006);

/**
 * Creates a range input field.
 */
sablono.core.range_field29009 = (function sablono$core$range_field29009(var_args){
var G__29011 = arguments.length;
switch (G__29011) {
case 1:
return sablono.core.range_field29009.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field29009.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field29009.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__28769__auto__);
});

sablono.core.range_field29009.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.range_field29009.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field29009);

/**
 * Creates a search input field.
 */
sablono.core.search_field29012 = (function sablono$core$search_field29012(var_args){
var G__29014 = arguments.length;
switch (G__29014) {
case 1:
return sablono.core.search_field29012.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field29012.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field29012.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__28769__auto__);
});

sablono.core.search_field29012.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.search_field29012.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field29012);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field29016 = (function sablono$core$tel_field29016(var_args){
var G__29018 = arguments.length;
switch (G__29018) {
case 1:
return sablono.core.tel_field29016.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field29016.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field29016.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__28769__auto__);
});

sablono.core.tel_field29016.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.tel_field29016.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field29016);

/**
 * Creates a text input field.
 */
sablono.core.text_field29019 = (function sablono$core$text_field29019(var_args){
var G__29021 = arguments.length;
switch (G__29021) {
case 1:
return sablono.core.text_field29019.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field29019.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field29019.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__28769__auto__);
});

sablono.core.text_field29019.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.text_field29019.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field29019);

/**
 * Creates a time input field.
 */
sablono.core.time_field29022 = (function sablono$core$time_field29022(var_args){
var G__29024 = arguments.length;
switch (G__29024) {
case 1:
return sablono.core.time_field29022.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field29022.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field29022.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__28769__auto__);
});

sablono.core.time_field29022.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.time_field29022.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field29022);

/**
 * Creates a url input field.
 */
sablono.core.url_field29025 = (function sablono$core$url_field29025(var_args){
var G__29027 = arguments.length;
switch (G__29027) {
case 1:
return sablono.core.url_field29025.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field29025.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field29025.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__28769__auto__);
});

sablono.core.url_field29025.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.url_field29025.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field29025);

/**
 * Creates a week input field.
 */
sablono.core.week_field29028 = (function sablono$core$week_field29028(var_args){
var G__29030 = arguments.length;
switch (G__29030) {
case 1:
return sablono.core.week_field29028.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field29028.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field29028.cljs$core$IFn$_invoke$arity$1 = (function (name__28769__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__28769__auto__);
});

sablono.core.week_field29028.cljs$core$IFn$_invoke$arity$2 = (function (name__28769__auto__,value__28770__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__28769__auto__,value__28770__auto__);
});

sablono.core.week_field29028.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field29028);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box29060 = (function sablono$core$check_box29060(var_args){
var G__29062 = arguments.length;
switch (G__29062) {
case 1:
return sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box29060.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box29060.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box29060);
/**
 * Creates a radio button.
 */
sablono.core.radio_button29067 = (function sablono$core$radio_button29067(var_args){
var G__29069 = arguments.length;
switch (G__29069) {
case 1:
return sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
});

sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button29067.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button29067.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button29067);
sablono.core.hash_key = (function sablono$core$hash_key(x){
var G__29071 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
return goog.string.hashCode(G__29071);
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options29072 = (function sablono$core$select_options29072(coll){
var iter__4292__auto__ = (function sablono$core$select_options29072_$_iter__29073(s__29074){
return (new cljs.core.LazySeq(null,(function (){
var s__29074__$1 = s__29074;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__29074__$1);
if(temp__5457__auto__){
var s__29074__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__29074__$2)){
var c__4290__auto__ = cljs.core.chunk_first(s__29074__$2);
var size__4291__auto__ = cljs.core.count(c__4290__auto__);
var b__29076 = cljs.core.chunk_buffer(size__4291__auto__);
if((function (){var i__29075 = (0);
while(true){
if((i__29075 < size__4291__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4290__auto__,i__29075);
cljs.core.chunk_append(b__29076,((cljs.core.sequential_QMARK_(x))?(function (){var vec__29077 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29077,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29077,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29077,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options29072.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options29072.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options29072.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__29085 = (i__29075 + (1));
i__29075 = G__29085;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__29076),sablono$core$select_options29072_$_iter__29073(cljs.core.chunk_rest(s__29074__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__29076),null);
}
} else {
var x = cljs.core.first(s__29074__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__29080 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29080,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29080,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29080,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options29072.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options29072.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options29072.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options29072_$_iter__29073(cljs.core.rest(s__29074__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4292__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options29072);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down29088 = (function sablono$core$drop_down29088(var_args){
var G__29090 = arguments.length;
switch (G__29090) {
case 2:
return sablono.core.drop_down29088.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down29088.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down29088.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down29088.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down29088.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down29088.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down29088);
/**
 * Creates a text area element.
 */
sablono.core.text_area29097 = (function sablono$core$text_area29097(var_args){
var G__29099 = arguments.length;
switch (G__29099) {
case 1:
return sablono.core.text_area29097.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area29097.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area29097.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.text_area29097.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__3922__auto__ = value;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area29097.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area29097);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label29107 = (function sablono$core$label29107(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label29107);
/**
 * Creates a submit button.
 */
sablono.core.submit_button29109 = (function sablono$core$submit_button29109(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button29109);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button29113 = (function sablono$core$reset_button29113(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button29113);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to29123 = (function sablono$core$form_to29123(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29140 = arguments.length;
var i__4500__auto___29141 = (0);
while(true){
if((i__4500__auto___29141 < len__4499__auto___29140)){
args__4502__auto__.push((arguments[i__4500__auto___29141]));

var G__29142 = (i__4500__auto___29141 + (1));
i__4500__auto___29141 = G__29142;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to29123.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

sablono.core.form_to29123.cljs$core$IFn$_invoke$arity$variadic = (function (p__29130,body){
var vec__29132 = p__29130;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29132,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29132,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),(function (){var G__29135 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null);
var G__29136 = "_method";
var G__29137 = method_str;
return (sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$3 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$3(G__29135,G__29136,G__29137) : sablono.core.hidden_field.call(null,G__29135,G__29136,G__29137));
})()], null)),body));
});

sablono.core.form_to29123.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.form_to29123.cljs$lang$applyTo = (function (seq29125){
var G__29126 = cljs.core.first(seq29125);
var seq29125__$1 = cljs.core.next(seq29125);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29126,seq29125__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to29123);

//# sourceMappingURL=sablono.core.js.map
