goog.provide('reagent_dnd.drop_target');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('reagent_dnd.react_dnd');
goog.require('reagent_dnd.validate');
goog.require('reagent_dnd.util');
goog.require('reagent_dnd.monitor');
goog.require('reagent_dnd.connect');
reagent_dnd.drop_target.args_desc = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"string | hiccup",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),reagent_dnd.validate.string_or_hiccup_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"the thing to drop onto"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"atom | ratom",new cljs.core.Keyword(null,"description","description",-1428560544),"an atom/ratom to hold state, e.g. can-drop, is-over"], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"types","types",590030639),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"keyword | [keyword]",new cljs.core.Keyword(null,"description","description",-1428560544),"the type of thing to be dropped. e.g. :card or :list"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"drop","drop",364481611),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> serializable",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"function that returns the 'drop result'"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> any",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"function that is called whenever an item is hovered"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"-> any",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"function that is called whenever a drag is started, return value is available as (:item monitor)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"(dragged-item) -> boolean",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"function that indicates whether the item can be accepted by this drop zone"], null)], null);
reagent_dnd.drop_target.options = (function reagent_dnd$drop_target$options(p__31500){
var map__31501 = p__31500;
var map__31501__$1 = ((((!((map__31501 == null)))?(((((map__31501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31501.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31501):map__31501);
var drop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31501__$1,new cljs.core.Keyword(null,"drop","drop",364481611),cljs.core.constantly(null));
var can_drop_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31501__$1,new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846));
var hover = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31501__$1,new cljs.core.Keyword(null,"hover","hover",-341141711));
var options = ({});
(options["drop"] = ((function (options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover){
return (function (props,monitor){
var result = (function (){var G__31503 = reagent_dnd.monitor.monitor__GT_cljsmon(monitor);
return (drop.cljs$core$IFn$_invoke$arity$1 ? drop.cljs$core$IFn$_invoke$arity$1(G__31503) : drop.call(null,G__31503));
})();
if(cljs.core.truth_(reagent_dnd.util.serializable_QMARK_(result))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["Not Serializable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([result], 0)))].join('')),"\n","(util/serializable? result)"].join('')));
}

return result;
});})(options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover))
);

if(cljs.core.truth_(can_drop_QMARK_)){
(options["canDrop"] = ((function (options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover){
return (function (props,monitor){
var G__31504 = reagent_dnd.monitor.monitor__GT_cljsmon(monitor);
return (can_drop_QMARK_.cljs$core$IFn$_invoke$arity$1 ? can_drop_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31504) : can_drop_QMARK_.call(null,G__31504));
});})(options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover))
);
} else {
}

if(cljs.core.truth_(hover)){
(options["hover"] = ((function (options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover){
return (function (props,monitor,component){
var G__31505 = reagent_dnd.monitor.monitor__GT_cljsmon(monitor);
var G__31506 = component;
return (hover.cljs$core$IFn$_invoke$arity$2 ? hover.cljs$core$IFn$_invoke$arity$2(G__31505,G__31506) : hover.call(null,G__31505,G__31506));
});})(options,map__31501,map__31501__$1,drop,can_drop_QMARK_,hover))
);
} else {
}

return options;
});
reagent_dnd.drop_target.make_types = (function reagent_dnd$drop_target$make_types(types){
if((((types instanceof cljs.core.Keyword)) || (cljs.core.vector_QMARK_(types)))){
} else {
throw (new Error("Assert failed: (or (keyword? types) (vector? types))"));
}

if((types instanceof cljs.core.Keyword)){
return cljs.core.name(types);
} else {
return cljs.core.clj__GT_js(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.name,types));
}
});
reagent_dnd.drop_target.component = (function reagent_dnd$drop_target$component(var_args){
var args__4502__auto__ = [];
var len__4499__auto___31520 = arguments.length;
var i__4500__auto___31521 = (0);
while(true){
if((i__4500__auto___31521 < len__4499__auto___31520)){
args__4502__auto__.push((arguments[i__4500__auto___31521]));

var G__31522 = (i__4500__auto___31521 + (1));
i__4500__auto___31521 = G__31522;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return reagent_dnd.drop_target.component.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});

reagent_dnd.drop_target.component.cljs$core$IFn$_invoke$arity$variadic = (function (p__31508){
var map__31509 = p__31508;
var map__31509__$1 = ((((!((map__31509 == null)))?(((((map__31509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31509):map__31509);
var args = map__31509__$1;
var child = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"child","child",623967545));
var types = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"types","types",590030639));
var drop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"drop","drop",364481611));
var hover = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"hover","hover",-341141711));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var can_drop_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31509__$1,new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846));
if(cljs.core.truth_(((!(goog.DEBUG))?true:reagent_dnd.validate.validate_args.cljs$core$IFn$_invoke$arity$variadic(reagent_dnd.validate.extract_arg_data(reagent_dnd.drop_target.args_desc),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["drop-target"], 0))))){
} else {
throw (new Error("Assert failed: (validate-args-macro args-desc args \"drop-target\")"));
}

var wrapper = (function (){var G__31511 = reagent_dnd.drop_target.make_types(types);
var G__31512 = reagent_dnd.drop_target.options(args);
var G__31513 = reagent_dnd.monitor.props;
return (reagent_dnd.react_dnd.drop_target.cljs$core$IFn$_invoke$arity$3 ? reagent_dnd.react_dnd.drop_target.cljs$core$IFn$_invoke$arity$3(G__31511,G__31512,G__31513) : reagent_dnd.react_dnd.drop_target.call(null,G__31511,G__31512,G__31513));
})();
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.core.adapt_react_class((function (){var G__31514 = reagent.core.reactify_component(reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),((function (wrapper,map__31509,map__31509__$1,args,child,types,drop,hover,state,can_drop_QMARK_){
return (function (this$,p__31515,_){
var vec__31516 = p__31515;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31516,(0),null);
var next_props = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31516,(1),null);
return cljs.core.reset_BANG_(state,reagent_dnd.monitor.props__GT_cljsmon(next_props));
});})(wrapper,map__31509,map__31509__$1,args,child,types,drop,hover,state,can_drop_QMARK_))
,new cljs.core.Keyword(null,"render","render",-1408033454),((function (wrapper,map__31509,map__31509__$1,args,child,types,drop,hover,state,can_drop_QMARK_){
return (function (this$){
var connect_drop_target = (reagent_dnd.monitor.props__GT_cljscon(reagent.core.props(reagent.core.current_component()))["connect-drop-target"]);
var G__31519 = reagent.core.as_element(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),child], null));
return (connect_drop_target.cljs$core$IFn$_invoke$arity$1 ? connect_drop_target.cljs$core$IFn$_invoke$arity$1(G__31519) : connect_drop_target.call(null,G__31519));
});})(wrapper,map__31509,map__31509__$1,args,child,types,drop,hover,state,can_drop_QMARK_))
], null)));
return (wrapper.cljs$core$IFn$_invoke$arity$1 ? wrapper.cljs$core$IFn$_invoke$arity$1(G__31514) : wrapper.call(null,G__31514));
})())], null);
});

reagent_dnd.drop_target.component.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
reagent_dnd.drop_target.component.cljs$lang$applyTo = (function (seq31507){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31507));
});


//# sourceMappingURL=reagent_dnd.drop_target.js.map
