goog.provide('re_frame.undo');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.utils');
goog.require('re_frame.db');
goog.require('re_frame.handlers');
goog.require('re_frame.subs');
/**
 * Maximum number of undo states maintained
 */
re_frame.undo.max_undos = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((50));
re_frame.undo.set_max_undos_BANG_ = (function re_frame$undo$set_max_undos_BANG_(n){
return cljs.core.reset_BANG_(re_frame.undo.max_undos,n);
});
/**
 * A list of history states
 */
re_frame.undo.undo_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * A list of future states, caused by undoing
 */
re_frame.undo.redo_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * Mirrors app-db
 */
re_frame.undo.app_explain = reagent.core.atom.cljs$core$IFn$_invoke$arity$1("");
/**
 * Mirrors undo-list
 */
re_frame.undo.undo_explain_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * Mirrors redo-list
 */
re_frame.undo.redo_explain_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
re_frame.undo.clear_undos_BANG_ = (function re_frame$undo$clear_undos_BANG_(){
cljs.core.reset_BANG_(re_frame.undo.undo_list,cljs.core.PersistentVector.EMPTY);

return cljs.core.reset_BANG_(re_frame.undo.undo_explain_list,cljs.core.PersistentVector.EMPTY);
});
re_frame.undo.clear_redos_BANG_ = (function re_frame$undo$clear_redos_BANG_(){
cljs.core.reset_BANG_(re_frame.undo.redo_list,cljs.core.PersistentVector.EMPTY);

return cljs.core.reset_BANG_(re_frame.undo.redo_explain_list,cljs.core.PersistentVector.EMPTY);
});
re_frame.undo.clear_history_BANG_ = (function re_frame$undo$clear_history_BANG_(){
re_frame.undo.clear_undos_BANG_();

re_frame.undo.clear_redos_BANG_();

return cljs.core.reset_BANG_(re_frame.undo.app_explain,"");
});
/**
 * Stores the value currently in app-db, so the user can later undo
 */
re_frame.undo.store_now_BANG_ = (function re_frame$undo$store_now_BANG_(explanation){
re_frame.undo.clear_redos_BANG_();

cljs.core.reset_BANG_(re_frame.undo.undo_list,cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.undo.max_undos),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.undo.undo_list),cljs.core.deref(re_frame.db.app_db)))));

cljs.core.reset_BANG_(re_frame.undo.undo_explain_list,cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.undo.max_undos),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.undo.undo_explain_list),cljs.core.deref(re_frame.undo.app_explain)))));

return cljs.core.reset_BANG_(re_frame.undo.app_explain,explanation);
});
/**
 * Returns true if undos exist, false otherwise
 */
re_frame.undo.undos_QMARK_ = (function re_frame$undo$undos_QMARK_(){
return (cljs.core.count(cljs.core.deref(re_frame.undo.undo_list)) > (0));
});
/**
 * Returns true if redos exist, false otherwise
 */
re_frame.undo.redos_QMARK_ = (function re_frame$undo$redos_QMARK_(){
return (cljs.core.count(cljs.core.deref(re_frame.undo.redo_list)) > (0));
});
/**
 * Returns list of undo descriptions or empty list if no undos
 */
re_frame.undo.undo_explanations = (function re_frame$undo$undo_explanations(){
if(cljs.core.truth_(re_frame.undo.undos_QMARK_())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.undo.undo_explain_list),cljs.core.deref(re_frame.undo.app_explain));
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
re_frame.subs.register(new cljs.core.Keyword(null,"undos?","undos?",-1094259081),(function re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction((function (){
return re_frame.undo.undos_QMARK_();
}));
}));
re_frame.subs.register(new cljs.core.Keyword(null,"redos?","redos?",1340247550),(function re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction((function (){
return re_frame.undo.redos_QMARK_();
}));
}));
re_frame.subs.register(new cljs.core.Keyword(null,"undo-explanations","undo-explanations",942251259),(function re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction((function (){
return re_frame.undo.undo_explanations();
}));
}));
re_frame.subs.register(new cljs.core.Keyword(null,"redo-explanations","redo-explanations",-1933832741),(function re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction((function (){
return cljs.core.deref(re_frame.undo.redo_explain_list);
}));
}));
re_frame.undo.undo = (function re_frame$undo$undo(undos,cur,redos){
var u = cljs.core.deref(undos);
var r = cljs.core.cons(cljs.core.deref(cur),cljs.core.deref(redos));
cljs.core.reset_BANG_(cur,cljs.core.last(u));

cljs.core.reset_BANG_(redos,r);

return cljs.core.reset_BANG_(undos,cljs.core.pop(u));
});
/**
 * undo n steps or until we run out of undos
 */
re_frame.undo.undo_n = (function re_frame$undo$undo_n(n){
while(true){
if(cljs.core.truth_((function (){var and__3911__auto__ = (n > (0));
if(and__3911__auto__){
return re_frame.undo.undos_QMARK_();
} else {
return and__3911__auto__;
}
})())){
re_frame.undo.undo(re_frame.undo.undo_list,re_frame.db.app_db,re_frame.undo.redo_list);

re_frame.undo.undo(re_frame.undo.undo_explain_list,re_frame.undo.app_explain,re_frame.undo.redo_explain_list);

var G__36397 = (n - (1));
n = G__36397;
continue;
} else {
return null;
}
break;
}
});
re_frame.handlers.register_base.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"undo","undo",-1818036302),(function re_frame$undo$handler(_,p__36402){
var vec__36403 = p__36402;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36403,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36403,(1),null);
if(cljs.core.not(re_frame.undo.undos_QMARK_())){
return re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: you did a (dispatch [:undo]), but there is nothing to undo."], 0));
} else {
return re_frame.undo.undo_n((function (){var or__3922__auto__ = n;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return (1);
}
})());
}
}));
re_frame.undo.redo = (function re_frame$undo$redo(undos,cur,redos){
var u = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(undos),cljs.core.deref(cur));
var r = cljs.core.deref(redos);
cljs.core.reset_BANG_(cur,cljs.core.first(r));

cljs.core.reset_BANG_(redos,cljs.core.rest(r));

return cljs.core.reset_BANG_(undos,u);
});
/**
 * redo n steps or until we run out of redos
 */
re_frame.undo.redo_n = (function re_frame$undo$redo_n(n){
while(true){
if(cljs.core.truth_((function (){var and__3911__auto__ = (n > (0));
if(and__3911__auto__){
return re_frame.undo.redos_QMARK_();
} else {
return and__3911__auto__;
}
})())){
re_frame.undo.redo(re_frame.undo.undo_list,re_frame.db.app_db,re_frame.undo.redo_list);

re_frame.undo.redo(re_frame.undo.undo_explain_list,re_frame.undo.app_explain,re_frame.undo.redo_explain_list);

var G__36438 = (n - (1));
n = G__36438;
continue;
} else {
return null;
}
break;
}
});
re_frame.handlers.register_base.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"redo","redo",501190664),(function re_frame$undo$handler(_,p__36439){
var vec__36440 = p__36439;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36440,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36440,(1),null);
if(cljs.core.not(re_frame.undo.redos_QMARK_())){
return re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: you did a (dispatch [:redo]), but there is nothing to redo."], 0));
} else {
return re_frame.undo.redo_n((function (){var or__3922__auto__ = n;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return (1);
}
})());
}
}));
re_frame.handlers.register_base.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"purge-redos","purge-redos",1815721624),(function re_frame$undo$handler(_,___$1){
if(cljs.core.not(re_frame.undo.redos_QMARK_())){
return re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: you did a (dispatch [:purge-redos]), but there is nothing to redo."], 0));
} else {
return re_frame.undo.clear_redos_BANG_();
}
}));

//# sourceMappingURL=re_frame.undo.js.map
