goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if(typeof re_frame.trace.traces !== 'undefined'){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if(typeof re_frame.trace.next_delivery !== 'undefined'){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-trace#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__27212){
var map__27213 = p__27212;
var map__27213__$1 = ((((!((map__27213 == null)))?(((((map__27213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27213.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27213):map__27213);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27213__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27213__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27213__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27213__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__3922__auto__ = child_of;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__27215_27229 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__27216_27230 = null;
var count__27217_27231 = (0);
var i__27218_27232 = (0);
while(true){
if((i__27218_27232 < count__27217_27231)){
var vec__27219_27233 = chunk__27216_27230.cljs$core$IIndexed$_nth$arity$2(null,i__27218_27232);
var k_27234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27219_27233,(0),null);
var cb_27235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27219_27233,(1),null);
try{var G__27223_27236 = cljs.core.deref(re_frame.trace.traces);
(cb_27235.cljs$core$IFn$_invoke$arity$1 ? cb_27235.cljs$core$IFn$_invoke$arity$1(G__27223_27236) : cb_27235.call(null,G__27223_27236));
}catch (e27222){var e_27237 = e27222;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27234,"while storing",cljs.core.deref(re_frame.trace.traces),e_27237], 0));
}

var G__27238 = seq__27215_27229;
var G__27239 = chunk__27216_27230;
var G__27240 = count__27217_27231;
var G__27241 = (i__27218_27232 + (1));
seq__27215_27229 = G__27238;
chunk__27216_27230 = G__27239;
count__27217_27231 = G__27240;
i__27218_27232 = G__27241;
continue;
} else {
var temp__5457__auto___27242 = cljs.core.seq(seq__27215_27229);
if(temp__5457__auto___27242){
var seq__27215_27243__$1 = temp__5457__auto___27242;
if(cljs.core.chunked_seq_QMARK_(seq__27215_27243__$1)){
var c__4319__auto___27244 = cljs.core.chunk_first(seq__27215_27243__$1);
var G__27245 = cljs.core.chunk_rest(seq__27215_27243__$1);
var G__27246 = c__4319__auto___27244;
var G__27247 = cljs.core.count(c__4319__auto___27244);
var G__27248 = (0);
seq__27215_27229 = G__27245;
chunk__27216_27230 = G__27246;
count__27217_27231 = G__27247;
i__27218_27232 = G__27248;
continue;
} else {
var vec__27224_27249 = cljs.core.first(seq__27215_27243__$1);
var k_27250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27224_27249,(0),null);
var cb_27251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27224_27249,(1),null);
try{var G__27228_27252 = cljs.core.deref(re_frame.trace.traces);
(cb_27251.cljs$core$IFn$_invoke$arity$1 ? cb_27251.cljs$core$IFn$_invoke$arity$1(G__27228_27252) : cb_27251.call(null,G__27228_27252));
}catch (e27227){var e_27253 = e27227;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27250,"while storing",cljs.core.deref(re_frame.trace.traces),e_27253], 0));
}

var G__27254 = cljs.core.next(seq__27215_27243__$1);
var G__27255 = null;
var G__27256 = (0);
var G__27257 = (0);
seq__27215_27229 = G__27254;
chunk__27216_27230 = G__27255;
count__27217_27231 = G__27256;
i__27218_27232 = G__27257;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (10)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
