goog.provide('markdown.core');
goog.require('cljs.core');
goog.require('markdown.common');
goog.require('markdown.links');
goog.require('markdown.transformers');
markdown.core.init_transformer = (function markdown$core$init_transformer(p__29726){
var map__29727 = p__29726;
var map__29727__$1 = ((((!((map__29727 == null)))?(((((map__29727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29727):map__29727);
var replacement_transformers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,new cljs.core.Keyword(null,"replacement-transformers","replacement-transformers",-2028552897));
var custom_transformers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,new cljs.core.Keyword(null,"custom-transformers","custom-transformers",1440601790));
var inhibit_separator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29727__$1,new cljs.core.Keyword(null,"inhibit-separator","inhibit-separator",1268116222));
return ((function (map__29727,map__29727__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (html,line,next_line,state){
var _STAR_inhibit_separator_STAR_29729 = markdown.common._STAR_inhibit_separator_STAR_;
markdown.common._STAR_inhibit_separator_STAR_ = inhibit_separator;

try{var vec__29731 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (_STAR_inhibit_separator_STAR_29729,map__29727,map__29727__$1,replacement_transformers,custom_transformers,inhibit_separator){
return (function (p__29734,transformer){
var vec__29735 = p__29734;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29735,(0),null);
var state__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29735,(1),null);
var G__29738 = text;
var G__29739 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state__$1,new cljs.core.Keyword(null,"next-line","next-line",-1187000287),next_line);
return (transformer.cljs$core$IFn$_invoke$arity$2 ? transformer.cljs$core$IFn$_invoke$arity$2(G__29738,G__29739) : transformer.call(null,G__29738,G__29739));
});})(_STAR_inhibit_separator_STAR_29729,map__29727,map__29727__$1,replacement_transformers,custom_transformers,inhibit_separator))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,state], null),(function (){var or__3922__auto__ = replacement_transformers;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(markdown.transformers.transformer_vector,custom_transformers);
}
})());
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29731,(0),null);
var new_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29731,(1),null);
html.append(text);

return new_state;
}finally {markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR_29729;
}});
;})(map__29727,map__29727__$1,replacement_transformers,custom_transformers,inhibit_separator))
});
/**
 * Removed from cljs.core 0.0-1885, Ref. http://goo.gl/su7Xkj
 */
markdown.core.format = (function markdown$core$format(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29751 = arguments.length;
var i__4500__auto___29752 = (0);
while(true){
if((i__4500__auto___29752 < len__4499__auto___29751)){
args__4502__auto__.push((arguments[i__4500__auto___29752]));

var G__29753 = (i__4500__auto___29752 + (1));
i__4500__auto___29752 = G__29753;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

markdown.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

markdown.core.format.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
markdown.core.format.cljs$lang$applyTo = (function (seq29746){
var G__29747 = cljs.core.first(seq29746);
var seq29746__$1 = cljs.core.next(seq29746);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29747,seq29746__$1);
});

markdown.core.parse_references = (function markdown$core$parse_references(lines){
var references = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var seq__29756_29769 = cljs.core.seq(lines);
var chunk__29757_29770 = null;
var count__29758_29771 = (0);
var i__29759_29772 = (0);
while(true){
if((i__29759_29772 < count__29758_29771)){
var line_29773 = chunk__29757_29770.cljs$core$IIndexed$_nth$arity$2(null,i__29759_29772);
markdown.links.parse_reference_link(line_29773,references);


var G__29774 = seq__29756_29769;
var G__29775 = chunk__29757_29770;
var G__29776 = count__29758_29771;
var G__29777 = (i__29759_29772 + (1));
seq__29756_29769 = G__29774;
chunk__29757_29770 = G__29775;
count__29758_29771 = G__29776;
i__29759_29772 = G__29777;
continue;
} else {
var temp__5457__auto___29778 = cljs.core.seq(seq__29756_29769);
if(temp__5457__auto___29778){
var seq__29756_29780__$1 = temp__5457__auto___29778;
if(cljs.core.chunked_seq_QMARK_(seq__29756_29780__$1)){
var c__4319__auto___29781 = cljs.core.chunk_first(seq__29756_29780__$1);
var G__29783 = cljs.core.chunk_rest(seq__29756_29780__$1);
var G__29784 = c__4319__auto___29781;
var G__29785 = cljs.core.count(c__4319__auto___29781);
var G__29786 = (0);
seq__29756_29769 = G__29783;
chunk__29757_29770 = G__29784;
count__29758_29771 = G__29785;
i__29759_29772 = G__29786;
continue;
} else {
var line_29788 = cljs.core.first(seq__29756_29780__$1);
markdown.links.parse_reference_link(line_29788,references);


var G__29790 = cljs.core.next(seq__29756_29780__$1);
var G__29791 = null;
var G__29792 = (0);
var G__29793 = (0);
seq__29756_29769 = G__29790;
chunk__29757_29770 = G__29791;
count__29758_29771 = G__29792;
i__29759_29772 = G__29793;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(references);
});
markdown.core.parse_footnotes = (function markdown$core$parse_footnotes(lines){
var footnotes = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"next-fn-id","next-fn-id",738579636),(1),new cljs.core.Keyword(null,"processed","processed",800622264),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"unprocessed","unprocessed",766771972),cljs.core.PersistentArrayMap.EMPTY], null));
var seq__29794_29798 = cljs.core.seq(lines);
var chunk__29795_29799 = null;
var count__29796_29800 = (0);
var i__29797_29801 = (0);
while(true){
if((i__29797_29801 < count__29796_29800)){
var line_29802 = chunk__29795_29799.cljs$core$IIndexed$_nth$arity$2(null,i__29797_29801);
markdown.links.parse_footnote_link(line_29802,footnotes);


var G__29804 = seq__29794_29798;
var G__29805 = chunk__29795_29799;
var G__29806 = count__29796_29800;
var G__29807 = (i__29797_29801 + (1));
seq__29794_29798 = G__29804;
chunk__29795_29799 = G__29805;
count__29796_29800 = G__29806;
i__29797_29801 = G__29807;
continue;
} else {
var temp__5457__auto___29809 = cljs.core.seq(seq__29794_29798);
if(temp__5457__auto___29809){
var seq__29794_29810__$1 = temp__5457__auto___29809;
if(cljs.core.chunked_seq_QMARK_(seq__29794_29810__$1)){
var c__4319__auto___29811 = cljs.core.chunk_first(seq__29794_29810__$1);
var G__29812 = cljs.core.chunk_rest(seq__29794_29810__$1);
var G__29813 = c__4319__auto___29811;
var G__29814 = cljs.core.count(c__4319__auto___29811);
var G__29815 = (0);
seq__29794_29798 = G__29812;
chunk__29795_29799 = G__29813;
count__29796_29800 = G__29814;
i__29797_29801 = G__29815;
continue;
} else {
var line_29816 = cljs.core.first(seq__29794_29810__$1);
markdown.links.parse_footnote_link(line_29816,footnotes);


var G__29817 = cljs.core.next(seq__29794_29810__$1);
var G__29818 = null;
var G__29819 = (0);
var G__29820 = (0);
seq__29794_29798 = G__29817;
chunk__29795_29799 = G__29818;
count__29796_29800 = G__29819;
i__29797_29801 = G__29820;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(footnotes);
});
markdown.core.parse_metadata = (function markdown$core$parse_metadata(lines){
var vec__29822 = cljs.core.split_with((function (p1__29821_SHARP_){
return cljs.core.not_empty(p1__29821_SHARP_.trim());
}),lines);
var metadata = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29822,(0),null);
var lines__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29822,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [markdown.transformers.parse_metadata_headers(metadata),lines__$1], null);
});
/**
 * processes input text line by line and outputs an HTML string
 */
markdown.core.md_to_html_string_STAR_ = (function markdown$core$md_to_html_string_STAR_(text,params){
var _STAR_substring_STAR_29851 = markdown.common._STAR_substring_STAR_;
var _STAR_formatter_STAR_29852 = markdown.transformers._STAR_formatter_STAR_;
markdown.common._STAR_substring_STAR_ = ((function (_STAR_substring_STAR_29851,_STAR_formatter_STAR_29852){
return (function (s,n){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});})(_STAR_substring_STAR_29851,_STAR_formatter_STAR_29852))
;

markdown.transformers._STAR_formatter_STAR_ = markdown.core.format;

try{var params__$1 = (cljs.core.truth_(params)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc,cljs.core.PersistentArrayMap.EMPTY),params):null);
var lines = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),"\n"].join('').split("\n");
var html = (new goog.string.StringBuffer(""));
var references = (cljs.core.truth_(new cljs.core.Keyword(null,"reference-links?","reference-links?",-2003778981).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_references(lines):null);
var footnotes = (cljs.core.truth_(new cljs.core.Keyword(null,"footnotes?","footnotes?",-1590157845).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_footnotes(lines):null);
var vec__29853 = (cljs.core.truth_(new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_metadata(lines):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,lines], null));
var metadata = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29853,(0),null);
var lines__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29853,(1),null);
var transformer = markdown.core.init_transformer(params__$1);
var G__29861_29891 = lines__$1;
var vec__29862_29892 = G__29861_29891;
var seq__29863_29893 = cljs.core.seq(vec__29862_29892);
var first__29864_29894 = cljs.core.first(seq__29863_29893);
var seq__29863_29895__$1 = cljs.core.next(seq__29863_29893);
var line_29896 = first__29864_29894;
var more_29897 = seq__29863_29895__$1;
var state_29898 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"clojurescript","clojurescript",-299769403),true,new cljs.core.Keyword(null,"references","references",882562509),references,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205),footnotes,new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true], null),params__$1], 0));
var G__29861_29900__$1 = G__29861_29891;
var state_29901__$1 = state_29898;
while(true){
var vec__29867_29902 = G__29861_29900__$1;
var seq__29868_29903 = cljs.core.seq(vec__29867_29902);
var first__29869_29904 = cljs.core.first(seq__29868_29903);
var seq__29868_29905__$1 = cljs.core.next(seq__29868_29903);
var line_29906__$1 = first__29869_29904;
var more_29907__$1 = seq__29868_29905__$1;
var state_29908__$2 = state_29901__$1;
var line_29909__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749).cljs$core$IFn$_invoke$arity$1(state_29908__$2))?"":line_29906__$1);
var state_29910__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_29908__$2))?(function (){var G__29871 = html;
var G__29872 = new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_29908__$2);
var G__29873 = new cljs.core.Keyword(null,"next-line","next-line",-1187000287).cljs$core$IFn$_invoke$arity$1(state_29908__$2);
var G__29874 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(state_29908__$2,new cljs.core.Keyword(null,"buf","buf",-213913340),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"lists","lists",-884730684),new cljs.core.Keyword(null,"next-line","next-line",-1187000287)], 0)),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true);
return (transformer.cljs$core$IFn$_invoke$arity$4 ? transformer.cljs$core$IFn$_invoke$arity$4(G__29871,G__29872,G__29873,G__29874) : transformer.call(null,G__29871,G__29872,G__29873,G__29874));
})():state_29908__$2);
if(cljs.core.truth_(cljs.core.not_empty(more_29907__$1))){
var G__29912 = more_29907__$1;
var G__29913 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((function (){var G__29875 = html;
var G__29876 = line_29909__$2;
var G__29877 = cljs.core.first(more_29907__$1);
var G__29878 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(state_29910__$3,new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749));
return (transformer.cljs$core$IFn$_invoke$arity$4 ? transformer.cljs$core$IFn$_invoke$arity$4(G__29875,G__29876,G__29877,G__29878) : transformer.call(null,G__29875,G__29876,G__29877,G__29878));
})(),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),cljs.core.empty_QMARK_(line_29909__$2));
G__29861_29900__$1 = G__29912;
state_29901__$1 = G__29913;
continue;
} else {
var G__29880_29916 = html.append(markdown.transformers.footer(new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205).cljs$core$IFn$_invoke$arity$1(state_29910__$3)));
var G__29881_29917 = line_29909__$2;
var G__29882_29918 = "";
var G__29883_29919 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state_29910__$3,new cljs.core.Keyword(null,"eof","eof",-489063237),true);
(transformer.cljs$core$IFn$_invoke$arity$4 ? transformer.cljs$core$IFn$_invoke$arity$4(G__29880_29916,G__29881_29917,G__29882_29918,G__29883_29919) : transformer.call(null,G__29880_29916,G__29881_29917,G__29882_29918,G__29883_29919));
}
break;
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"metadata","metadata",1799301597),metadata,new cljs.core.Keyword(null,"html","html",-998796897),html.toString()], null);
}finally {markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR_29852;

markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR_29851;
}});
markdown.core.md__GT_html = (function markdown$core$md__GT_html(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29925 = arguments.length;
var i__4500__auto___29927 = (0);
while(true){
if((i__4500__auto___29927 < len__4499__auto___29925)){
args__4502__auto__.push((arguments[i__4500__auto___29927]));

var G__29928 = (i__4500__auto___29927 + (1));
i__4500__auto___29927 = G__29928;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return new cljs.core.Keyword(null,"html","html",-998796897).cljs$core$IFn$_invoke$arity$1(markdown.core.md_to_html_string_STAR_(text,params));
});

markdown.core.md__GT_html.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
markdown.core.md__GT_html.cljs$lang$applyTo = (function (seq29922){
var G__29923 = cljs.core.first(seq29922);
var seq29922__$1 = cljs.core.next(seq29922);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29923,seq29922__$1);
});

markdown.core.md__GT_html_with_meta = (function markdown$core$md__GT_html_with_meta(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29952 = arguments.length;
var i__4500__auto___29957 = (0);
while(true){
if((i__4500__auto___29957 < len__4499__auto___29952)){
args__4502__auto__.push((arguments[i__4500__auto___29957]));

var G__29960 = (i__4500__auto___29957 + (1));
i__4500__auto___29957 = G__29960;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return markdown.core.md_to_html_string_STAR_(text,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742),true], null),params));
});

markdown.core.md__GT_html_with_meta.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
markdown.core.md__GT_html_with_meta.cljs$lang$applyTo = (function (seq29930){
var G__29931 = cljs.core.first(seq29930);
var seq29930__$1 = cljs.core.next(seq29930);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29931,seq29930__$1);
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtml = (function markdown$core$mdToHtml(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29974 = arguments.length;
var i__4500__auto___29975 = (0);
while(true){
if((i__4500__auto___29975 < len__4499__auto___29974)){
args__4502__auto__.push((arguments[i__4500__auto___29975]));

var G__29977 = (i__4500__auto___29975 + (1));
i__4500__auto___29975 = G__29977;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});
goog.exportSymbol('markdown.core.mdToHtml', markdown.core.mdToHtml);

markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(markdown.core.md__GT_html,params);
});

markdown.core.mdToHtml.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
markdown.core.mdToHtml.cljs$lang$applyTo = (function (seq29963){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29963));
});

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtmlWithMeta = (function markdown$core$mdToHtmlWithMeta(var_args){
var args__4502__auto__ = [];
var len__4499__auto___29981 = arguments.length;
var i__4500__auto___29983 = (0);
while(true){
if((i__4500__auto___29983 < len__4499__auto___29981)){
args__4502__auto__.push((arguments[i__4500__auto___29983]));

var G__29985 = (i__4500__auto___29983 + (1));
i__4500__auto___29983 = G__29985;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((0) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
});
goog.exportSymbol('markdown.core.mdToHtmlWithMeta', markdown.core.mdToHtmlWithMeta);

markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(markdown.core.md__GT_html_with_meta,params);
});

markdown.core.mdToHtmlWithMeta.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
markdown.core.mdToHtmlWithMeta.cljs$lang$applyTo = (function (seq29979){
var self__4487__auto__ = this;
return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29979));
});


//# sourceMappingURL=markdown.core.js.map
