goog.provide('examples.views.single_target');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('clojure.string');
goog.require('devcards.core');
goog.require('devcards.util.edn_renderer');
goog.require('reagent.core');
goog.require('reagent_dnd.core');
goog.require('reagent.ratom');
goog.require('markdown.core');
goog.require('medley.core');
goog.require('examples.utils');
examples.views.single_target.target = (function examples$views$single_target$target(state,last_dropped){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"height","height",1025178622),"100px",new cljs.core.Keyword(null,"width","width",-384071477),"100px",new cljs.core.Keyword(null,"background-color","background-color",570434026),(cljs.core.truth_(new cljs.core.Keyword(null,"is-over?","is-over?",-228432368).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?new cljs.core.Keyword(null,"black","black",1294279647):(cljs.core.truth_(new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?new cljs.core.Keyword(null,"grey","grey",1875582333):new cljs.core.Keyword(null,"white","white",-483998618)
)),new cljs.core.Keyword(null,"color","color",1011675173),(cljs.core.truth_(new cljs.core.Keyword(null,"is-over?","is-over?",-228432368).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?new cljs.core.Keyword(null,"white","white",-483998618):(cljs.core.truth_(new cljs.core.Keyword(null,"can-drop?","can-drop?",-1770906846).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state)))?new cljs.core.Keyword(null,"white","white",-483998618):new cljs.core.Keyword(null,"black","black",1294279647)
))], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Drag a box here"], null)], null);
});
examples.views.single_target.drop_target = (function examples$views$single_target$drop_target(drop_state,last_dropped){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_dnd.core.drop_target,new cljs.core.Keyword(null,"types","types",590030639),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"glass","glass",1652756718),new cljs.core.Keyword(null,"banana","banana",1115289179),new cljs.core.Keyword(null,"paper","paper",-836673493)], null),new cljs.core.Keyword(null,"state","state",-1988618099),drop_state,new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.target,drop_state,last_dropped], null),new cljs.core.Keyword(null,"drop","drop",364481611),(function (state){
return cljs.core.reset_BANG_(last_dropped,new cljs.core.Keyword(null,"item","item",249373802).cljs$core$IFn$_invoke$arity$1(state));
})], null);
});
examples.views.single_target.box = (function examples$views$single_target$box(id,state){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"border","border",1444987323),"1px dashed black",new cljs.core.Keyword(null,"text-align","text-align",1786091845),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"padding","padding",1660304693),"10px",new cljs.core.Keyword(null,"margin","margin",-995903681),"10px",new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"move","move",-2110884309)], null)], null),examples.utils.make_title(id)], null);
});
examples.views.single_target.draggable = (function examples$views$single_target$draggable(id,state){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_dnd.core.drag_source,new cljs.core.Keyword(null,"type","type",1174270348),id,new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.box,id,state], null),new cljs.core.Keyword(null,"begin-drag","begin-drag",-1601004463),cljs.core.constantly(id)], null);
});
examples.views.single_target.single_target_example = (function examples$views$single_target$single_target_example(){
var last_dropped = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var drag_state_glass = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var drag_state_banana = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var drag_state_paper = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var drop_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.utils.card,new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.drop-targets","div.drop-targets",894872194),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.drop_target,drop_state,last_dropped], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.drag-sources","div.drag-sources",-1228329935),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.draggable,new cljs.core.Keyword(null,"glass","glass",1652756718),drag_state_glass], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.draggable,new cljs.core.Keyword(null,"banana","banana",1115289179),drag_state_banana], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.draggable,new cljs.core.Keyword(null,"paper","paper",-836673493),drag_state_paper], null)], null)], null),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"drag-state-glass","drag-state-glass",66449224),drag_state_glass,new cljs.core.Keyword(null,"drag-state-banana","drag-state-banana",1025950990),drag_state_banana,new cljs.core.Keyword(null,"drag-state-paper","drag-state-paper",69946454),drag_state_paper,new cljs.core.Keyword(null,"drop-state","drop-state",-1460909430),drop_state,new cljs.core.Keyword(null,"last-dropped","last-dropped",1717099604),last_dropped], null)], null);
});
examples.views.single_target.view = (function examples$views$single_target$view(){
return examples.utils.document.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["# Single Target\nThis is as simple as it gets.",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [examples.views.single_target.single_target_example], null),["\n```clojure\n","(defn box [id state]\n  [:span\n   {:style {:border     \"1px dashed black\"\n            :text-align :center\n            :padding    \"10px\"\n            :margin     \"10px\"\n            :cursor     :move}}\n   (make-title id)])","\n```\n"].join(''),["\n```clojure\n","(defn draggable [id state]\n  [dnd/drag-source\n   :type id\n   :state state\n   :child [box id state]\n   :begin-drag (constantly id)])","\n```\n"].join(''),["\n```clojure\n","(defn target [state last-dropped]\n  [:div {:style {:height           \"100px\"\n                 :width            \"100px\"\n                 :background-color (cond\n                                     (:is-over? @state) :black\n                                     (:can-drop? @state) :grey\n                                     :default :white)\n                 :color            (cond\n                                     (:is-over? @state) :white\n                                     (:can-drop? @state) :white\n                                     :default :black)}}\n   [:div \"Drag a box here\"]])","\n```\n"].join(''),["\n```clojure\n","(defn drop-target [drop-state last-dropped]\n  [dnd/drop-target\n   :types [:glass :banana :paper]\n   :state drop-state\n   :child [target drop-state last-dropped]\n   :drop (fn [state]\n           (reset! last-dropped (:item state)))])","\n```\n"].join(''),["\n```clojure\n","(defn single-target-example []\n  (let [last-dropped      (r/atom nil)\n        drag-state-glass  (r/atom {})\n        drag-state-banana (r/atom {})\n        drag-state-paper  (r/atom {})\n        drop-state        (r/atom {})]\n    [card\n     :content [:div\n               [:div.drop-targets\n                [drop-target drop-state last-dropped]]\n               [:div.drag-sources\n                [draggable :glass drag-state-glass][draggable :banana drag-state-banana][draggable :paper drag-state-paper]]\n\n\n               ]\n     :state {:drag-state-glass  drag-state-glass\n             :drag-state-banana drag-state-banana\n             :drag-state-paper  drag-state-paper\n             :drop-state        drop-state\n             :last-dropped      last-dropped}]))","\n```\n"].join('')], 0));
});

//# sourceMappingURL=examples.views.single_target.js.map
