goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__32760 = arguments.length;
switch (G__32760) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async32764 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32764 = (function (f,blockable,meta32765){
this.f = f;
this.blockable = blockable;
this.meta32765 = meta32765;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32766,meta32765__$1){
var self__ = this;
var _32766__$1 = this;
return (new cljs.core.async.t_cljs$core$async32764(self__.f,self__.blockable,meta32765__$1));
});

cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32766){
var self__ = this;
var _32766__$1 = this;
return self__.meta32765;
});

cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async32764.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async32764.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta32765","meta32765",110403638,null)], null);
});

cljs.core.async.t_cljs$core$async32764.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32764.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32764";

cljs.core.async.t_cljs$core$async32764.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async32764");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32764.
 */
cljs.core.async.__GT_t_cljs$core$async32764 = (function cljs$core$async$__GT_t_cljs$core$async32764(f__$1,blockable__$1,meta32765){
return (new cljs.core.async.t_cljs$core$async32764(f__$1,blockable__$1,meta32765));
});

}

return (new cljs.core.async.t_cljs$core$async32764(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__32805 = arguments.length;
switch (G__32805) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__32827 = arguments.length;
switch (G__32827) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__32837 = arguments.length;
switch (G__32837) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32847 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32847) : fn1.call(null,val_32847));
} else {
cljs.core.async.impl.dispatch.run(((function (val_32847,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32847) : fn1.call(null,val_32847));
});})(val_32847,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__32862 = arguments.length;
switch (G__32862) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4376__auto___32876 = n;
var x_32877 = (0);
while(true){
if((x_32877 < n__4376__auto___32876)){
(a[x_32877] = (0));

var G__32878 = (x_32877 + (1));
x_32877 = G__32878;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__32880 = (i + (1));
i = G__32880;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async32881 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32881 = (function (flag,meta32882){
this.flag = flag;
this.meta32882 = meta32882;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_32883,meta32882__$1){
var self__ = this;
var _32883__$1 = this;
return (new cljs.core.async.t_cljs$core$async32881(self__.flag,meta32882__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_32883){
var self__ = this;
var _32883__$1 = this;
return self__.meta32882;
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta32882","meta32882",-802387854,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async32881.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32881.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32881";

cljs.core.async.t_cljs$core$async32881.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async32881");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32881.
 */
cljs.core.async.__GT_t_cljs$core$async32881 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async32881(flag__$1,meta32882){
return (new cljs.core.async.t_cljs$core$async32881(flag__$1,meta32882));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async32881(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async32885 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32885 = (function (flag,cb,meta32886){
this.flag = flag;
this.cb = cb;
this.meta32886 = meta32886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32887,meta32886__$1){
var self__ = this;
var _32887__$1 = this;
return (new cljs.core.async.t_cljs$core$async32885(self__.flag,self__.cb,meta32886__$1));
});

cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32887){
var self__ = this;
var _32887__$1 = this;
return self__.meta32886;
});

cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async32885.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async32885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta32886","meta32886",-585827044,null)], null);
});

cljs.core.async.t_cljs$core$async32885.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32885.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32885";

cljs.core.async.t_cljs$core$async32885.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async32885");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32885.
 */
cljs.core.async.__GT_t_cljs$core$async32885 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async32885(flag__$1,cb__$1,meta32886){
return (new cljs.core.async.t_cljs$core$async32885(flag__$1,cb__$1,meta32886));
});

}

return (new cljs.core.async.t_cljs$core$async32885(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32889_SHARP_){
var G__32892 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32889_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__32892) : fret.call(null,G__32892));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__32890_SHARP_){
var G__32893 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32890_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__32893) : fret.call(null,G__32893));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__3922__auto__ = wport;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return port;
}
})()], null));
} else {
var G__32895 = (i + (1));
i = G__32895;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3922__auto__ = ret;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3911__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___32905 = arguments.length;
var i__4500__auto___32906 = (0);
while(true){
if((i__4500__auto___32906 < len__4499__auto___32905)){
args__4502__auto__.push((arguments[i__4500__auto___32906]));

var G__32907 = (i__4500__auto___32906 + (1));
i__4500__auto___32906 = G__32907;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__32900){
var map__32901 = p__32900;
var map__32901__$1 = ((((!((map__32901 == null)))?(((((map__32901.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32901.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32901):map__32901);
var opts = map__32901__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq32897){
var G__32898 = cljs.core.first(seq32897);
var seq32897__$1 = cljs.core.next(seq32897);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32898,seq32897__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__32911 = arguments.length;
switch (G__32911) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__32612__auto___32988 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___32988){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___32988){
return (function (state_32943){
var state_val_32944 = (state_32943[(1)]);
if((state_val_32944 === (7))){
var inst_32939 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
var statearr_32951_32989 = state_32943__$1;
(statearr_32951_32989[(2)] = inst_32939);

(statearr_32951_32989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (1))){
var state_32943__$1 = state_32943;
var statearr_32952_32990 = state_32943__$1;
(statearr_32952_32990[(2)] = null);

(statearr_32952_32990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (4))){
var inst_32922 = (state_32943[(7)]);
var inst_32922__$1 = (state_32943[(2)]);
var inst_32923 = (inst_32922__$1 == null);
var state_32943__$1 = (function (){var statearr_32953 = state_32943;
(statearr_32953[(7)] = inst_32922__$1);

return statearr_32953;
})();
if(cljs.core.truth_(inst_32923)){
var statearr_32954_32991 = state_32943__$1;
(statearr_32954_32991[(1)] = (5));

} else {
var statearr_32955_32992 = state_32943__$1;
(statearr_32955_32992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (13))){
var state_32943__$1 = state_32943;
var statearr_32959_32993 = state_32943__$1;
(statearr_32959_32993[(2)] = null);

(statearr_32959_32993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (6))){
var inst_32922 = (state_32943[(7)]);
var state_32943__$1 = state_32943;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32943__$1,(11),to,inst_32922);
} else {
if((state_val_32944 === (3))){
var inst_32941 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32943__$1,inst_32941);
} else {
if((state_val_32944 === (12))){
var state_32943__$1 = state_32943;
var statearr_32962_32994 = state_32943__$1;
(statearr_32962_32994[(2)] = null);

(statearr_32962_32994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (2))){
var state_32943__$1 = state_32943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32943__$1,(4),from);
} else {
if((state_val_32944 === (11))){
var inst_32932 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
if(cljs.core.truth_(inst_32932)){
var statearr_32969_32995 = state_32943__$1;
(statearr_32969_32995[(1)] = (12));

} else {
var statearr_32970_32996 = state_32943__$1;
(statearr_32970_32996[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (9))){
var state_32943__$1 = state_32943;
var statearr_32972_32997 = state_32943__$1;
(statearr_32972_32997[(2)] = null);

(statearr_32972_32997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (5))){
var state_32943__$1 = state_32943;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32973_32998 = state_32943__$1;
(statearr_32973_32998[(1)] = (8));

} else {
var statearr_32976_32999 = state_32943__$1;
(statearr_32976_32999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (14))){
var inst_32937 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
var statearr_32979_33000 = state_32943__$1;
(statearr_32979_33000[(2)] = inst_32937);

(statearr_32979_33000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (10))){
var inst_32929 = (state_32943[(2)]);
var state_32943__$1 = state_32943;
var statearr_32980_33001 = state_32943__$1;
(statearr_32980_33001[(2)] = inst_32929);

(statearr_32980_33001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32944 === (8))){
var inst_32926 = cljs.core.async.close_BANG_(to);
var state_32943__$1 = state_32943;
var statearr_32981_33002 = state_32943__$1;
(statearr_32981_33002[(2)] = inst_32926);

(statearr_32981_33002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___32988))
;
return ((function (switch__32540__auto__,c__32612__auto___32988){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_32982 = [null,null,null,null,null,null,null,null];
(statearr_32982[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_32982[(1)] = (1));

return statearr_32982;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_32943){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_32943);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e32983){if((e32983 instanceof Object)){
var ex__32544__auto__ = e32983;
var statearr_32984_33003 = state_32943;
(statearr_32984_33003[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32943);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32983;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33004 = state_32943;
state_32943 = G__33004;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_32943){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_32943);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___32988))
})();
var state__32614__auto__ = (function (){var statearr_32986 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_32986[(6)] = c__32612__auto___32988);

return statearr_32986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___32988))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__33008){
var vec__33009 = p__33008;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33009,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33009,(1),null);
var job = vec__33009;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__32612__auto___33268 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results){
return (function (state_33018){
var state_val_33019 = (state_33018[(1)]);
if((state_val_33019 === (1))){
var state_33018__$1 = state_33018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33018__$1,(2),res,v);
} else {
if((state_val_33019 === (2))){
var inst_33015 = (state_33018[(2)]);
var inst_33016 = cljs.core.async.close_BANG_(res);
var state_33018__$1 = (function (){var statearr_33020 = state_33018;
(statearr_33020[(7)] = inst_33015);

return statearr_33020;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33018__$1,inst_33016);
} else {
return null;
}
}
});})(c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results))
;
return ((function (switch__32540__auto__,c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_33021 = [null,null,null,null,null,null,null,null];
(statearr_33021[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__);

(statearr_33021[(1)] = (1));

return statearr_33021;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1 = (function (state_33018){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33018);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33022){if((e33022 instanceof Object)){
var ex__32544__auto__ = e33022;
var statearr_33023_33269 = state_33018;
(statearr_33023_33269[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33018);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33022;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33270 = state_33018;
state_33018 = G__33270;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = function(state_33018){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1.call(this,state_33018);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results))
})();
var state__32614__auto__ = (function (){var statearr_33024 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33024[(6)] = c__32612__auto___33268);

return statearr_33024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___33268,res,vec__33009,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33025){
var vec__33026 = p__33025;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33026,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33026,(1),null);
var job = vec__33026;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4376__auto___33271 = n;
var __33272 = (0);
while(true){
if((__33272 < n__4376__auto___33271)){
var G__33029_33273 = type;
var G__33029_33274__$1 = (((G__33029_33273 instanceof cljs.core.Keyword))?G__33029_33273.fqn:null);
switch (G__33029_33274__$1) {
case "compute":
var c__32612__auto___33276 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33272,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (__33272,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function (state_33045){
var state_val_33046 = (state_33045[(1)]);
if((state_val_33046 === (1))){
var state_33045__$1 = state_33045;
var statearr_33047_33277 = state_33045__$1;
(statearr_33047_33277[(2)] = null);

(statearr_33047_33277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (2))){
var state_33045__$1 = state_33045;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33045__$1,(4),jobs);
} else {
if((state_val_33046 === (3))){
var inst_33043 = (state_33045[(2)]);
var state_33045__$1 = state_33045;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33045__$1,inst_33043);
} else {
if((state_val_33046 === (4))){
var inst_33035 = (state_33045[(2)]);
var inst_33036 = process(inst_33035);
var state_33045__$1 = state_33045;
if(cljs.core.truth_(inst_33036)){
var statearr_33048_33278 = state_33045__$1;
(statearr_33048_33278[(1)] = (5));

} else {
var statearr_33049_33279 = state_33045__$1;
(statearr_33049_33279[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (5))){
var state_33045__$1 = state_33045;
var statearr_33050_33280 = state_33045__$1;
(statearr_33050_33280[(2)] = null);

(statearr_33050_33280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (6))){
var state_33045__$1 = state_33045;
var statearr_33051_33281 = state_33045__$1;
(statearr_33051_33281[(2)] = null);

(statearr_33051_33281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (7))){
var inst_33041 = (state_33045[(2)]);
var state_33045__$1 = state_33045;
var statearr_33052_33282 = state_33045__$1;
(statearr_33052_33282[(2)] = inst_33041);

(statearr_33052_33282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33272,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
;
return ((function (__33272,switch__32540__auto__,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_33053 = [null,null,null,null,null,null,null];
(statearr_33053[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__);

(statearr_33053[(1)] = (1));

return statearr_33053;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1 = (function (state_33045){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33045);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33054){if((e33054 instanceof Object)){
var ex__32544__auto__ = e33054;
var statearr_33055_33283 = state_33045;
(statearr_33055_33283[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33045);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33054;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33284 = state_33045;
state_33045 = G__33284;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = function(state_33045){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1.call(this,state_33045);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__;
})()
;})(__33272,switch__32540__auto__,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
})();
var state__32614__auto__ = (function (){var statearr_33056 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33056[(6)] = c__32612__auto___33276);

return statearr_33056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(__33272,c__32612__auto___33276,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
);


break;
case "async":
var c__32612__auto___33285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33272,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (__33272,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function (state_33073){
var state_val_33074 = (state_33073[(1)]);
if((state_val_33074 === (1))){
var state_33073__$1 = state_33073;
var statearr_33075_33286 = state_33073__$1;
(statearr_33075_33286[(2)] = null);

(statearr_33075_33286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (2))){
var state_33073__$1 = state_33073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33073__$1,(4),jobs);
} else {
if((state_val_33074 === (3))){
var inst_33071 = (state_33073[(2)]);
var state_33073__$1 = state_33073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33073__$1,inst_33071);
} else {
if((state_val_33074 === (4))){
var inst_33059 = (state_33073[(2)]);
var inst_33064 = async(inst_33059);
var state_33073__$1 = state_33073;
if(cljs.core.truth_(inst_33064)){
var statearr_33076_33287 = state_33073__$1;
(statearr_33076_33287[(1)] = (5));

} else {
var statearr_33079_33288 = state_33073__$1;
(statearr_33079_33288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (5))){
var state_33073__$1 = state_33073;
var statearr_33084_33289 = state_33073__$1;
(statearr_33084_33289[(2)] = null);

(statearr_33084_33289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (6))){
var state_33073__$1 = state_33073;
var statearr_33088_33290 = state_33073__$1;
(statearr_33088_33290[(2)] = null);

(statearr_33088_33290[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33074 === (7))){
var inst_33069 = (state_33073[(2)]);
var state_33073__$1 = state_33073;
var statearr_33092_33291 = state_33073__$1;
(statearr_33092_33291[(2)] = inst_33069);

(statearr_33092_33291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33272,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
;
return ((function (__33272,switch__32540__auto__,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_33093 = [null,null,null,null,null,null,null];
(statearr_33093[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__);

(statearr_33093[(1)] = (1));

return statearr_33093;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1 = (function (state_33073){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33073);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33097){if((e33097 instanceof Object)){
var ex__32544__auto__ = e33097;
var statearr_33098_33292 = state_33073;
(statearr_33098_33292[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33097;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33293 = state_33073;
state_33073 = G__33293;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = function(state_33073){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1.call(this,state_33073);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__;
})()
;})(__33272,switch__32540__auto__,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
})();
var state__32614__auto__ = (function (){var statearr_33102 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33102[(6)] = c__32612__auto___33285);

return statearr_33102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(__33272,c__32612__auto___33285,G__33029_33273,G__33029_33274__$1,n__4376__auto___33271,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33029_33274__$1)].join('')));

}

var G__33294 = (__33272 + (1));
__33272 = G__33294;
continue;
} else {
}
break;
}

var c__32612__auto___33295 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___33295,jobs,results,process,async){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___33295,jobs,results,process,async){
return (function (state_33136){
var state_val_33137 = (state_33136[(1)]);
if((state_val_33137 === (1))){
var state_33136__$1 = state_33136;
var statearr_33147_33296 = state_33136__$1;
(statearr_33147_33296[(2)] = null);

(statearr_33147_33296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33137 === (2))){
var state_33136__$1 = state_33136;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33136__$1,(4),from);
} else {
if((state_val_33137 === (3))){
var inst_33133 = (state_33136[(2)]);
var state_33136__$1 = state_33136;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33136__$1,inst_33133);
} else {
if((state_val_33137 === (4))){
var inst_33109 = (state_33136[(7)]);
var inst_33109__$1 = (state_33136[(2)]);
var inst_33110 = (inst_33109__$1 == null);
var state_33136__$1 = (function (){var statearr_33158 = state_33136;
(statearr_33158[(7)] = inst_33109__$1);

return statearr_33158;
})();
if(cljs.core.truth_(inst_33110)){
var statearr_33163_33297 = state_33136__$1;
(statearr_33163_33297[(1)] = (5));

} else {
var statearr_33164_33298 = state_33136__$1;
(statearr_33164_33298[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33137 === (5))){
var inst_33112 = cljs.core.async.close_BANG_(jobs);
var state_33136__$1 = state_33136;
var statearr_33167_33299 = state_33136__$1;
(statearr_33167_33299[(2)] = inst_33112);

(statearr_33167_33299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33137 === (6))){
var inst_33114 = (state_33136[(8)]);
var inst_33109 = (state_33136[(7)]);
var inst_33114__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_33120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33122 = [inst_33109,inst_33114__$1];
var inst_33123 = (new cljs.core.PersistentVector(null,2,(5),inst_33120,inst_33122,null));
var state_33136__$1 = (function (){var statearr_33173 = state_33136;
(statearr_33173[(8)] = inst_33114__$1);

return statearr_33173;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33136__$1,(8),jobs,inst_33123);
} else {
if((state_val_33137 === (7))){
var inst_33130 = (state_33136[(2)]);
var state_33136__$1 = state_33136;
var statearr_33177_33300 = state_33136__$1;
(statearr_33177_33300[(2)] = inst_33130);

(statearr_33177_33300[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33137 === (8))){
var inst_33114 = (state_33136[(8)]);
var inst_33125 = (state_33136[(2)]);
var state_33136__$1 = (function (){var statearr_33181 = state_33136;
(statearr_33181[(9)] = inst_33125);

return statearr_33181;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33136__$1,(9),results,inst_33114);
} else {
if((state_val_33137 === (9))){
var inst_33127 = (state_33136[(2)]);
var state_33136__$1 = (function (){var statearr_33182 = state_33136;
(statearr_33182[(10)] = inst_33127);

return statearr_33182;
})();
var statearr_33187_33301 = state_33136__$1;
(statearr_33187_33301[(2)] = null);

(statearr_33187_33301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___33295,jobs,results,process,async))
;
return ((function (switch__32540__auto__,c__32612__auto___33295,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_33188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33188[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__);

(statearr_33188[(1)] = (1));

return statearr_33188;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1 = (function (state_33136){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33136);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33189){if((e33189 instanceof Object)){
var ex__32544__auto__ = e33189;
var statearr_33190_33302 = state_33136;
(statearr_33190_33302[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33189;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33303 = state_33136;
state_33136 = G__33303;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = function(state_33136){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1.call(this,state_33136);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___33295,jobs,results,process,async))
})();
var state__32614__auto__ = (function (){var statearr_33191 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33191[(6)] = c__32612__auto___33295);

return statearr_33191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___33295,jobs,results,process,async))
);


var c__32612__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto__,jobs,results,process,async){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto__,jobs,results,process,async){
return (function (state_33229){
var state_val_33230 = (state_33229[(1)]);
if((state_val_33230 === (7))){
var inst_33225 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
var statearr_33233_33304 = state_33229__$1;
(statearr_33233_33304[(2)] = inst_33225);

(statearr_33233_33304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (20))){
var state_33229__$1 = state_33229;
var statearr_33234_33305 = state_33229__$1;
(statearr_33234_33305[(2)] = null);

(statearr_33234_33305[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (1))){
var state_33229__$1 = state_33229;
var statearr_33235_33306 = state_33229__$1;
(statearr_33235_33306[(2)] = null);

(statearr_33235_33306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (4))){
var inst_33194 = (state_33229[(7)]);
var inst_33194__$1 = (state_33229[(2)]);
var inst_33195 = (inst_33194__$1 == null);
var state_33229__$1 = (function (){var statearr_33236 = state_33229;
(statearr_33236[(7)] = inst_33194__$1);

return statearr_33236;
})();
if(cljs.core.truth_(inst_33195)){
var statearr_33237_33307 = state_33229__$1;
(statearr_33237_33307[(1)] = (5));

} else {
var statearr_33238_33308 = state_33229__$1;
(statearr_33238_33308[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (15))){
var inst_33207 = (state_33229[(8)]);
var state_33229__$1 = state_33229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33229__$1,(18),to,inst_33207);
} else {
if((state_val_33230 === (21))){
var inst_33220 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
var statearr_33239_33309 = state_33229__$1;
(statearr_33239_33309[(2)] = inst_33220);

(statearr_33239_33309[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (13))){
var inst_33222 = (state_33229[(2)]);
var state_33229__$1 = (function (){var statearr_33240 = state_33229;
(statearr_33240[(9)] = inst_33222);

return statearr_33240;
})();
var statearr_33241_33310 = state_33229__$1;
(statearr_33241_33310[(2)] = null);

(statearr_33241_33310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (6))){
var inst_33194 = (state_33229[(7)]);
var state_33229__$1 = state_33229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33229__$1,(11),inst_33194);
} else {
if((state_val_33230 === (17))){
var inst_33215 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
if(cljs.core.truth_(inst_33215)){
var statearr_33242_33311 = state_33229__$1;
(statearr_33242_33311[(1)] = (19));

} else {
var statearr_33243_33312 = state_33229__$1;
(statearr_33243_33312[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (3))){
var inst_33227 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33229__$1,inst_33227);
} else {
if((state_val_33230 === (12))){
var inst_33204 = (state_33229[(10)]);
var state_33229__$1 = state_33229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33229__$1,(14),inst_33204);
} else {
if((state_val_33230 === (2))){
var state_33229__$1 = state_33229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33229__$1,(4),results);
} else {
if((state_val_33230 === (19))){
var state_33229__$1 = state_33229;
var statearr_33247_33313 = state_33229__$1;
(statearr_33247_33313[(2)] = null);

(statearr_33247_33313[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (11))){
var inst_33204 = (state_33229[(2)]);
var state_33229__$1 = (function (){var statearr_33248 = state_33229;
(statearr_33248[(10)] = inst_33204);

return statearr_33248;
})();
var statearr_33249_33314 = state_33229__$1;
(statearr_33249_33314[(2)] = null);

(statearr_33249_33314[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (9))){
var state_33229__$1 = state_33229;
var statearr_33250_33315 = state_33229__$1;
(statearr_33250_33315[(2)] = null);

(statearr_33250_33315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (5))){
var state_33229__$1 = state_33229;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33251_33316 = state_33229__$1;
(statearr_33251_33316[(1)] = (8));

} else {
var statearr_33253_33317 = state_33229__$1;
(statearr_33253_33317[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (14))){
var inst_33207 = (state_33229[(8)]);
var inst_33209 = (state_33229[(11)]);
var inst_33207__$1 = (state_33229[(2)]);
var inst_33208 = (inst_33207__$1 == null);
var inst_33209__$1 = cljs.core.not(inst_33208);
var state_33229__$1 = (function (){var statearr_33254 = state_33229;
(statearr_33254[(8)] = inst_33207__$1);

(statearr_33254[(11)] = inst_33209__$1);

return statearr_33254;
})();
if(inst_33209__$1){
var statearr_33255_33318 = state_33229__$1;
(statearr_33255_33318[(1)] = (15));

} else {
var statearr_33256_33319 = state_33229__$1;
(statearr_33256_33319[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (16))){
var inst_33209 = (state_33229[(11)]);
var state_33229__$1 = state_33229;
var statearr_33257_33320 = state_33229__$1;
(statearr_33257_33320[(2)] = inst_33209);

(statearr_33257_33320[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (10))){
var inst_33201 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
var statearr_33258_33321 = state_33229__$1;
(statearr_33258_33321[(2)] = inst_33201);

(statearr_33258_33321[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (18))){
var inst_33212 = (state_33229[(2)]);
var state_33229__$1 = state_33229;
var statearr_33259_33322 = state_33229__$1;
(statearr_33259_33322[(2)] = inst_33212);

(statearr_33259_33322[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33230 === (8))){
var inst_33198 = cljs.core.async.close_BANG_(to);
var state_33229__$1 = state_33229;
var statearr_33260_33323 = state_33229__$1;
(statearr_33260_33323[(2)] = inst_33198);

(statearr_33260_33323[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto__,jobs,results,process,async))
;
return ((function (switch__32540__auto__,c__32612__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_33261 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33261[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__);

(statearr_33261[(1)] = (1));

return statearr_33261;
});
var cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1 = (function (state_33229){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33229);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33262){if((e33262 instanceof Object)){
var ex__32544__auto__ = e33262;
var statearr_33263_33324 = state_33229;
(statearr_33263_33324[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33325 = state_33229;
state_33229 = G__33325;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__ = function(state_33229){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1.call(this,state_33229);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto__,jobs,results,process,async))
})();
var state__32614__auto__ = (function (){var statearr_33265 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33265[(6)] = c__32612__auto__);

return statearr_33265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto__,jobs,results,process,async))
);

return c__32612__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__33327 = arguments.length;
switch (G__33327) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__33330 = arguments.length;
switch (G__33330) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__33333 = arguments.length;
switch (G__33333) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__32612__auto___33382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___33382,tc,fc){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___33382,tc,fc){
return (function (state_33359){
var state_val_33360 = (state_33359[(1)]);
if((state_val_33360 === (7))){
var inst_33355 = (state_33359[(2)]);
var state_33359__$1 = state_33359;
var statearr_33361_33383 = state_33359__$1;
(statearr_33361_33383[(2)] = inst_33355);

(statearr_33361_33383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (1))){
var state_33359__$1 = state_33359;
var statearr_33362_33384 = state_33359__$1;
(statearr_33362_33384[(2)] = null);

(statearr_33362_33384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (4))){
var inst_33336 = (state_33359[(7)]);
var inst_33336__$1 = (state_33359[(2)]);
var inst_33337 = (inst_33336__$1 == null);
var state_33359__$1 = (function (){var statearr_33363 = state_33359;
(statearr_33363[(7)] = inst_33336__$1);

return statearr_33363;
})();
if(cljs.core.truth_(inst_33337)){
var statearr_33364_33385 = state_33359__$1;
(statearr_33364_33385[(1)] = (5));

} else {
var statearr_33365_33386 = state_33359__$1;
(statearr_33365_33386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (13))){
var state_33359__$1 = state_33359;
var statearr_33366_33387 = state_33359__$1;
(statearr_33366_33387[(2)] = null);

(statearr_33366_33387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (6))){
var inst_33336 = (state_33359[(7)]);
var inst_33342 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33336) : p.call(null,inst_33336));
var state_33359__$1 = state_33359;
if(cljs.core.truth_(inst_33342)){
var statearr_33367_33388 = state_33359__$1;
(statearr_33367_33388[(1)] = (9));

} else {
var statearr_33368_33389 = state_33359__$1;
(statearr_33368_33389[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (3))){
var inst_33357 = (state_33359[(2)]);
var state_33359__$1 = state_33359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33359__$1,inst_33357);
} else {
if((state_val_33360 === (12))){
var state_33359__$1 = state_33359;
var statearr_33369_33390 = state_33359__$1;
(statearr_33369_33390[(2)] = null);

(statearr_33369_33390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (2))){
var state_33359__$1 = state_33359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33359__$1,(4),ch);
} else {
if((state_val_33360 === (11))){
var inst_33336 = (state_33359[(7)]);
var inst_33346 = (state_33359[(2)]);
var state_33359__$1 = state_33359;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33359__$1,(8),inst_33346,inst_33336);
} else {
if((state_val_33360 === (9))){
var state_33359__$1 = state_33359;
var statearr_33370_33391 = state_33359__$1;
(statearr_33370_33391[(2)] = tc);

(statearr_33370_33391[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (5))){
var inst_33339 = cljs.core.async.close_BANG_(tc);
var inst_33340 = cljs.core.async.close_BANG_(fc);
var state_33359__$1 = (function (){var statearr_33371 = state_33359;
(statearr_33371[(8)] = inst_33339);

return statearr_33371;
})();
var statearr_33372_33392 = state_33359__$1;
(statearr_33372_33392[(2)] = inst_33340);

(statearr_33372_33392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (14))){
var inst_33353 = (state_33359[(2)]);
var state_33359__$1 = state_33359;
var statearr_33373_33393 = state_33359__$1;
(statearr_33373_33393[(2)] = inst_33353);

(statearr_33373_33393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (10))){
var state_33359__$1 = state_33359;
var statearr_33374_33394 = state_33359__$1;
(statearr_33374_33394[(2)] = fc);

(statearr_33374_33394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33360 === (8))){
var inst_33348 = (state_33359[(2)]);
var state_33359__$1 = state_33359;
if(cljs.core.truth_(inst_33348)){
var statearr_33375_33395 = state_33359__$1;
(statearr_33375_33395[(1)] = (12));

} else {
var statearr_33376_33396 = state_33359__$1;
(statearr_33376_33396[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___33382,tc,fc))
;
return ((function (switch__32540__auto__,c__32612__auto___33382,tc,fc){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_33377 = [null,null,null,null,null,null,null,null,null];
(statearr_33377[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_33377[(1)] = (1));

return statearr_33377;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_33359){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33359);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33378){if((e33378 instanceof Object)){
var ex__32544__auto__ = e33378;
var statearr_33379_33397 = state_33359;
(statearr_33379_33397[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33378;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33398 = state_33359;
state_33359 = G__33398;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_33359){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_33359);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___33382,tc,fc))
})();
var state__32614__auto__ = (function (){var statearr_33380 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33380[(6)] = c__32612__auto___33382);

return statearr_33380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___33382,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__32612__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto__){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto__){
return (function (state_33419){
var state_val_33420 = (state_33419[(1)]);
if((state_val_33420 === (7))){
var inst_33415 = (state_33419[(2)]);
var state_33419__$1 = state_33419;
var statearr_33421_33439 = state_33419__$1;
(statearr_33421_33439[(2)] = inst_33415);

(statearr_33421_33439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (1))){
var inst_33399 = init;
var state_33419__$1 = (function (){var statearr_33422 = state_33419;
(statearr_33422[(7)] = inst_33399);

return statearr_33422;
})();
var statearr_33423_33440 = state_33419__$1;
(statearr_33423_33440[(2)] = null);

(statearr_33423_33440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (4))){
var inst_33402 = (state_33419[(8)]);
var inst_33402__$1 = (state_33419[(2)]);
var inst_33403 = (inst_33402__$1 == null);
var state_33419__$1 = (function (){var statearr_33424 = state_33419;
(statearr_33424[(8)] = inst_33402__$1);

return statearr_33424;
})();
if(cljs.core.truth_(inst_33403)){
var statearr_33425_33441 = state_33419__$1;
(statearr_33425_33441[(1)] = (5));

} else {
var statearr_33426_33442 = state_33419__$1;
(statearr_33426_33442[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (6))){
var inst_33406 = (state_33419[(9)]);
var inst_33399 = (state_33419[(7)]);
var inst_33402 = (state_33419[(8)]);
var inst_33406__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_33399,inst_33402) : f.call(null,inst_33399,inst_33402));
var inst_33407 = cljs.core.reduced_QMARK_(inst_33406__$1);
var state_33419__$1 = (function (){var statearr_33427 = state_33419;
(statearr_33427[(9)] = inst_33406__$1);

return statearr_33427;
})();
if(inst_33407){
var statearr_33428_33443 = state_33419__$1;
(statearr_33428_33443[(1)] = (8));

} else {
var statearr_33429_33444 = state_33419__$1;
(statearr_33429_33444[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (3))){
var inst_33417 = (state_33419[(2)]);
var state_33419__$1 = state_33419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33419__$1,inst_33417);
} else {
if((state_val_33420 === (2))){
var state_33419__$1 = state_33419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33419__$1,(4),ch);
} else {
if((state_val_33420 === (9))){
var inst_33406 = (state_33419[(9)]);
var inst_33399 = inst_33406;
var state_33419__$1 = (function (){var statearr_33430 = state_33419;
(statearr_33430[(7)] = inst_33399);

return statearr_33430;
})();
var statearr_33431_33445 = state_33419__$1;
(statearr_33431_33445[(2)] = null);

(statearr_33431_33445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (5))){
var inst_33399 = (state_33419[(7)]);
var state_33419__$1 = state_33419;
var statearr_33432_33446 = state_33419__$1;
(statearr_33432_33446[(2)] = inst_33399);

(statearr_33432_33446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (10))){
var inst_33413 = (state_33419[(2)]);
var state_33419__$1 = state_33419;
var statearr_33433_33447 = state_33419__$1;
(statearr_33433_33447[(2)] = inst_33413);

(statearr_33433_33447[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33420 === (8))){
var inst_33406 = (state_33419[(9)]);
var inst_33409 = cljs.core.deref(inst_33406);
var state_33419__$1 = state_33419;
var statearr_33434_33448 = state_33419__$1;
(statearr_33434_33448[(2)] = inst_33409);

(statearr_33434_33448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto__))
;
return ((function (switch__32540__auto__,c__32612__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__32541__auto__ = null;
var cljs$core$async$reduce_$_state_machine__32541__auto____0 = (function (){
var statearr_33435 = [null,null,null,null,null,null,null,null,null,null];
(statearr_33435[(0)] = cljs$core$async$reduce_$_state_machine__32541__auto__);

(statearr_33435[(1)] = (1));

return statearr_33435;
});
var cljs$core$async$reduce_$_state_machine__32541__auto____1 = (function (state_33419){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33419);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33436){if((e33436 instanceof Object)){
var ex__32544__auto__ = e33436;
var statearr_33437_33449 = state_33419;
(statearr_33437_33449[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33419);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33436;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33450 = state_33419;
state_33419 = G__33450;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__32541__auto__ = function(state_33419){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__32541__auto____1.call(this,state_33419);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__32541__auto____0;
cljs$core$async$reduce_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__32541__auto____1;
return cljs$core$async$reduce_$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto__))
})();
var state__32614__auto__ = (function (){var statearr_33438 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33438[(6)] = c__32612__auto__);

return statearr_33438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto__))
);

return c__32612__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__32612__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto__,f__$1){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto__,f__$1){
return (function (state_33456){
var state_val_33457 = (state_33456[(1)]);
if((state_val_33457 === (1))){
var inst_33451 = cljs.core.async.reduce(f__$1,init,ch);
var state_33456__$1 = state_33456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33456__$1,(2),inst_33451);
} else {
if((state_val_33457 === (2))){
var inst_33453 = (state_33456[(2)]);
var inst_33454 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_33453) : f__$1.call(null,inst_33453));
var state_33456__$1 = state_33456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33456__$1,inst_33454);
} else {
return null;
}
}
});})(c__32612__auto__,f__$1))
;
return ((function (switch__32540__auto__,c__32612__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__32541__auto__ = null;
var cljs$core$async$transduce_$_state_machine__32541__auto____0 = (function (){
var statearr_33458 = [null,null,null,null,null,null,null];
(statearr_33458[(0)] = cljs$core$async$transduce_$_state_machine__32541__auto__);

(statearr_33458[(1)] = (1));

return statearr_33458;
});
var cljs$core$async$transduce_$_state_machine__32541__auto____1 = (function (state_33456){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33456);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33459){if((e33459 instanceof Object)){
var ex__32544__auto__ = e33459;
var statearr_33460_33462 = state_33456;
(statearr_33460_33462[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33456);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33459;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33463 = state_33456;
state_33456 = G__33463;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__32541__auto__ = function(state_33456){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__32541__auto____1.call(this,state_33456);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__32541__auto____0;
cljs$core$async$transduce_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__32541__auto____1;
return cljs$core$async$transduce_$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto__,f__$1))
})();
var state__32614__auto__ = (function (){var statearr_33461 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33461[(6)] = c__32612__auto__);

return statearr_33461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto__,f__$1))
);

return c__32612__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__33465 = arguments.length;
switch (G__33465) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__32612__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto__){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto__){
return (function (state_33490){
var state_val_33491 = (state_33490[(1)]);
if((state_val_33491 === (7))){
var inst_33472 = (state_33490[(2)]);
var state_33490__$1 = state_33490;
var statearr_33492_33513 = state_33490__$1;
(statearr_33492_33513[(2)] = inst_33472);

(statearr_33492_33513[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (1))){
var inst_33466 = cljs.core.seq(coll);
var inst_33467 = inst_33466;
var state_33490__$1 = (function (){var statearr_33493 = state_33490;
(statearr_33493[(7)] = inst_33467);

return statearr_33493;
})();
var statearr_33494_33514 = state_33490__$1;
(statearr_33494_33514[(2)] = null);

(statearr_33494_33514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (4))){
var inst_33467 = (state_33490[(7)]);
var inst_33470 = cljs.core.first(inst_33467);
var state_33490__$1 = state_33490;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33490__$1,(7),ch,inst_33470);
} else {
if((state_val_33491 === (13))){
var inst_33484 = (state_33490[(2)]);
var state_33490__$1 = state_33490;
var statearr_33495_33515 = state_33490__$1;
(statearr_33495_33515[(2)] = inst_33484);

(statearr_33495_33515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (6))){
var inst_33475 = (state_33490[(2)]);
var state_33490__$1 = state_33490;
if(cljs.core.truth_(inst_33475)){
var statearr_33496_33516 = state_33490__$1;
(statearr_33496_33516[(1)] = (8));

} else {
var statearr_33497_33517 = state_33490__$1;
(statearr_33497_33517[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (3))){
var inst_33488 = (state_33490[(2)]);
var state_33490__$1 = state_33490;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33490__$1,inst_33488);
} else {
if((state_val_33491 === (12))){
var state_33490__$1 = state_33490;
var statearr_33498_33518 = state_33490__$1;
(statearr_33498_33518[(2)] = null);

(statearr_33498_33518[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (2))){
var inst_33467 = (state_33490[(7)]);
var state_33490__$1 = state_33490;
if(cljs.core.truth_(inst_33467)){
var statearr_33499_33519 = state_33490__$1;
(statearr_33499_33519[(1)] = (4));

} else {
var statearr_33500_33520 = state_33490__$1;
(statearr_33500_33520[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (11))){
var inst_33481 = cljs.core.async.close_BANG_(ch);
var state_33490__$1 = state_33490;
var statearr_33501_33521 = state_33490__$1;
(statearr_33501_33521[(2)] = inst_33481);

(statearr_33501_33521[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (9))){
var state_33490__$1 = state_33490;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33502_33522 = state_33490__$1;
(statearr_33502_33522[(1)] = (11));

} else {
var statearr_33503_33523 = state_33490__$1;
(statearr_33503_33523[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (5))){
var inst_33467 = (state_33490[(7)]);
var state_33490__$1 = state_33490;
var statearr_33504_33524 = state_33490__$1;
(statearr_33504_33524[(2)] = inst_33467);

(statearr_33504_33524[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (10))){
var inst_33486 = (state_33490[(2)]);
var state_33490__$1 = state_33490;
var statearr_33505_33525 = state_33490__$1;
(statearr_33505_33525[(2)] = inst_33486);

(statearr_33505_33525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33491 === (8))){
var inst_33467 = (state_33490[(7)]);
var inst_33477 = cljs.core.next(inst_33467);
var inst_33467__$1 = inst_33477;
var state_33490__$1 = (function (){var statearr_33506 = state_33490;
(statearr_33506[(7)] = inst_33467__$1);

return statearr_33506;
})();
var statearr_33507_33526 = state_33490__$1;
(statearr_33507_33526[(2)] = null);

(statearr_33507_33526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto__))
;
return ((function (switch__32540__auto__,c__32612__auto__){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_33508 = [null,null,null,null,null,null,null,null];
(statearr_33508[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_33508[(1)] = (1));

return statearr_33508;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_33490){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33490);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33509){if((e33509 instanceof Object)){
var ex__32544__auto__ = e33509;
var statearr_33510_33527 = state_33490;
(statearr_33510_33527[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33490);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33509;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33528 = state_33490;
state_33490 = G__33528;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_33490){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_33490);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto__))
})();
var state__32614__auto__ = (function (){var statearr_33511 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33511[(6)] = c__32612__auto__);

return statearr_33511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto__))
);

return c__32612__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4211__auto__ = (((_ == null))?null:_);
var m__4212__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4212__auto__.call(null,_));
} else {
var m__4212__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__4212__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4212__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4212__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4212__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto__.call(null,m,ch));
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4212__auto__.call(null,m));
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4212__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33529 = (function (ch,cs,meta33530){
this.ch = ch;
this.cs = cs;
this.meta33530 = meta33530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_33531,meta33530__$1){
var self__ = this;
var _33531__$1 = this;
return (new cljs.core.async.t_cljs$core$async33529(self__.ch,self__.cs,meta33530__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_33531){
var self__ = this;
var _33531__$1 = this;
return self__.meta33530;
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta33530","meta33530",167622431,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async33529.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33529";

cljs.core.async.t_cljs$core$async33529.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async33529");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33529.
 */
cljs.core.async.__GT_t_cljs$core$async33529 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async33529(ch__$1,cs__$1,meta33530){
return (new cljs.core.async.t_cljs$core$async33529(ch__$1,cs__$1,meta33530));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async33529(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__32612__auto___33751 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___33751,cs,m,dchan,dctr,done){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___33751,cs,m,dchan,dctr,done){
return (function (state_33666){
var state_val_33667 = (state_33666[(1)]);
if((state_val_33667 === (7))){
var inst_33662 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33668_33752 = state_33666__$1;
(statearr_33668_33752[(2)] = inst_33662);

(statearr_33668_33752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (20))){
var inst_33565 = (state_33666[(7)]);
var inst_33577 = cljs.core.first(inst_33565);
var inst_33578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33577,(0),null);
var inst_33579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33577,(1),null);
var state_33666__$1 = (function (){var statearr_33669 = state_33666;
(statearr_33669[(8)] = inst_33578);

return statearr_33669;
})();
if(cljs.core.truth_(inst_33579)){
var statearr_33670_33753 = state_33666__$1;
(statearr_33670_33753[(1)] = (22));

} else {
var statearr_33671_33754 = state_33666__$1;
(statearr_33671_33754[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (27))){
var inst_33614 = (state_33666[(9)]);
var inst_33609 = (state_33666[(10)]);
var inst_33534 = (state_33666[(11)]);
var inst_33607 = (state_33666[(12)]);
var inst_33614__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33607,inst_33609);
var inst_33615 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33614__$1,inst_33534,done);
var state_33666__$1 = (function (){var statearr_33672 = state_33666;
(statearr_33672[(9)] = inst_33614__$1);

return statearr_33672;
})();
if(cljs.core.truth_(inst_33615)){
var statearr_33673_33755 = state_33666__$1;
(statearr_33673_33755[(1)] = (30));

} else {
var statearr_33674_33756 = state_33666__$1;
(statearr_33674_33756[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (1))){
var state_33666__$1 = state_33666;
var statearr_33675_33757 = state_33666__$1;
(statearr_33675_33757[(2)] = null);

(statearr_33675_33757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (24))){
var inst_33565 = (state_33666[(7)]);
var inst_33584 = (state_33666[(2)]);
var inst_33585 = cljs.core.next(inst_33565);
var inst_33543 = inst_33585;
var inst_33544 = null;
var inst_33545 = (0);
var inst_33546 = (0);
var state_33666__$1 = (function (){var statearr_33676 = state_33666;
(statearr_33676[(13)] = inst_33545);

(statearr_33676[(14)] = inst_33543);

(statearr_33676[(15)] = inst_33584);

(statearr_33676[(16)] = inst_33544);

(statearr_33676[(17)] = inst_33546);

return statearr_33676;
})();
var statearr_33677_33758 = state_33666__$1;
(statearr_33677_33758[(2)] = null);

(statearr_33677_33758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (39))){
var state_33666__$1 = state_33666;
var statearr_33681_33759 = state_33666__$1;
(statearr_33681_33759[(2)] = null);

(statearr_33681_33759[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (4))){
var inst_33534 = (state_33666[(11)]);
var inst_33534__$1 = (state_33666[(2)]);
var inst_33535 = (inst_33534__$1 == null);
var state_33666__$1 = (function (){var statearr_33682 = state_33666;
(statearr_33682[(11)] = inst_33534__$1);

return statearr_33682;
})();
if(cljs.core.truth_(inst_33535)){
var statearr_33683_33760 = state_33666__$1;
(statearr_33683_33760[(1)] = (5));

} else {
var statearr_33684_33761 = state_33666__$1;
(statearr_33684_33761[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (15))){
var inst_33545 = (state_33666[(13)]);
var inst_33543 = (state_33666[(14)]);
var inst_33544 = (state_33666[(16)]);
var inst_33546 = (state_33666[(17)]);
var inst_33561 = (state_33666[(2)]);
var inst_33562 = (inst_33546 + (1));
var tmp33678 = inst_33545;
var tmp33679 = inst_33543;
var tmp33680 = inst_33544;
var inst_33543__$1 = tmp33679;
var inst_33544__$1 = tmp33680;
var inst_33545__$1 = tmp33678;
var inst_33546__$1 = inst_33562;
var state_33666__$1 = (function (){var statearr_33685 = state_33666;
(statearr_33685[(13)] = inst_33545__$1);

(statearr_33685[(18)] = inst_33561);

(statearr_33685[(14)] = inst_33543__$1);

(statearr_33685[(16)] = inst_33544__$1);

(statearr_33685[(17)] = inst_33546__$1);

return statearr_33685;
})();
var statearr_33686_33762 = state_33666__$1;
(statearr_33686_33762[(2)] = null);

(statearr_33686_33762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (21))){
var inst_33588 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33690_33763 = state_33666__$1;
(statearr_33690_33763[(2)] = inst_33588);

(statearr_33690_33763[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (31))){
var inst_33614 = (state_33666[(9)]);
var inst_33618 = done(null);
var inst_33619 = cljs.core.async.untap_STAR_(m,inst_33614);
var state_33666__$1 = (function (){var statearr_33691 = state_33666;
(statearr_33691[(19)] = inst_33618);

return statearr_33691;
})();
var statearr_33692_33764 = state_33666__$1;
(statearr_33692_33764[(2)] = inst_33619);

(statearr_33692_33764[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (32))){
var inst_33609 = (state_33666[(10)]);
var inst_33606 = (state_33666[(20)]);
var inst_33608 = (state_33666[(21)]);
var inst_33607 = (state_33666[(12)]);
var inst_33621 = (state_33666[(2)]);
var inst_33622 = (inst_33609 + (1));
var tmp33687 = inst_33606;
var tmp33688 = inst_33608;
var tmp33689 = inst_33607;
var inst_33606__$1 = tmp33687;
var inst_33607__$1 = tmp33689;
var inst_33608__$1 = tmp33688;
var inst_33609__$1 = inst_33622;
var state_33666__$1 = (function (){var statearr_33693 = state_33666;
(statearr_33693[(10)] = inst_33609__$1);

(statearr_33693[(20)] = inst_33606__$1);

(statearr_33693[(21)] = inst_33608__$1);

(statearr_33693[(22)] = inst_33621);

(statearr_33693[(12)] = inst_33607__$1);

return statearr_33693;
})();
var statearr_33694_33765 = state_33666__$1;
(statearr_33694_33765[(2)] = null);

(statearr_33694_33765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (40))){
var inst_33634 = (state_33666[(23)]);
var inst_33638 = done(null);
var inst_33639 = cljs.core.async.untap_STAR_(m,inst_33634);
var state_33666__$1 = (function (){var statearr_33695 = state_33666;
(statearr_33695[(24)] = inst_33638);

return statearr_33695;
})();
var statearr_33696_33766 = state_33666__$1;
(statearr_33696_33766[(2)] = inst_33639);

(statearr_33696_33766[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (33))){
var inst_33625 = (state_33666[(25)]);
var inst_33627 = cljs.core.chunked_seq_QMARK_(inst_33625);
var state_33666__$1 = state_33666;
if(inst_33627){
var statearr_33697_33767 = state_33666__$1;
(statearr_33697_33767[(1)] = (36));

} else {
var statearr_33698_33768 = state_33666__$1;
(statearr_33698_33768[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (13))){
var inst_33555 = (state_33666[(26)]);
var inst_33558 = cljs.core.async.close_BANG_(inst_33555);
var state_33666__$1 = state_33666;
var statearr_33699_33769 = state_33666__$1;
(statearr_33699_33769[(2)] = inst_33558);

(statearr_33699_33769[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (22))){
var inst_33578 = (state_33666[(8)]);
var inst_33581 = cljs.core.async.close_BANG_(inst_33578);
var state_33666__$1 = state_33666;
var statearr_33700_33770 = state_33666__$1;
(statearr_33700_33770[(2)] = inst_33581);

(statearr_33700_33770[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (36))){
var inst_33625 = (state_33666[(25)]);
var inst_33629 = cljs.core.chunk_first(inst_33625);
var inst_33630 = cljs.core.chunk_rest(inst_33625);
var inst_33631 = cljs.core.count(inst_33629);
var inst_33606 = inst_33630;
var inst_33607 = inst_33629;
var inst_33608 = inst_33631;
var inst_33609 = (0);
var state_33666__$1 = (function (){var statearr_33701 = state_33666;
(statearr_33701[(10)] = inst_33609);

(statearr_33701[(20)] = inst_33606);

(statearr_33701[(21)] = inst_33608);

(statearr_33701[(12)] = inst_33607);

return statearr_33701;
})();
var statearr_33702_33771 = state_33666__$1;
(statearr_33702_33771[(2)] = null);

(statearr_33702_33771[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (41))){
var inst_33625 = (state_33666[(25)]);
var inst_33641 = (state_33666[(2)]);
var inst_33642 = cljs.core.next(inst_33625);
var inst_33606 = inst_33642;
var inst_33607 = null;
var inst_33608 = (0);
var inst_33609 = (0);
var state_33666__$1 = (function (){var statearr_33703 = state_33666;
(statearr_33703[(10)] = inst_33609);

(statearr_33703[(27)] = inst_33641);

(statearr_33703[(20)] = inst_33606);

(statearr_33703[(21)] = inst_33608);

(statearr_33703[(12)] = inst_33607);

return statearr_33703;
})();
var statearr_33704_33772 = state_33666__$1;
(statearr_33704_33772[(2)] = null);

(statearr_33704_33772[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (43))){
var state_33666__$1 = state_33666;
var statearr_33705_33773 = state_33666__$1;
(statearr_33705_33773[(2)] = null);

(statearr_33705_33773[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (29))){
var inst_33650 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33706_33774 = state_33666__$1;
(statearr_33706_33774[(2)] = inst_33650);

(statearr_33706_33774[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (44))){
var inst_33659 = (state_33666[(2)]);
var state_33666__$1 = (function (){var statearr_33707 = state_33666;
(statearr_33707[(28)] = inst_33659);

return statearr_33707;
})();
var statearr_33708_33775 = state_33666__$1;
(statearr_33708_33775[(2)] = null);

(statearr_33708_33775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (6))){
var inst_33598 = (state_33666[(29)]);
var inst_33597 = cljs.core.deref(cs);
var inst_33598__$1 = cljs.core.keys(inst_33597);
var inst_33599 = cljs.core.count(inst_33598__$1);
var inst_33600 = cljs.core.reset_BANG_(dctr,inst_33599);
var inst_33605 = cljs.core.seq(inst_33598__$1);
var inst_33606 = inst_33605;
var inst_33607 = null;
var inst_33608 = (0);
var inst_33609 = (0);
var state_33666__$1 = (function (){var statearr_33709 = state_33666;
(statearr_33709[(10)] = inst_33609);

(statearr_33709[(30)] = inst_33600);

(statearr_33709[(20)] = inst_33606);

(statearr_33709[(29)] = inst_33598__$1);

(statearr_33709[(21)] = inst_33608);

(statearr_33709[(12)] = inst_33607);

return statearr_33709;
})();
var statearr_33710_33776 = state_33666__$1;
(statearr_33710_33776[(2)] = null);

(statearr_33710_33776[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (28))){
var inst_33606 = (state_33666[(20)]);
var inst_33625 = (state_33666[(25)]);
var inst_33625__$1 = cljs.core.seq(inst_33606);
var state_33666__$1 = (function (){var statearr_33711 = state_33666;
(statearr_33711[(25)] = inst_33625__$1);

return statearr_33711;
})();
if(inst_33625__$1){
var statearr_33712_33777 = state_33666__$1;
(statearr_33712_33777[(1)] = (33));

} else {
var statearr_33713_33778 = state_33666__$1;
(statearr_33713_33778[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (25))){
var inst_33609 = (state_33666[(10)]);
var inst_33608 = (state_33666[(21)]);
var inst_33611 = (inst_33609 < inst_33608);
var inst_33612 = inst_33611;
var state_33666__$1 = state_33666;
if(cljs.core.truth_(inst_33612)){
var statearr_33714_33779 = state_33666__$1;
(statearr_33714_33779[(1)] = (27));

} else {
var statearr_33715_33780 = state_33666__$1;
(statearr_33715_33780[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (34))){
var state_33666__$1 = state_33666;
var statearr_33716_33781 = state_33666__$1;
(statearr_33716_33781[(2)] = null);

(statearr_33716_33781[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (17))){
var state_33666__$1 = state_33666;
var statearr_33717_33782 = state_33666__$1;
(statearr_33717_33782[(2)] = null);

(statearr_33717_33782[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (3))){
var inst_33664 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33666__$1,inst_33664);
} else {
if((state_val_33667 === (12))){
var inst_33593 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33718_33783 = state_33666__$1;
(statearr_33718_33783[(2)] = inst_33593);

(statearr_33718_33783[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (2))){
var state_33666__$1 = state_33666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33666__$1,(4),ch);
} else {
if((state_val_33667 === (23))){
var state_33666__$1 = state_33666;
var statearr_33719_33784 = state_33666__$1;
(statearr_33719_33784[(2)] = null);

(statearr_33719_33784[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (35))){
var inst_33648 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33720_33785 = state_33666__$1;
(statearr_33720_33785[(2)] = inst_33648);

(statearr_33720_33785[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (19))){
var inst_33565 = (state_33666[(7)]);
var inst_33569 = cljs.core.chunk_first(inst_33565);
var inst_33570 = cljs.core.chunk_rest(inst_33565);
var inst_33571 = cljs.core.count(inst_33569);
var inst_33543 = inst_33570;
var inst_33544 = inst_33569;
var inst_33545 = inst_33571;
var inst_33546 = (0);
var state_33666__$1 = (function (){var statearr_33721 = state_33666;
(statearr_33721[(13)] = inst_33545);

(statearr_33721[(14)] = inst_33543);

(statearr_33721[(16)] = inst_33544);

(statearr_33721[(17)] = inst_33546);

return statearr_33721;
})();
var statearr_33722_33786 = state_33666__$1;
(statearr_33722_33786[(2)] = null);

(statearr_33722_33786[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (11))){
var inst_33543 = (state_33666[(14)]);
var inst_33565 = (state_33666[(7)]);
var inst_33565__$1 = cljs.core.seq(inst_33543);
var state_33666__$1 = (function (){var statearr_33723 = state_33666;
(statearr_33723[(7)] = inst_33565__$1);

return statearr_33723;
})();
if(inst_33565__$1){
var statearr_33724_33787 = state_33666__$1;
(statearr_33724_33787[(1)] = (16));

} else {
var statearr_33725_33788 = state_33666__$1;
(statearr_33725_33788[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (9))){
var inst_33595 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33726_33789 = state_33666__$1;
(statearr_33726_33789[(2)] = inst_33595);

(statearr_33726_33789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (5))){
var inst_33541 = cljs.core.deref(cs);
var inst_33542 = cljs.core.seq(inst_33541);
var inst_33543 = inst_33542;
var inst_33544 = null;
var inst_33545 = (0);
var inst_33546 = (0);
var state_33666__$1 = (function (){var statearr_33727 = state_33666;
(statearr_33727[(13)] = inst_33545);

(statearr_33727[(14)] = inst_33543);

(statearr_33727[(16)] = inst_33544);

(statearr_33727[(17)] = inst_33546);

return statearr_33727;
})();
var statearr_33728_33790 = state_33666__$1;
(statearr_33728_33790[(2)] = null);

(statearr_33728_33790[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (14))){
var state_33666__$1 = state_33666;
var statearr_33729_33791 = state_33666__$1;
(statearr_33729_33791[(2)] = null);

(statearr_33729_33791[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (45))){
var inst_33656 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33730_33792 = state_33666__$1;
(statearr_33730_33792[(2)] = inst_33656);

(statearr_33730_33792[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (26))){
var inst_33598 = (state_33666[(29)]);
var inst_33652 = (state_33666[(2)]);
var inst_33653 = cljs.core.seq(inst_33598);
var state_33666__$1 = (function (){var statearr_33731 = state_33666;
(statearr_33731[(31)] = inst_33652);

return statearr_33731;
})();
if(inst_33653){
var statearr_33732_33793 = state_33666__$1;
(statearr_33732_33793[(1)] = (42));

} else {
var statearr_33733_33794 = state_33666__$1;
(statearr_33733_33794[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (16))){
var inst_33565 = (state_33666[(7)]);
var inst_33567 = cljs.core.chunked_seq_QMARK_(inst_33565);
var state_33666__$1 = state_33666;
if(inst_33567){
var statearr_33734_33795 = state_33666__$1;
(statearr_33734_33795[(1)] = (19));

} else {
var statearr_33735_33796 = state_33666__$1;
(statearr_33735_33796[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (38))){
var inst_33645 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33736_33797 = state_33666__$1;
(statearr_33736_33797[(2)] = inst_33645);

(statearr_33736_33797[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (30))){
var state_33666__$1 = state_33666;
var statearr_33737_33798 = state_33666__$1;
(statearr_33737_33798[(2)] = null);

(statearr_33737_33798[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (10))){
var inst_33544 = (state_33666[(16)]);
var inst_33546 = (state_33666[(17)]);
var inst_33554 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33544,inst_33546);
var inst_33555 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33554,(0),null);
var inst_33556 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33554,(1),null);
var state_33666__$1 = (function (){var statearr_33738 = state_33666;
(statearr_33738[(26)] = inst_33555);

return statearr_33738;
})();
if(cljs.core.truth_(inst_33556)){
var statearr_33739_33799 = state_33666__$1;
(statearr_33739_33799[(1)] = (13));

} else {
var statearr_33740_33800 = state_33666__$1;
(statearr_33740_33800[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (18))){
var inst_33591 = (state_33666[(2)]);
var state_33666__$1 = state_33666;
var statearr_33741_33801 = state_33666__$1;
(statearr_33741_33801[(2)] = inst_33591);

(statearr_33741_33801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (42))){
var state_33666__$1 = state_33666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33666__$1,(45),dchan);
} else {
if((state_val_33667 === (37))){
var inst_33534 = (state_33666[(11)]);
var inst_33625 = (state_33666[(25)]);
var inst_33634 = (state_33666[(23)]);
var inst_33634__$1 = cljs.core.first(inst_33625);
var inst_33635 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33634__$1,inst_33534,done);
var state_33666__$1 = (function (){var statearr_33742 = state_33666;
(statearr_33742[(23)] = inst_33634__$1);

return statearr_33742;
})();
if(cljs.core.truth_(inst_33635)){
var statearr_33743_33802 = state_33666__$1;
(statearr_33743_33802[(1)] = (39));

} else {
var statearr_33744_33803 = state_33666__$1;
(statearr_33744_33803[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33667 === (8))){
var inst_33545 = (state_33666[(13)]);
var inst_33546 = (state_33666[(17)]);
var inst_33548 = (inst_33546 < inst_33545);
var inst_33549 = inst_33548;
var state_33666__$1 = state_33666;
if(cljs.core.truth_(inst_33549)){
var statearr_33745_33804 = state_33666__$1;
(statearr_33745_33804[(1)] = (10));

} else {
var statearr_33746_33805 = state_33666__$1;
(statearr_33746_33805[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___33751,cs,m,dchan,dctr,done))
;
return ((function (switch__32540__auto__,c__32612__auto___33751,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__32541__auto__ = null;
var cljs$core$async$mult_$_state_machine__32541__auto____0 = (function (){
var statearr_33747 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33747[(0)] = cljs$core$async$mult_$_state_machine__32541__auto__);

(statearr_33747[(1)] = (1));

return statearr_33747;
});
var cljs$core$async$mult_$_state_machine__32541__auto____1 = (function (state_33666){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33666);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33748){if((e33748 instanceof Object)){
var ex__32544__auto__ = e33748;
var statearr_33749_33806 = state_33666;
(statearr_33749_33806[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33748;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33807 = state_33666;
state_33666 = G__33807;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__32541__auto__ = function(state_33666){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__32541__auto____1.call(this,state_33666);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__32541__auto____0;
cljs$core$async$mult_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__32541__auto____1;
return cljs$core$async$mult_$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___33751,cs,m,dchan,dctr,done))
})();
var state__32614__auto__ = (function (){var statearr_33750 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33750[(6)] = c__32612__auto___33751);

return statearr_33750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___33751,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__33809 = arguments.length;
switch (G__33809) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto__.call(null,m,ch));
} else {
var m__4212__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto__.call(null,m,ch));
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4212__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4212__auto__.call(null,m));
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__4212__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4212__auto__.call(null,m,state_map));
} else {
var m__4212__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4212__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4212__auto__.call(null,m,mode));
} else {
var m__4212__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4212__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___33821 = arguments.length;
var i__4500__auto___33822 = (0);
while(true){
if((i__4500__auto___33822 < len__4499__auto___33821)){
args__4502__auto__.push((arguments[i__4500__auto___33822]));

var G__33823 = (i__4500__auto___33822 + (1));
i__4500__auto___33822 = G__33823;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33815){
var map__33816 = p__33815;
var map__33816__$1 = ((((!((map__33816 == null)))?(((((map__33816.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33816.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33816):map__33816);
var opts = map__33816__$1;
var statearr_33818_33824 = state;
(statearr_33818_33824[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__33816,map__33816__$1,opts){
return (function (val){
var statearr_33819_33825 = state;
(statearr_33819_33825[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__33816,map__33816__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_33820_33826 = state;
(statearr_33820_33826[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33811){
var G__33812 = cljs.core.first(seq33811);
var seq33811__$1 = cljs.core.next(seq33811);
var G__33813 = cljs.core.first(seq33811__$1);
var seq33811__$2 = cljs.core.next(seq33811__$1);
var G__33814 = cljs.core.first(seq33811__$2);
var seq33811__$3 = cljs.core.next(seq33811__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__33812,G__33813,G__33814,seq33811__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_(solos)))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33827 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33827 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33828){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33828 = meta33828;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33829,meta33828__$1){
var self__ = this;
var _33829__$1 = this;
return (new cljs.core.async.t_cljs$core$async33827(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33828__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33829){
var self__ = this;
var _33829__$1 = this;
return self__.meta33828;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta33828","meta33828",-1530047866,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33827.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33827.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33827";

cljs.core.async.t_cljs$core$async33827.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async33827");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async33827.
 */
cljs.core.async.__GT_t_cljs$core$async33827 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33827(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33828){
return (new cljs.core.async.t_cljs$core$async33827(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33828));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33827(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32612__auto___33991 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33931){
var state_val_33932 = (state_33931[(1)]);
if((state_val_33932 === (7))){
var inst_33846 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
var statearr_33933_33992 = state_33931__$1;
(statearr_33933_33992[(2)] = inst_33846);

(statearr_33933_33992[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (20))){
var inst_33858 = (state_33931[(7)]);
var state_33931__$1 = state_33931;
var statearr_33934_33993 = state_33931__$1;
(statearr_33934_33993[(2)] = inst_33858);

(statearr_33934_33993[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (27))){
var state_33931__$1 = state_33931;
var statearr_33935_33994 = state_33931__$1;
(statearr_33935_33994[(2)] = null);

(statearr_33935_33994[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (1))){
var inst_33833 = (state_33931[(8)]);
var inst_33833__$1 = calc_state();
var inst_33835 = (inst_33833__$1 == null);
var inst_33836 = cljs.core.not(inst_33835);
var state_33931__$1 = (function (){var statearr_33936 = state_33931;
(statearr_33936[(8)] = inst_33833__$1);

return statearr_33936;
})();
if(inst_33836){
var statearr_33937_33995 = state_33931__$1;
(statearr_33937_33995[(1)] = (2));

} else {
var statearr_33938_33996 = state_33931__$1;
(statearr_33938_33996[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (24))){
var inst_33882 = (state_33931[(9)]);
var inst_33905 = (state_33931[(10)]);
var inst_33891 = (state_33931[(11)]);
var inst_33905__$1 = (inst_33882.cljs$core$IFn$_invoke$arity$1 ? inst_33882.cljs$core$IFn$_invoke$arity$1(inst_33891) : inst_33882.call(null,inst_33891));
var state_33931__$1 = (function (){var statearr_33939 = state_33931;
(statearr_33939[(10)] = inst_33905__$1);

return statearr_33939;
})();
if(cljs.core.truth_(inst_33905__$1)){
var statearr_33940_33997 = state_33931__$1;
(statearr_33940_33997[(1)] = (29));

} else {
var statearr_33941_33998 = state_33931__$1;
(statearr_33941_33998[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (4))){
var inst_33849 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33849)){
var statearr_33942_33999 = state_33931__$1;
(statearr_33942_33999[(1)] = (8));

} else {
var statearr_33943_34000 = state_33931__$1;
(statearr_33943_34000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (15))){
var inst_33876 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33876)){
var statearr_33944_34001 = state_33931__$1;
(statearr_33944_34001[(1)] = (19));

} else {
var statearr_33945_34002 = state_33931__$1;
(statearr_33945_34002[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (21))){
var inst_33881 = (state_33931[(12)]);
var inst_33881__$1 = (state_33931[(2)]);
var inst_33882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33881__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33883 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33881__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33884 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33881__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_33931__$1 = (function (){var statearr_33946 = state_33931;
(statearr_33946[(13)] = inst_33883);

(statearr_33946[(12)] = inst_33881__$1);

(statearr_33946[(9)] = inst_33882);

return statearr_33946;
})();
return cljs.core.async.ioc_alts_BANG_(state_33931__$1,(22),inst_33884);
} else {
if((state_val_33932 === (31))){
var inst_33913 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33913)){
var statearr_33947_34003 = state_33931__$1;
(statearr_33947_34003[(1)] = (32));

} else {
var statearr_33948_34004 = state_33931__$1;
(statearr_33948_34004[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (32))){
var inst_33890 = (state_33931[(14)]);
var state_33931__$1 = state_33931;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33931__$1,(35),out,inst_33890);
} else {
if((state_val_33932 === (33))){
var inst_33881 = (state_33931[(12)]);
var inst_33858 = inst_33881;
var state_33931__$1 = (function (){var statearr_33949 = state_33931;
(statearr_33949[(7)] = inst_33858);

return statearr_33949;
})();
var statearr_33950_34005 = state_33931__$1;
(statearr_33950_34005[(2)] = null);

(statearr_33950_34005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (13))){
var inst_33858 = (state_33931[(7)]);
var inst_33865 = inst_33858.cljs$lang$protocol_mask$partition0$;
var inst_33866 = (inst_33865 & (64));
var inst_33867 = inst_33858.cljs$core$ISeq$;
var inst_33868 = (cljs.core.PROTOCOL_SENTINEL === inst_33867);
var inst_33869 = ((inst_33866) || (inst_33868));
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33869)){
var statearr_33951_34006 = state_33931__$1;
(statearr_33951_34006[(1)] = (16));

} else {
var statearr_33952_34007 = state_33931__$1;
(statearr_33952_34007[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (22))){
var inst_33890 = (state_33931[(14)]);
var inst_33891 = (state_33931[(11)]);
var inst_33889 = (state_33931[(2)]);
var inst_33890__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33889,(0),null);
var inst_33891__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33889,(1),null);
var inst_33892 = (inst_33890__$1 == null);
var inst_33893 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33891__$1,change);
var inst_33894 = ((inst_33892) || (inst_33893));
var state_33931__$1 = (function (){var statearr_33953 = state_33931;
(statearr_33953[(14)] = inst_33890__$1);

(statearr_33953[(11)] = inst_33891__$1);

return statearr_33953;
})();
if(cljs.core.truth_(inst_33894)){
var statearr_33954_34008 = state_33931__$1;
(statearr_33954_34008[(1)] = (23));

} else {
var statearr_33955_34009 = state_33931__$1;
(statearr_33955_34009[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (36))){
var inst_33881 = (state_33931[(12)]);
var inst_33858 = inst_33881;
var state_33931__$1 = (function (){var statearr_33956 = state_33931;
(statearr_33956[(7)] = inst_33858);

return statearr_33956;
})();
var statearr_33957_34010 = state_33931__$1;
(statearr_33957_34010[(2)] = null);

(statearr_33957_34010[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (29))){
var inst_33905 = (state_33931[(10)]);
var state_33931__$1 = state_33931;
var statearr_33958_34011 = state_33931__$1;
(statearr_33958_34011[(2)] = inst_33905);

(statearr_33958_34011[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (6))){
var state_33931__$1 = state_33931;
var statearr_33959_34012 = state_33931__$1;
(statearr_33959_34012[(2)] = false);

(statearr_33959_34012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (28))){
var inst_33901 = (state_33931[(2)]);
var inst_33902 = calc_state();
var inst_33858 = inst_33902;
var state_33931__$1 = (function (){var statearr_33960 = state_33931;
(statearr_33960[(15)] = inst_33901);

(statearr_33960[(7)] = inst_33858);

return statearr_33960;
})();
var statearr_33961_34013 = state_33931__$1;
(statearr_33961_34013[(2)] = null);

(statearr_33961_34013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (25))){
var inst_33927 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
var statearr_33962_34014 = state_33931__$1;
(statearr_33962_34014[(2)] = inst_33927);

(statearr_33962_34014[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (34))){
var inst_33925 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
var statearr_33963_34015 = state_33931__$1;
(statearr_33963_34015[(2)] = inst_33925);

(statearr_33963_34015[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (17))){
var state_33931__$1 = state_33931;
var statearr_33964_34016 = state_33931__$1;
(statearr_33964_34016[(2)] = false);

(statearr_33964_34016[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (3))){
var state_33931__$1 = state_33931;
var statearr_33965_34017 = state_33931__$1;
(statearr_33965_34017[(2)] = false);

(statearr_33965_34017[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (12))){
var inst_33929 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33931__$1,inst_33929);
} else {
if((state_val_33932 === (2))){
var inst_33833 = (state_33931[(8)]);
var inst_33838 = inst_33833.cljs$lang$protocol_mask$partition0$;
var inst_33839 = (inst_33838 & (64));
var inst_33840 = inst_33833.cljs$core$ISeq$;
var inst_33841 = (cljs.core.PROTOCOL_SENTINEL === inst_33840);
var inst_33842 = ((inst_33839) || (inst_33841));
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33842)){
var statearr_33966_34018 = state_33931__$1;
(statearr_33966_34018[(1)] = (5));

} else {
var statearr_33967_34019 = state_33931__$1;
(statearr_33967_34019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (23))){
var inst_33890 = (state_33931[(14)]);
var inst_33896 = (inst_33890 == null);
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33896)){
var statearr_33968_34020 = state_33931__$1;
(statearr_33968_34020[(1)] = (26));

} else {
var statearr_33969_34021 = state_33931__$1;
(statearr_33969_34021[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (35))){
var inst_33916 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
if(cljs.core.truth_(inst_33916)){
var statearr_33970_34022 = state_33931__$1;
(statearr_33970_34022[(1)] = (36));

} else {
var statearr_33971_34023 = state_33931__$1;
(statearr_33971_34023[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (19))){
var inst_33858 = (state_33931[(7)]);
var inst_33878 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33858);
var state_33931__$1 = state_33931;
var statearr_33972_34024 = state_33931__$1;
(statearr_33972_34024[(2)] = inst_33878);

(statearr_33972_34024[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (11))){
var inst_33858 = (state_33931[(7)]);
var inst_33862 = (inst_33858 == null);
var inst_33863 = cljs.core.not(inst_33862);
var state_33931__$1 = state_33931;
if(inst_33863){
var statearr_33973_34025 = state_33931__$1;
(statearr_33973_34025[(1)] = (13));

} else {
var statearr_33974_34026 = state_33931__$1;
(statearr_33974_34026[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (9))){
var inst_33833 = (state_33931[(8)]);
var state_33931__$1 = state_33931;
var statearr_33975_34027 = state_33931__$1;
(statearr_33975_34027[(2)] = inst_33833);

(statearr_33975_34027[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (5))){
var state_33931__$1 = state_33931;
var statearr_33976_34028 = state_33931__$1;
(statearr_33976_34028[(2)] = true);

(statearr_33976_34028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (14))){
var state_33931__$1 = state_33931;
var statearr_33977_34029 = state_33931__$1;
(statearr_33977_34029[(2)] = false);

(statearr_33977_34029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (26))){
var inst_33891 = (state_33931[(11)]);
var inst_33898 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_33891);
var state_33931__$1 = state_33931;
var statearr_33978_34030 = state_33931__$1;
(statearr_33978_34030[(2)] = inst_33898);

(statearr_33978_34030[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (16))){
var state_33931__$1 = state_33931;
var statearr_33979_34031 = state_33931__$1;
(statearr_33979_34031[(2)] = true);

(statearr_33979_34031[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (38))){
var inst_33921 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
var statearr_33980_34032 = state_33931__$1;
(statearr_33980_34032[(2)] = inst_33921);

(statearr_33980_34032[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (30))){
var inst_33883 = (state_33931[(13)]);
var inst_33882 = (state_33931[(9)]);
var inst_33891 = (state_33931[(11)]);
var inst_33908 = cljs.core.empty_QMARK_(inst_33882);
var inst_33909 = (inst_33883.cljs$core$IFn$_invoke$arity$1 ? inst_33883.cljs$core$IFn$_invoke$arity$1(inst_33891) : inst_33883.call(null,inst_33891));
var inst_33910 = cljs.core.not(inst_33909);
var inst_33911 = ((inst_33908) && (inst_33910));
var state_33931__$1 = state_33931;
var statearr_33981_34033 = state_33931__$1;
(statearr_33981_34033[(2)] = inst_33911);

(statearr_33981_34033[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (10))){
var inst_33833 = (state_33931[(8)]);
var inst_33854 = (state_33931[(2)]);
var inst_33855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33854,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_33856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33854,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_33857 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33854,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_33858 = inst_33833;
var state_33931__$1 = (function (){var statearr_33982 = state_33931;
(statearr_33982[(16)] = inst_33856);

(statearr_33982[(17)] = inst_33857);

(statearr_33982[(7)] = inst_33858);

(statearr_33982[(18)] = inst_33855);

return statearr_33982;
})();
var statearr_33983_34034 = state_33931__$1;
(statearr_33983_34034[(2)] = null);

(statearr_33983_34034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (18))){
var inst_33873 = (state_33931[(2)]);
var state_33931__$1 = state_33931;
var statearr_33984_34035 = state_33931__$1;
(statearr_33984_34035[(2)] = inst_33873);

(statearr_33984_34035[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (37))){
var state_33931__$1 = state_33931;
var statearr_33985_34036 = state_33931__$1;
(statearr_33985_34036[(2)] = null);

(statearr_33985_34036[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33932 === (8))){
var inst_33833 = (state_33931[(8)]);
var inst_33851 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33833);
var state_33931__$1 = state_33931;
var statearr_33986_34037 = state_33931__$1;
(statearr_33986_34037[(2)] = inst_33851);

(statearr_33986_34037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__32540__auto__,c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__32541__auto__ = null;
var cljs$core$async$mix_$_state_machine__32541__auto____0 = (function (){
var statearr_33987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33987[(0)] = cljs$core$async$mix_$_state_machine__32541__auto__);

(statearr_33987[(1)] = (1));

return statearr_33987;
});
var cljs$core$async$mix_$_state_machine__32541__auto____1 = (function (state_33931){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_33931);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e33988){if((e33988 instanceof Object)){
var ex__32544__auto__ = e33988;
var statearr_33989_34038 = state_33931;
(statearr_33989_34038[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33988;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34039 = state_33931;
state_33931 = G__34039;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__32541__auto__ = function(state_33931){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__32541__auto____1.call(this,state_33931);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__32541__auto____0;
cljs$core$async$mix_$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__32541__auto____1;
return cljs$core$async$mix_$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__32614__auto__ = (function (){var statearr_33990 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_33990[(6)] = c__32612__auto___33991);

return statearr_33990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___33991,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4212__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4212__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4212__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4212__auto__.call(null,p,v,ch));
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4212__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__34041 = arguments.length;
switch (G__34041) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4212__auto__.call(null,p));
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__4212__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return (m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4212__auto__.call(null,p,v));
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return (m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__4212__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__34045 = arguments.length;
switch (G__34045) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3922__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__3922__auto__,mults){
return (function (p1__34043_SHARP_){
if(cljs.core.truth_((p1__34043_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34043_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__34043_SHARP_.call(null,topic)))){
return p1__34043_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__34043_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__3922__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async34046 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34046 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta34047){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta34047 = meta34047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_34048,meta34047__$1){
var self__ = this;
var _34048__$1 = this;
return (new cljs.core.async.t_cljs$core$async34046(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta34047__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_34048){
var self__ = this;
var _34048__$1 = this;
return self__.meta34047;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta34047","meta34047",648671043,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34046.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34046.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34046";

cljs.core.async.t_cljs$core$async34046.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async34046");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34046.
 */
cljs.core.async.__GT_t_cljs$core$async34046 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async34046(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34047){
return (new cljs.core.async.t_cljs$core$async34046(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34047));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async34046(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__32612__auto___34166 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34166,mults,ensure_mult,p){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34166,mults,ensure_mult,p){
return (function (state_34120){
var state_val_34121 = (state_34120[(1)]);
if((state_val_34121 === (7))){
var inst_34116 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34122_34167 = state_34120__$1;
(statearr_34122_34167[(2)] = inst_34116);

(statearr_34122_34167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (20))){
var state_34120__$1 = state_34120;
var statearr_34123_34168 = state_34120__$1;
(statearr_34123_34168[(2)] = null);

(statearr_34123_34168[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (1))){
var state_34120__$1 = state_34120;
var statearr_34124_34169 = state_34120__$1;
(statearr_34124_34169[(2)] = null);

(statearr_34124_34169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (24))){
var inst_34099 = (state_34120[(7)]);
var inst_34108 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_34099);
var state_34120__$1 = state_34120;
var statearr_34125_34170 = state_34120__$1;
(statearr_34125_34170[(2)] = inst_34108);

(statearr_34125_34170[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (4))){
var inst_34051 = (state_34120[(8)]);
var inst_34051__$1 = (state_34120[(2)]);
var inst_34052 = (inst_34051__$1 == null);
var state_34120__$1 = (function (){var statearr_34126 = state_34120;
(statearr_34126[(8)] = inst_34051__$1);

return statearr_34126;
})();
if(cljs.core.truth_(inst_34052)){
var statearr_34127_34171 = state_34120__$1;
(statearr_34127_34171[(1)] = (5));

} else {
var statearr_34128_34172 = state_34120__$1;
(statearr_34128_34172[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (15))){
var inst_34093 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34129_34173 = state_34120__$1;
(statearr_34129_34173[(2)] = inst_34093);

(statearr_34129_34173[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (21))){
var inst_34113 = (state_34120[(2)]);
var state_34120__$1 = (function (){var statearr_34130 = state_34120;
(statearr_34130[(9)] = inst_34113);

return statearr_34130;
})();
var statearr_34131_34174 = state_34120__$1;
(statearr_34131_34174[(2)] = null);

(statearr_34131_34174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (13))){
var inst_34075 = (state_34120[(10)]);
var inst_34077 = cljs.core.chunked_seq_QMARK_(inst_34075);
var state_34120__$1 = state_34120;
if(inst_34077){
var statearr_34132_34175 = state_34120__$1;
(statearr_34132_34175[(1)] = (16));

} else {
var statearr_34133_34176 = state_34120__$1;
(statearr_34133_34176[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (22))){
var inst_34105 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
if(cljs.core.truth_(inst_34105)){
var statearr_34134_34177 = state_34120__$1;
(statearr_34134_34177[(1)] = (23));

} else {
var statearr_34135_34178 = state_34120__$1;
(statearr_34135_34178[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (6))){
var inst_34101 = (state_34120[(11)]);
var inst_34051 = (state_34120[(8)]);
var inst_34099 = (state_34120[(7)]);
var inst_34099__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_34051) : topic_fn.call(null,inst_34051));
var inst_34100 = cljs.core.deref(mults);
var inst_34101__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34100,inst_34099__$1);
var state_34120__$1 = (function (){var statearr_34136 = state_34120;
(statearr_34136[(11)] = inst_34101__$1);

(statearr_34136[(7)] = inst_34099__$1);

return statearr_34136;
})();
if(cljs.core.truth_(inst_34101__$1)){
var statearr_34137_34179 = state_34120__$1;
(statearr_34137_34179[(1)] = (19));

} else {
var statearr_34138_34180 = state_34120__$1;
(statearr_34138_34180[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (25))){
var inst_34110 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34139_34181 = state_34120__$1;
(statearr_34139_34181[(2)] = inst_34110);

(statearr_34139_34181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (17))){
var inst_34075 = (state_34120[(10)]);
var inst_34084 = cljs.core.first(inst_34075);
var inst_34085 = cljs.core.async.muxch_STAR_(inst_34084);
var inst_34086 = cljs.core.async.close_BANG_(inst_34085);
var inst_34087 = cljs.core.next(inst_34075);
var inst_34061 = inst_34087;
var inst_34062 = null;
var inst_34063 = (0);
var inst_34064 = (0);
var state_34120__$1 = (function (){var statearr_34140 = state_34120;
(statearr_34140[(12)] = inst_34064);

(statearr_34140[(13)] = inst_34063);

(statearr_34140[(14)] = inst_34061);

(statearr_34140[(15)] = inst_34086);

(statearr_34140[(16)] = inst_34062);

return statearr_34140;
})();
var statearr_34141_34182 = state_34120__$1;
(statearr_34141_34182[(2)] = null);

(statearr_34141_34182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (3))){
var inst_34118 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34120__$1,inst_34118);
} else {
if((state_val_34121 === (12))){
var inst_34095 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34142_34183 = state_34120__$1;
(statearr_34142_34183[(2)] = inst_34095);

(statearr_34142_34183[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (2))){
var state_34120__$1 = state_34120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34120__$1,(4),ch);
} else {
if((state_val_34121 === (23))){
var state_34120__$1 = state_34120;
var statearr_34143_34184 = state_34120__$1;
(statearr_34143_34184[(2)] = null);

(statearr_34143_34184[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (19))){
var inst_34101 = (state_34120[(11)]);
var inst_34051 = (state_34120[(8)]);
var inst_34103 = cljs.core.async.muxch_STAR_(inst_34101);
var state_34120__$1 = state_34120;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34120__$1,(22),inst_34103,inst_34051);
} else {
if((state_val_34121 === (11))){
var inst_34075 = (state_34120[(10)]);
var inst_34061 = (state_34120[(14)]);
var inst_34075__$1 = cljs.core.seq(inst_34061);
var state_34120__$1 = (function (){var statearr_34144 = state_34120;
(statearr_34144[(10)] = inst_34075__$1);

return statearr_34144;
})();
if(inst_34075__$1){
var statearr_34145_34185 = state_34120__$1;
(statearr_34145_34185[(1)] = (13));

} else {
var statearr_34146_34186 = state_34120__$1;
(statearr_34146_34186[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (9))){
var inst_34097 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34147_34187 = state_34120__$1;
(statearr_34147_34187[(2)] = inst_34097);

(statearr_34147_34187[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (5))){
var inst_34058 = cljs.core.deref(mults);
var inst_34059 = cljs.core.vals(inst_34058);
var inst_34060 = cljs.core.seq(inst_34059);
var inst_34061 = inst_34060;
var inst_34062 = null;
var inst_34063 = (0);
var inst_34064 = (0);
var state_34120__$1 = (function (){var statearr_34148 = state_34120;
(statearr_34148[(12)] = inst_34064);

(statearr_34148[(13)] = inst_34063);

(statearr_34148[(14)] = inst_34061);

(statearr_34148[(16)] = inst_34062);

return statearr_34148;
})();
var statearr_34149_34188 = state_34120__$1;
(statearr_34149_34188[(2)] = null);

(statearr_34149_34188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (14))){
var state_34120__$1 = state_34120;
var statearr_34153_34189 = state_34120__$1;
(statearr_34153_34189[(2)] = null);

(statearr_34153_34189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (16))){
var inst_34075 = (state_34120[(10)]);
var inst_34079 = cljs.core.chunk_first(inst_34075);
var inst_34080 = cljs.core.chunk_rest(inst_34075);
var inst_34081 = cljs.core.count(inst_34079);
var inst_34061 = inst_34080;
var inst_34062 = inst_34079;
var inst_34063 = inst_34081;
var inst_34064 = (0);
var state_34120__$1 = (function (){var statearr_34154 = state_34120;
(statearr_34154[(12)] = inst_34064);

(statearr_34154[(13)] = inst_34063);

(statearr_34154[(14)] = inst_34061);

(statearr_34154[(16)] = inst_34062);

return statearr_34154;
})();
var statearr_34155_34190 = state_34120__$1;
(statearr_34155_34190[(2)] = null);

(statearr_34155_34190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (10))){
var inst_34064 = (state_34120[(12)]);
var inst_34063 = (state_34120[(13)]);
var inst_34061 = (state_34120[(14)]);
var inst_34062 = (state_34120[(16)]);
var inst_34069 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34062,inst_34064);
var inst_34070 = cljs.core.async.muxch_STAR_(inst_34069);
var inst_34071 = cljs.core.async.close_BANG_(inst_34070);
var inst_34072 = (inst_34064 + (1));
var tmp34150 = inst_34063;
var tmp34151 = inst_34061;
var tmp34152 = inst_34062;
var inst_34061__$1 = tmp34151;
var inst_34062__$1 = tmp34152;
var inst_34063__$1 = tmp34150;
var inst_34064__$1 = inst_34072;
var state_34120__$1 = (function (){var statearr_34156 = state_34120;
(statearr_34156[(17)] = inst_34071);

(statearr_34156[(12)] = inst_34064__$1);

(statearr_34156[(13)] = inst_34063__$1);

(statearr_34156[(14)] = inst_34061__$1);

(statearr_34156[(16)] = inst_34062__$1);

return statearr_34156;
})();
var statearr_34157_34191 = state_34120__$1;
(statearr_34157_34191[(2)] = null);

(statearr_34157_34191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (18))){
var inst_34090 = (state_34120[(2)]);
var state_34120__$1 = state_34120;
var statearr_34158_34192 = state_34120__$1;
(statearr_34158_34192[(2)] = inst_34090);

(statearr_34158_34192[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34121 === (8))){
var inst_34064 = (state_34120[(12)]);
var inst_34063 = (state_34120[(13)]);
var inst_34066 = (inst_34064 < inst_34063);
var inst_34067 = inst_34066;
var state_34120__$1 = state_34120;
if(cljs.core.truth_(inst_34067)){
var statearr_34159_34193 = state_34120__$1;
(statearr_34159_34193[(1)] = (10));

} else {
var statearr_34160_34194 = state_34120__$1;
(statearr_34160_34194[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34166,mults,ensure_mult,p))
;
return ((function (switch__32540__auto__,c__32612__auto___34166,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34161 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34161[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34161[(1)] = (1));

return statearr_34161;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34120){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34120);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34162){if((e34162 instanceof Object)){
var ex__32544__auto__ = e34162;
var statearr_34163_34195 = state_34120;
(statearr_34163_34195[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34162;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34196 = state_34120;
state_34120 = G__34196;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34120){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34120);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34166,mults,ensure_mult,p))
})();
var state__32614__auto__ = (function (){var statearr_34164 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34164[(6)] = c__32612__auto___34166);

return statearr_34164;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34166,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__34198 = arguments.length;
switch (G__34198) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__34201 = arguments.length;
switch (G__34201) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__34204 = arguments.length;
switch (G__34204) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__32612__auto___34271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_34243){
var state_val_34244 = (state_34243[(1)]);
if((state_val_34244 === (7))){
var state_34243__$1 = state_34243;
var statearr_34245_34272 = state_34243__$1;
(statearr_34245_34272[(2)] = null);

(statearr_34245_34272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (1))){
var state_34243__$1 = state_34243;
var statearr_34246_34273 = state_34243__$1;
(statearr_34246_34273[(2)] = null);

(statearr_34246_34273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (4))){
var inst_34207 = (state_34243[(7)]);
var inst_34209 = (inst_34207 < cnt);
var state_34243__$1 = state_34243;
if(cljs.core.truth_(inst_34209)){
var statearr_34247_34274 = state_34243__$1;
(statearr_34247_34274[(1)] = (6));

} else {
var statearr_34248_34275 = state_34243__$1;
(statearr_34248_34275[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (15))){
var inst_34239 = (state_34243[(2)]);
var state_34243__$1 = state_34243;
var statearr_34249_34276 = state_34243__$1;
(statearr_34249_34276[(2)] = inst_34239);

(statearr_34249_34276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (13))){
var inst_34232 = cljs.core.async.close_BANG_(out);
var state_34243__$1 = state_34243;
var statearr_34250_34277 = state_34243__$1;
(statearr_34250_34277[(2)] = inst_34232);

(statearr_34250_34277[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (6))){
var state_34243__$1 = state_34243;
var statearr_34251_34278 = state_34243__$1;
(statearr_34251_34278[(2)] = null);

(statearr_34251_34278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (3))){
var inst_34241 = (state_34243[(2)]);
var state_34243__$1 = state_34243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34243__$1,inst_34241);
} else {
if((state_val_34244 === (12))){
var inst_34229 = (state_34243[(8)]);
var inst_34229__$1 = (state_34243[(2)]);
var inst_34230 = cljs.core.some(cljs.core.nil_QMARK_,inst_34229__$1);
var state_34243__$1 = (function (){var statearr_34252 = state_34243;
(statearr_34252[(8)] = inst_34229__$1);

return statearr_34252;
})();
if(cljs.core.truth_(inst_34230)){
var statearr_34253_34279 = state_34243__$1;
(statearr_34253_34279[(1)] = (13));

} else {
var statearr_34254_34280 = state_34243__$1;
(statearr_34254_34280[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (2))){
var inst_34206 = cljs.core.reset_BANG_(dctr,cnt);
var inst_34207 = (0);
var state_34243__$1 = (function (){var statearr_34255 = state_34243;
(statearr_34255[(7)] = inst_34207);

(statearr_34255[(9)] = inst_34206);

return statearr_34255;
})();
var statearr_34256_34281 = state_34243__$1;
(statearr_34256_34281[(2)] = null);

(statearr_34256_34281[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (11))){
var inst_34207 = (state_34243[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_34243,(10),Object,null,(9));
var inst_34216 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_34207) : chs__$1.call(null,inst_34207));
var inst_34217 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_34207) : done.call(null,inst_34207));
var inst_34218 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34216,inst_34217);
var state_34243__$1 = state_34243;
var statearr_34257_34282 = state_34243__$1;
(statearr_34257_34282[(2)] = inst_34218);


cljs.core.async.impl.ioc_helpers.process_exception(state_34243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (9))){
var inst_34207 = (state_34243[(7)]);
var inst_34220 = (state_34243[(2)]);
var inst_34221 = (inst_34207 + (1));
var inst_34207__$1 = inst_34221;
var state_34243__$1 = (function (){var statearr_34258 = state_34243;
(statearr_34258[(10)] = inst_34220);

(statearr_34258[(7)] = inst_34207__$1);

return statearr_34258;
})();
var statearr_34259_34283 = state_34243__$1;
(statearr_34259_34283[(2)] = null);

(statearr_34259_34283[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (5))){
var inst_34227 = (state_34243[(2)]);
var state_34243__$1 = (function (){var statearr_34260 = state_34243;
(statearr_34260[(11)] = inst_34227);

return statearr_34260;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34243__$1,(12),dchan);
} else {
if((state_val_34244 === (14))){
var inst_34229 = (state_34243[(8)]);
var inst_34234 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_34229);
var state_34243__$1 = state_34243;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34243__$1,(16),out,inst_34234);
} else {
if((state_val_34244 === (16))){
var inst_34236 = (state_34243[(2)]);
var state_34243__$1 = (function (){var statearr_34261 = state_34243;
(statearr_34261[(12)] = inst_34236);

return statearr_34261;
})();
var statearr_34262_34284 = state_34243__$1;
(statearr_34262_34284[(2)] = null);

(statearr_34262_34284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (10))){
var inst_34211 = (state_34243[(2)]);
var inst_34212 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_34243__$1 = (function (){var statearr_34263 = state_34243;
(statearr_34263[(13)] = inst_34211);

return statearr_34263;
})();
var statearr_34264_34285 = state_34243__$1;
(statearr_34264_34285[(2)] = inst_34212);


cljs.core.async.impl.ioc_helpers.process_exception(state_34243__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (8))){
var inst_34225 = (state_34243[(2)]);
var state_34243__$1 = state_34243;
var statearr_34265_34286 = state_34243__$1;
(statearr_34265_34286[(2)] = inst_34225);

(statearr_34265_34286[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__32540__auto__,c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34266[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34266[(1)] = (1));

return statearr_34266;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34243){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34243);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34267){if((e34267 instanceof Object)){
var ex__32544__auto__ = e34267;
var statearr_34268_34287 = state_34243;
(statearr_34268_34287[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34267;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34288 = state_34243;
state_34243 = G__34288;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34243){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34243);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__32614__auto__ = (function (){var statearr_34269 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34269[(6)] = c__32612__auto___34271);

return statearr_34269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34271,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__34291 = arguments.length;
switch (G__34291) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34345 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34345,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34345,out){
return (function (state_34323){
var state_val_34324 = (state_34323[(1)]);
if((state_val_34324 === (7))){
var inst_34302 = (state_34323[(7)]);
var inst_34303 = (state_34323[(8)]);
var inst_34302__$1 = (state_34323[(2)]);
var inst_34303__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34302__$1,(0),null);
var inst_34304 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34302__$1,(1),null);
var inst_34305 = (inst_34303__$1 == null);
var state_34323__$1 = (function (){var statearr_34325 = state_34323;
(statearr_34325[(7)] = inst_34302__$1);

(statearr_34325[(8)] = inst_34303__$1);

(statearr_34325[(9)] = inst_34304);

return statearr_34325;
})();
if(cljs.core.truth_(inst_34305)){
var statearr_34326_34346 = state_34323__$1;
(statearr_34326_34346[(1)] = (8));

} else {
var statearr_34327_34347 = state_34323__$1;
(statearr_34327_34347[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (1))){
var inst_34292 = cljs.core.vec(chs);
var inst_34293 = inst_34292;
var state_34323__$1 = (function (){var statearr_34328 = state_34323;
(statearr_34328[(10)] = inst_34293);

return statearr_34328;
})();
var statearr_34329_34348 = state_34323__$1;
(statearr_34329_34348[(2)] = null);

(statearr_34329_34348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (4))){
var inst_34293 = (state_34323[(10)]);
var state_34323__$1 = state_34323;
return cljs.core.async.ioc_alts_BANG_(state_34323__$1,(7),inst_34293);
} else {
if((state_val_34324 === (6))){
var inst_34319 = (state_34323[(2)]);
var state_34323__$1 = state_34323;
var statearr_34330_34349 = state_34323__$1;
(statearr_34330_34349[(2)] = inst_34319);

(statearr_34330_34349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (3))){
var inst_34321 = (state_34323[(2)]);
var state_34323__$1 = state_34323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34323__$1,inst_34321);
} else {
if((state_val_34324 === (2))){
var inst_34293 = (state_34323[(10)]);
var inst_34295 = cljs.core.count(inst_34293);
var inst_34296 = (inst_34295 > (0));
var state_34323__$1 = state_34323;
if(cljs.core.truth_(inst_34296)){
var statearr_34332_34350 = state_34323__$1;
(statearr_34332_34350[(1)] = (4));

} else {
var statearr_34333_34351 = state_34323__$1;
(statearr_34333_34351[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (11))){
var inst_34293 = (state_34323[(10)]);
var inst_34312 = (state_34323[(2)]);
var tmp34331 = inst_34293;
var inst_34293__$1 = tmp34331;
var state_34323__$1 = (function (){var statearr_34334 = state_34323;
(statearr_34334[(10)] = inst_34293__$1);

(statearr_34334[(11)] = inst_34312);

return statearr_34334;
})();
var statearr_34335_34352 = state_34323__$1;
(statearr_34335_34352[(2)] = null);

(statearr_34335_34352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (9))){
var inst_34303 = (state_34323[(8)]);
var state_34323__$1 = state_34323;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34323__$1,(11),out,inst_34303);
} else {
if((state_val_34324 === (5))){
var inst_34317 = cljs.core.async.close_BANG_(out);
var state_34323__$1 = state_34323;
var statearr_34336_34353 = state_34323__$1;
(statearr_34336_34353[(2)] = inst_34317);

(statearr_34336_34353[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (10))){
var inst_34315 = (state_34323[(2)]);
var state_34323__$1 = state_34323;
var statearr_34337_34354 = state_34323__$1;
(statearr_34337_34354[(2)] = inst_34315);

(statearr_34337_34354[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34324 === (8))){
var inst_34293 = (state_34323[(10)]);
var inst_34302 = (state_34323[(7)]);
var inst_34303 = (state_34323[(8)]);
var inst_34304 = (state_34323[(9)]);
var inst_34307 = (function (){var cs = inst_34293;
var vec__34298 = inst_34302;
var v = inst_34303;
var c = inst_34304;
return ((function (cs,vec__34298,v,c,inst_34293,inst_34302,inst_34303,inst_34304,state_val_34324,c__32612__auto___34345,out){
return (function (p1__34289_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__34289_SHARP_);
});
;})(cs,vec__34298,v,c,inst_34293,inst_34302,inst_34303,inst_34304,state_val_34324,c__32612__auto___34345,out))
})();
var inst_34308 = cljs.core.filterv(inst_34307,inst_34293);
var inst_34293__$1 = inst_34308;
var state_34323__$1 = (function (){var statearr_34338 = state_34323;
(statearr_34338[(10)] = inst_34293__$1);

return statearr_34338;
})();
var statearr_34339_34355 = state_34323__$1;
(statearr_34339_34355[(2)] = null);

(statearr_34339_34355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34345,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34345,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34340 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34340[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34340[(1)] = (1));

return statearr_34340;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34323){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34323);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34341){if((e34341 instanceof Object)){
var ex__32544__auto__ = e34341;
var statearr_34342_34356 = state_34323;
(statearr_34342_34356[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34341;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34357 = state_34323;
state_34323 = G__34357;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34323){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34323);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34345,out))
})();
var state__32614__auto__ = (function (){var statearr_34343 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34343[(6)] = c__32612__auto___34345);

return statearr_34343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34345,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__34359 = arguments.length;
switch (G__34359) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34404 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34404,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34404,out){
return (function (state_34383){
var state_val_34384 = (state_34383[(1)]);
if((state_val_34384 === (7))){
var inst_34365 = (state_34383[(7)]);
var inst_34365__$1 = (state_34383[(2)]);
var inst_34366 = (inst_34365__$1 == null);
var inst_34367 = cljs.core.not(inst_34366);
var state_34383__$1 = (function (){var statearr_34385 = state_34383;
(statearr_34385[(7)] = inst_34365__$1);

return statearr_34385;
})();
if(inst_34367){
var statearr_34386_34405 = state_34383__$1;
(statearr_34386_34405[(1)] = (8));

} else {
var statearr_34387_34406 = state_34383__$1;
(statearr_34387_34406[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (1))){
var inst_34360 = (0);
var state_34383__$1 = (function (){var statearr_34388 = state_34383;
(statearr_34388[(8)] = inst_34360);

return statearr_34388;
})();
var statearr_34389_34407 = state_34383__$1;
(statearr_34389_34407[(2)] = null);

(statearr_34389_34407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (4))){
var state_34383__$1 = state_34383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34383__$1,(7),ch);
} else {
if((state_val_34384 === (6))){
var inst_34378 = (state_34383[(2)]);
var state_34383__$1 = state_34383;
var statearr_34390_34408 = state_34383__$1;
(statearr_34390_34408[(2)] = inst_34378);

(statearr_34390_34408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (3))){
var inst_34380 = (state_34383[(2)]);
var inst_34381 = cljs.core.async.close_BANG_(out);
var state_34383__$1 = (function (){var statearr_34391 = state_34383;
(statearr_34391[(9)] = inst_34380);

return statearr_34391;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34383__$1,inst_34381);
} else {
if((state_val_34384 === (2))){
var inst_34360 = (state_34383[(8)]);
var inst_34362 = (inst_34360 < n);
var state_34383__$1 = state_34383;
if(cljs.core.truth_(inst_34362)){
var statearr_34392_34409 = state_34383__$1;
(statearr_34392_34409[(1)] = (4));

} else {
var statearr_34393_34410 = state_34383__$1;
(statearr_34393_34410[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (11))){
var inst_34360 = (state_34383[(8)]);
var inst_34370 = (state_34383[(2)]);
var inst_34371 = (inst_34360 + (1));
var inst_34360__$1 = inst_34371;
var state_34383__$1 = (function (){var statearr_34394 = state_34383;
(statearr_34394[(8)] = inst_34360__$1);

(statearr_34394[(10)] = inst_34370);

return statearr_34394;
})();
var statearr_34395_34411 = state_34383__$1;
(statearr_34395_34411[(2)] = null);

(statearr_34395_34411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (9))){
var state_34383__$1 = state_34383;
var statearr_34396_34412 = state_34383__$1;
(statearr_34396_34412[(2)] = null);

(statearr_34396_34412[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (5))){
var state_34383__$1 = state_34383;
var statearr_34397_34413 = state_34383__$1;
(statearr_34397_34413[(2)] = null);

(statearr_34397_34413[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (10))){
var inst_34375 = (state_34383[(2)]);
var state_34383__$1 = state_34383;
var statearr_34398_34414 = state_34383__$1;
(statearr_34398_34414[(2)] = inst_34375);

(statearr_34398_34414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34384 === (8))){
var inst_34365 = (state_34383[(7)]);
var state_34383__$1 = state_34383;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34383__$1,(11),out,inst_34365);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34404,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34404,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34399 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34399[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34399[(1)] = (1));

return statearr_34399;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34383){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34383);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34400){if((e34400 instanceof Object)){
var ex__32544__auto__ = e34400;
var statearr_34401_34415 = state_34383;
(statearr_34401_34415[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34383);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34400;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34416 = state_34383;
state_34383 = G__34416;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34383){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34383);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34404,out))
})();
var state__32614__auto__ = (function (){var statearr_34402 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34402[(6)] = c__32612__auto___34404);

return statearr_34402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34404,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34418 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34418 = (function (f,ch,meta34419){
this.f = f;
this.ch = ch;
this.meta34419 = meta34419;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34420,meta34419__$1){
var self__ = this;
var _34420__$1 = this;
return (new cljs.core.async.t_cljs$core$async34418(self__.f,self__.ch,meta34419__$1));
});

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34420){
var self__ = this;
var _34420__$1 = this;
return self__.meta34419;
});

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async34421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34421 = (function (f,ch,meta34419,_,fn1,meta34422){
this.f = f;
this.ch = ch;
this.meta34419 = meta34419;
this._ = _;
this.fn1 = fn1;
this.meta34422 = meta34422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_34423,meta34422__$1){
var self__ = this;
var _34423__$1 = this;
return (new cljs.core.async.t_cljs$core$async34421(self__.f,self__.ch,self__.meta34419,self__._,self__.fn1,meta34422__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_34423){
var self__ = this;
var _34423__$1 = this;
return self__.meta34422;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__34417_SHARP_){
var G__34424 = (((p1__34417_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__34417_SHARP_) : self__.f.call(null,p1__34417_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__34424) : f1.call(null,G__34424));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34419","meta34419",-1489990260,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async34418","cljs.core.async/t_cljs$core$async34418",2141059443,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta34422","meta34422",-122740021,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34421";

cljs.core.async.t_cljs$core$async34421.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async34421");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34421.
 */
cljs.core.async.__GT_t_cljs$core$async34421 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34421(f__$1,ch__$1,meta34419__$1,___$2,fn1__$1,meta34422){
return (new cljs.core.async.t_cljs$core$async34421(f__$1,ch__$1,meta34419__$1,___$2,fn1__$1,meta34422));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async34421(self__.f,self__.ch,self__.meta34419,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3911__auto__ = ret;
if(cljs.core.truth_(and__3911__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__3911__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__34425 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__34425) : self__.f.call(null,G__34425));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34418.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async34418.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34419","meta34419",-1489990260,null)], null);
});

cljs.core.async.t_cljs$core$async34418.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34418.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34418";

cljs.core.async.t_cljs$core$async34418.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async34418");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34418.
 */
cljs.core.async.__GT_t_cljs$core$async34418 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34418(f__$1,ch__$1,meta34419){
return (new cljs.core.async.t_cljs$core$async34418(f__$1,ch__$1,meta34419));
});

}

return (new cljs.core.async.t_cljs$core$async34418(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34426 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34426 = (function (f,ch,meta34427){
this.f = f;
this.ch = ch;
this.meta34427 = meta34427;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34428,meta34427__$1){
var self__ = this;
var _34428__$1 = this;
return (new cljs.core.async.t_cljs$core$async34426(self__.f,self__.ch,meta34427__$1));
});

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34428){
var self__ = this;
var _34428__$1 = this;
return self__.meta34427;
});

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34426.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async34426.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34427","meta34427",-1812758665,null)], null);
});

cljs.core.async.t_cljs$core$async34426.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34426.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34426";

cljs.core.async.t_cljs$core$async34426.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async34426");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34426.
 */
cljs.core.async.__GT_t_cljs$core$async34426 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async34426(f__$1,ch__$1,meta34427){
return (new cljs.core.async.t_cljs$core$async34426(f__$1,ch__$1,meta34427));
});

}

return (new cljs.core.async.t_cljs$core$async34426(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async34429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34429 = (function (p,ch,meta34430){
this.p = p;
this.ch = ch;
this.meta34430 = meta34430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34431,meta34430__$1){
var self__ = this;
var _34431__$1 = this;
return (new cljs.core.async.t_cljs$core$async34429(self__.p,self__.ch,meta34430__$1));
});

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34431){
var self__ = this;
var _34431__$1 = this;
return self__.meta34430;
});

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34429.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async34429.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta34430","meta34430",721131375,null)], null);
});

cljs.core.async.t_cljs$core$async34429.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34429.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34429";

cljs.core.async.t_cljs$core$async34429.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write(writer__4162__auto__,"cljs.core.async/t_cljs$core$async34429");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async34429.
 */
cljs.core.async.__GT_t_cljs$core$async34429 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async34429(p__$1,ch__$1,meta34430){
return (new cljs.core.async.t_cljs$core$async34429(p__$1,ch__$1,meta34430));
});

}

return (new cljs.core.async.t_cljs$core$async34429(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__34433 = arguments.length;
switch (G__34433) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34473 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34473,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34473,out){
return (function (state_34454){
var state_val_34455 = (state_34454[(1)]);
if((state_val_34455 === (7))){
var inst_34450 = (state_34454[(2)]);
var state_34454__$1 = state_34454;
var statearr_34456_34474 = state_34454__$1;
(statearr_34456_34474[(2)] = inst_34450);

(statearr_34456_34474[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (1))){
var state_34454__$1 = state_34454;
var statearr_34457_34475 = state_34454__$1;
(statearr_34457_34475[(2)] = null);

(statearr_34457_34475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (4))){
var inst_34436 = (state_34454[(7)]);
var inst_34436__$1 = (state_34454[(2)]);
var inst_34437 = (inst_34436__$1 == null);
var state_34454__$1 = (function (){var statearr_34458 = state_34454;
(statearr_34458[(7)] = inst_34436__$1);

return statearr_34458;
})();
if(cljs.core.truth_(inst_34437)){
var statearr_34459_34476 = state_34454__$1;
(statearr_34459_34476[(1)] = (5));

} else {
var statearr_34460_34477 = state_34454__$1;
(statearr_34460_34477[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (6))){
var inst_34436 = (state_34454[(7)]);
var inst_34441 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_34436) : p.call(null,inst_34436));
var state_34454__$1 = state_34454;
if(cljs.core.truth_(inst_34441)){
var statearr_34461_34478 = state_34454__$1;
(statearr_34461_34478[(1)] = (8));

} else {
var statearr_34462_34479 = state_34454__$1;
(statearr_34462_34479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (3))){
var inst_34452 = (state_34454[(2)]);
var state_34454__$1 = state_34454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34454__$1,inst_34452);
} else {
if((state_val_34455 === (2))){
var state_34454__$1 = state_34454;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34454__$1,(4),ch);
} else {
if((state_val_34455 === (11))){
var inst_34444 = (state_34454[(2)]);
var state_34454__$1 = state_34454;
var statearr_34463_34480 = state_34454__$1;
(statearr_34463_34480[(2)] = inst_34444);

(statearr_34463_34480[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (9))){
var state_34454__$1 = state_34454;
var statearr_34464_34481 = state_34454__$1;
(statearr_34464_34481[(2)] = null);

(statearr_34464_34481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (5))){
var inst_34439 = cljs.core.async.close_BANG_(out);
var state_34454__$1 = state_34454;
var statearr_34465_34482 = state_34454__$1;
(statearr_34465_34482[(2)] = inst_34439);

(statearr_34465_34482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (10))){
var inst_34447 = (state_34454[(2)]);
var state_34454__$1 = (function (){var statearr_34466 = state_34454;
(statearr_34466[(8)] = inst_34447);

return statearr_34466;
})();
var statearr_34467_34483 = state_34454__$1;
(statearr_34467_34483[(2)] = null);

(statearr_34467_34483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34455 === (8))){
var inst_34436 = (state_34454[(7)]);
var state_34454__$1 = state_34454;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34454__$1,(11),out,inst_34436);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34473,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34473,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34468 = [null,null,null,null,null,null,null,null,null];
(statearr_34468[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34468[(1)] = (1));

return statearr_34468;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34454){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34454);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34469){if((e34469 instanceof Object)){
var ex__32544__auto__ = e34469;
var statearr_34470_34484 = state_34454;
(statearr_34470_34484[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34454);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34469;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34485 = state_34454;
state_34454 = G__34485;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34454){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34454);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34473,out))
})();
var state__32614__auto__ = (function (){var statearr_34471 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34471[(6)] = c__32612__auto___34473);

return statearr_34471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34473,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__34487 = arguments.length;
switch (G__34487) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__32612__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto__){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto__){
return (function (state_34550){
var state_val_34551 = (state_34550[(1)]);
if((state_val_34551 === (7))){
var inst_34546 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
var statearr_34552_34590 = state_34550__$1;
(statearr_34552_34590[(2)] = inst_34546);

(statearr_34552_34590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (20))){
var inst_34516 = (state_34550[(7)]);
var inst_34527 = (state_34550[(2)]);
var inst_34528 = cljs.core.next(inst_34516);
var inst_34502 = inst_34528;
var inst_34503 = null;
var inst_34504 = (0);
var inst_34505 = (0);
var state_34550__$1 = (function (){var statearr_34553 = state_34550;
(statearr_34553[(8)] = inst_34503);

(statearr_34553[(9)] = inst_34505);

(statearr_34553[(10)] = inst_34527);

(statearr_34553[(11)] = inst_34504);

(statearr_34553[(12)] = inst_34502);

return statearr_34553;
})();
var statearr_34554_34591 = state_34550__$1;
(statearr_34554_34591[(2)] = null);

(statearr_34554_34591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (1))){
var state_34550__$1 = state_34550;
var statearr_34555_34592 = state_34550__$1;
(statearr_34555_34592[(2)] = null);

(statearr_34555_34592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (4))){
var inst_34491 = (state_34550[(13)]);
var inst_34491__$1 = (state_34550[(2)]);
var inst_34492 = (inst_34491__$1 == null);
var state_34550__$1 = (function (){var statearr_34556 = state_34550;
(statearr_34556[(13)] = inst_34491__$1);

return statearr_34556;
})();
if(cljs.core.truth_(inst_34492)){
var statearr_34557_34593 = state_34550__$1;
(statearr_34557_34593[(1)] = (5));

} else {
var statearr_34558_34594 = state_34550__$1;
(statearr_34558_34594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (15))){
var state_34550__$1 = state_34550;
var statearr_34562_34595 = state_34550__$1;
(statearr_34562_34595[(2)] = null);

(statearr_34562_34595[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (21))){
var state_34550__$1 = state_34550;
var statearr_34563_34596 = state_34550__$1;
(statearr_34563_34596[(2)] = null);

(statearr_34563_34596[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (13))){
var inst_34503 = (state_34550[(8)]);
var inst_34505 = (state_34550[(9)]);
var inst_34504 = (state_34550[(11)]);
var inst_34502 = (state_34550[(12)]);
var inst_34512 = (state_34550[(2)]);
var inst_34513 = (inst_34505 + (1));
var tmp34559 = inst_34503;
var tmp34560 = inst_34504;
var tmp34561 = inst_34502;
var inst_34502__$1 = tmp34561;
var inst_34503__$1 = tmp34559;
var inst_34504__$1 = tmp34560;
var inst_34505__$1 = inst_34513;
var state_34550__$1 = (function (){var statearr_34564 = state_34550;
(statearr_34564[(8)] = inst_34503__$1);

(statearr_34564[(9)] = inst_34505__$1);

(statearr_34564[(11)] = inst_34504__$1);

(statearr_34564[(12)] = inst_34502__$1);

(statearr_34564[(14)] = inst_34512);

return statearr_34564;
})();
var statearr_34565_34597 = state_34550__$1;
(statearr_34565_34597[(2)] = null);

(statearr_34565_34597[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (22))){
var state_34550__$1 = state_34550;
var statearr_34566_34598 = state_34550__$1;
(statearr_34566_34598[(2)] = null);

(statearr_34566_34598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (6))){
var inst_34491 = (state_34550[(13)]);
var inst_34500 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34491) : f.call(null,inst_34491));
var inst_34501 = cljs.core.seq(inst_34500);
var inst_34502 = inst_34501;
var inst_34503 = null;
var inst_34504 = (0);
var inst_34505 = (0);
var state_34550__$1 = (function (){var statearr_34567 = state_34550;
(statearr_34567[(8)] = inst_34503);

(statearr_34567[(9)] = inst_34505);

(statearr_34567[(11)] = inst_34504);

(statearr_34567[(12)] = inst_34502);

return statearr_34567;
})();
var statearr_34568_34599 = state_34550__$1;
(statearr_34568_34599[(2)] = null);

(statearr_34568_34599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (17))){
var inst_34516 = (state_34550[(7)]);
var inst_34520 = cljs.core.chunk_first(inst_34516);
var inst_34521 = cljs.core.chunk_rest(inst_34516);
var inst_34522 = cljs.core.count(inst_34520);
var inst_34502 = inst_34521;
var inst_34503 = inst_34520;
var inst_34504 = inst_34522;
var inst_34505 = (0);
var state_34550__$1 = (function (){var statearr_34569 = state_34550;
(statearr_34569[(8)] = inst_34503);

(statearr_34569[(9)] = inst_34505);

(statearr_34569[(11)] = inst_34504);

(statearr_34569[(12)] = inst_34502);

return statearr_34569;
})();
var statearr_34570_34600 = state_34550__$1;
(statearr_34570_34600[(2)] = null);

(statearr_34570_34600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (3))){
var inst_34548 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34550__$1,inst_34548);
} else {
if((state_val_34551 === (12))){
var inst_34536 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
var statearr_34571_34601 = state_34550__$1;
(statearr_34571_34601[(2)] = inst_34536);

(statearr_34571_34601[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (2))){
var state_34550__$1 = state_34550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34550__$1,(4),in$);
} else {
if((state_val_34551 === (23))){
var inst_34544 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
var statearr_34572_34602 = state_34550__$1;
(statearr_34572_34602[(2)] = inst_34544);

(statearr_34572_34602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (19))){
var inst_34531 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
var statearr_34573_34603 = state_34550__$1;
(statearr_34573_34603[(2)] = inst_34531);

(statearr_34573_34603[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (11))){
var inst_34516 = (state_34550[(7)]);
var inst_34502 = (state_34550[(12)]);
var inst_34516__$1 = cljs.core.seq(inst_34502);
var state_34550__$1 = (function (){var statearr_34574 = state_34550;
(statearr_34574[(7)] = inst_34516__$1);

return statearr_34574;
})();
if(inst_34516__$1){
var statearr_34575_34604 = state_34550__$1;
(statearr_34575_34604[(1)] = (14));

} else {
var statearr_34576_34605 = state_34550__$1;
(statearr_34576_34605[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (9))){
var inst_34538 = (state_34550[(2)]);
var inst_34539 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34550__$1 = (function (){var statearr_34577 = state_34550;
(statearr_34577[(15)] = inst_34538);

return statearr_34577;
})();
if(cljs.core.truth_(inst_34539)){
var statearr_34578_34606 = state_34550__$1;
(statearr_34578_34606[(1)] = (21));

} else {
var statearr_34579_34607 = state_34550__$1;
(statearr_34579_34607[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (5))){
var inst_34494 = cljs.core.async.close_BANG_(out);
var state_34550__$1 = state_34550;
var statearr_34580_34608 = state_34550__$1;
(statearr_34580_34608[(2)] = inst_34494);

(statearr_34580_34608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (14))){
var inst_34516 = (state_34550[(7)]);
var inst_34518 = cljs.core.chunked_seq_QMARK_(inst_34516);
var state_34550__$1 = state_34550;
if(inst_34518){
var statearr_34581_34609 = state_34550__$1;
(statearr_34581_34609[(1)] = (17));

} else {
var statearr_34582_34610 = state_34550__$1;
(statearr_34582_34610[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (16))){
var inst_34534 = (state_34550[(2)]);
var state_34550__$1 = state_34550;
var statearr_34583_34611 = state_34550__$1;
(statearr_34583_34611[(2)] = inst_34534);

(statearr_34583_34611[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34551 === (10))){
var inst_34503 = (state_34550[(8)]);
var inst_34505 = (state_34550[(9)]);
var inst_34510 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34503,inst_34505);
var state_34550__$1 = state_34550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34550__$1,(13),out,inst_34510);
} else {
if((state_val_34551 === (18))){
var inst_34516 = (state_34550[(7)]);
var inst_34525 = cljs.core.first(inst_34516);
var state_34550__$1 = state_34550;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34550__$1,(20),out,inst_34525);
} else {
if((state_val_34551 === (8))){
var inst_34505 = (state_34550[(9)]);
var inst_34504 = (state_34550[(11)]);
var inst_34507 = (inst_34505 < inst_34504);
var inst_34508 = inst_34507;
var state_34550__$1 = state_34550;
if(cljs.core.truth_(inst_34508)){
var statearr_34584_34612 = state_34550__$1;
(statearr_34584_34612[(1)] = (10));

} else {
var statearr_34585_34613 = state_34550__$1;
(statearr_34585_34613[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto__))
;
return ((function (switch__32540__auto__,c__32612__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____0 = (function (){
var statearr_34586 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34586[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__);

(statearr_34586[(1)] = (1));

return statearr_34586;
});
var cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____1 = (function (state_34550){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34550);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34587){if((e34587 instanceof Object)){
var ex__32544__auto__ = e34587;
var statearr_34588_34614 = state_34550;
(statearr_34588_34614[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34550);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34615 = state_34550;
state_34550 = G__34615;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__ = function(state_34550){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____1.call(this,state_34550);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__32541__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto__))
})();
var state__32614__auto__ = (function (){var statearr_34589 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34589[(6)] = c__32612__auto__);

return statearr_34589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto__))
);

return c__32612__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__34617 = arguments.length;
switch (G__34617) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__34620 = arguments.length;
switch (G__34620) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__34623 = arguments.length;
switch (G__34623) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34670 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34670,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34670,out){
return (function (state_34647){
var state_val_34648 = (state_34647[(1)]);
if((state_val_34648 === (7))){
var inst_34642 = (state_34647[(2)]);
var state_34647__$1 = state_34647;
var statearr_34649_34671 = state_34647__$1;
(statearr_34649_34671[(2)] = inst_34642);

(statearr_34649_34671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (1))){
var inst_34624 = null;
var state_34647__$1 = (function (){var statearr_34650 = state_34647;
(statearr_34650[(7)] = inst_34624);

return statearr_34650;
})();
var statearr_34651_34672 = state_34647__$1;
(statearr_34651_34672[(2)] = null);

(statearr_34651_34672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (4))){
var inst_34627 = (state_34647[(8)]);
var inst_34627__$1 = (state_34647[(2)]);
var inst_34628 = (inst_34627__$1 == null);
var inst_34629 = cljs.core.not(inst_34628);
var state_34647__$1 = (function (){var statearr_34652 = state_34647;
(statearr_34652[(8)] = inst_34627__$1);

return statearr_34652;
})();
if(inst_34629){
var statearr_34653_34673 = state_34647__$1;
(statearr_34653_34673[(1)] = (5));

} else {
var statearr_34654_34674 = state_34647__$1;
(statearr_34654_34674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (6))){
var state_34647__$1 = state_34647;
var statearr_34655_34675 = state_34647__$1;
(statearr_34655_34675[(2)] = null);

(statearr_34655_34675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (3))){
var inst_34644 = (state_34647[(2)]);
var inst_34645 = cljs.core.async.close_BANG_(out);
var state_34647__$1 = (function (){var statearr_34656 = state_34647;
(statearr_34656[(9)] = inst_34644);

return statearr_34656;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34647__$1,inst_34645);
} else {
if((state_val_34648 === (2))){
var state_34647__$1 = state_34647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34647__$1,(4),ch);
} else {
if((state_val_34648 === (11))){
var inst_34627 = (state_34647[(8)]);
var inst_34636 = (state_34647[(2)]);
var inst_34624 = inst_34627;
var state_34647__$1 = (function (){var statearr_34657 = state_34647;
(statearr_34657[(7)] = inst_34624);

(statearr_34657[(10)] = inst_34636);

return statearr_34657;
})();
var statearr_34658_34676 = state_34647__$1;
(statearr_34658_34676[(2)] = null);

(statearr_34658_34676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (9))){
var inst_34627 = (state_34647[(8)]);
var state_34647__$1 = state_34647;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34647__$1,(11),out,inst_34627);
} else {
if((state_val_34648 === (5))){
var inst_34624 = (state_34647[(7)]);
var inst_34627 = (state_34647[(8)]);
var inst_34631 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34627,inst_34624);
var state_34647__$1 = state_34647;
if(inst_34631){
var statearr_34660_34677 = state_34647__$1;
(statearr_34660_34677[(1)] = (8));

} else {
var statearr_34661_34678 = state_34647__$1;
(statearr_34661_34678[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (10))){
var inst_34639 = (state_34647[(2)]);
var state_34647__$1 = state_34647;
var statearr_34662_34679 = state_34647__$1;
(statearr_34662_34679[(2)] = inst_34639);

(statearr_34662_34679[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34648 === (8))){
var inst_34624 = (state_34647[(7)]);
var tmp34659 = inst_34624;
var inst_34624__$1 = tmp34659;
var state_34647__$1 = (function (){var statearr_34663 = state_34647;
(statearr_34663[(7)] = inst_34624__$1);

return statearr_34663;
})();
var statearr_34664_34680 = state_34647__$1;
(statearr_34664_34680[(2)] = null);

(statearr_34664_34680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34670,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34670,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34665 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34665[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34665[(1)] = (1));

return statearr_34665;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34647){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34647);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34666){if((e34666 instanceof Object)){
var ex__32544__auto__ = e34666;
var statearr_34667_34681 = state_34647;
(statearr_34667_34681[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34647);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34666;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34682 = state_34647;
state_34647 = G__34682;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34647){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34647);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34670,out))
})();
var state__32614__auto__ = (function (){var statearr_34668 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34668[(6)] = c__32612__auto___34670);

return statearr_34668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34670,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__34684 = arguments.length;
switch (G__34684) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34750 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34750,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34750,out){
return (function (state_34722){
var state_val_34723 = (state_34722[(1)]);
if((state_val_34723 === (7))){
var inst_34718 = (state_34722[(2)]);
var state_34722__$1 = state_34722;
var statearr_34724_34751 = state_34722__$1;
(statearr_34724_34751[(2)] = inst_34718);

(statearr_34724_34751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (1))){
var inst_34685 = (new Array(n));
var inst_34686 = inst_34685;
var inst_34687 = (0);
var state_34722__$1 = (function (){var statearr_34725 = state_34722;
(statearr_34725[(7)] = inst_34687);

(statearr_34725[(8)] = inst_34686);

return statearr_34725;
})();
var statearr_34726_34752 = state_34722__$1;
(statearr_34726_34752[(2)] = null);

(statearr_34726_34752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (4))){
var inst_34690 = (state_34722[(9)]);
var inst_34690__$1 = (state_34722[(2)]);
var inst_34691 = (inst_34690__$1 == null);
var inst_34692 = cljs.core.not(inst_34691);
var state_34722__$1 = (function (){var statearr_34727 = state_34722;
(statearr_34727[(9)] = inst_34690__$1);

return statearr_34727;
})();
if(inst_34692){
var statearr_34728_34753 = state_34722__$1;
(statearr_34728_34753[(1)] = (5));

} else {
var statearr_34729_34754 = state_34722__$1;
(statearr_34729_34754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (15))){
var inst_34712 = (state_34722[(2)]);
var state_34722__$1 = state_34722;
var statearr_34730_34755 = state_34722__$1;
(statearr_34730_34755[(2)] = inst_34712);

(statearr_34730_34755[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (13))){
var state_34722__$1 = state_34722;
var statearr_34731_34756 = state_34722__$1;
(statearr_34731_34756[(2)] = null);

(statearr_34731_34756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (6))){
var inst_34687 = (state_34722[(7)]);
var inst_34708 = (inst_34687 > (0));
var state_34722__$1 = state_34722;
if(cljs.core.truth_(inst_34708)){
var statearr_34732_34757 = state_34722__$1;
(statearr_34732_34757[(1)] = (12));

} else {
var statearr_34733_34758 = state_34722__$1;
(statearr_34733_34758[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (3))){
var inst_34720 = (state_34722[(2)]);
var state_34722__$1 = state_34722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34722__$1,inst_34720);
} else {
if((state_val_34723 === (12))){
var inst_34686 = (state_34722[(8)]);
var inst_34710 = cljs.core.vec(inst_34686);
var state_34722__$1 = state_34722;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34722__$1,(15),out,inst_34710);
} else {
if((state_val_34723 === (2))){
var state_34722__$1 = state_34722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34722__$1,(4),ch);
} else {
if((state_val_34723 === (11))){
var inst_34702 = (state_34722[(2)]);
var inst_34703 = (new Array(n));
var inst_34686 = inst_34703;
var inst_34687 = (0);
var state_34722__$1 = (function (){var statearr_34734 = state_34722;
(statearr_34734[(10)] = inst_34702);

(statearr_34734[(7)] = inst_34687);

(statearr_34734[(8)] = inst_34686);

return statearr_34734;
})();
var statearr_34735_34759 = state_34722__$1;
(statearr_34735_34759[(2)] = null);

(statearr_34735_34759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (9))){
var inst_34686 = (state_34722[(8)]);
var inst_34700 = cljs.core.vec(inst_34686);
var state_34722__$1 = state_34722;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34722__$1,(11),out,inst_34700);
} else {
if((state_val_34723 === (5))){
var inst_34690 = (state_34722[(9)]);
var inst_34695 = (state_34722[(11)]);
var inst_34687 = (state_34722[(7)]);
var inst_34686 = (state_34722[(8)]);
var inst_34694 = (inst_34686[inst_34687] = inst_34690);
var inst_34695__$1 = (inst_34687 + (1));
var inst_34696 = (inst_34695__$1 < n);
var state_34722__$1 = (function (){var statearr_34736 = state_34722;
(statearr_34736[(12)] = inst_34694);

(statearr_34736[(11)] = inst_34695__$1);

return statearr_34736;
})();
if(cljs.core.truth_(inst_34696)){
var statearr_34737_34760 = state_34722__$1;
(statearr_34737_34760[(1)] = (8));

} else {
var statearr_34738_34761 = state_34722__$1;
(statearr_34738_34761[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (14))){
var inst_34715 = (state_34722[(2)]);
var inst_34716 = cljs.core.async.close_BANG_(out);
var state_34722__$1 = (function (){var statearr_34740 = state_34722;
(statearr_34740[(13)] = inst_34715);

return statearr_34740;
})();
var statearr_34741_34762 = state_34722__$1;
(statearr_34741_34762[(2)] = inst_34716);

(statearr_34741_34762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (10))){
var inst_34706 = (state_34722[(2)]);
var state_34722__$1 = state_34722;
var statearr_34742_34763 = state_34722__$1;
(statearr_34742_34763[(2)] = inst_34706);

(statearr_34742_34763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34723 === (8))){
var inst_34695 = (state_34722[(11)]);
var inst_34686 = (state_34722[(8)]);
var tmp34739 = inst_34686;
var inst_34686__$1 = tmp34739;
var inst_34687 = inst_34695;
var state_34722__$1 = (function (){var statearr_34743 = state_34722;
(statearr_34743[(7)] = inst_34687);

(statearr_34743[(8)] = inst_34686__$1);

return statearr_34743;
})();
var statearr_34744_34764 = state_34722__$1;
(statearr_34744_34764[(2)] = null);

(statearr_34744_34764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34750,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34750,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34745[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34745[(1)] = (1));

return statearr_34745;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34722){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34722);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34746){if((e34746 instanceof Object)){
var ex__32544__auto__ = e34746;
var statearr_34747_34765 = state_34722;
(statearr_34747_34765[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34722);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34746;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34766 = state_34722;
state_34722 = G__34766;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34722);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34750,out))
})();
var state__32614__auto__ = (function (){var statearr_34748 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34748[(6)] = c__32612__auto___34750);

return statearr_34748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34750,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__34768 = arguments.length;
switch (G__34768) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__32612__auto___34838 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__32612__auto___34838,out){
return (function (){
var f__32613__auto__ = (function (){var switch__32540__auto__ = ((function (c__32612__auto___34838,out){
return (function (state_34810){
var state_val_34811 = (state_34810[(1)]);
if((state_val_34811 === (7))){
var inst_34806 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34812_34839 = state_34810__$1;
(statearr_34812_34839[(2)] = inst_34806);

(statearr_34812_34839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (1))){
var inst_34769 = [];
var inst_34770 = inst_34769;
var inst_34771 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_34810__$1 = (function (){var statearr_34813 = state_34810;
(statearr_34813[(7)] = inst_34771);

(statearr_34813[(8)] = inst_34770);

return statearr_34813;
})();
var statearr_34814_34840 = state_34810__$1;
(statearr_34814_34840[(2)] = null);

(statearr_34814_34840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (4))){
var inst_34774 = (state_34810[(9)]);
var inst_34774__$1 = (state_34810[(2)]);
var inst_34775 = (inst_34774__$1 == null);
var inst_34776 = cljs.core.not(inst_34775);
var state_34810__$1 = (function (){var statearr_34815 = state_34810;
(statearr_34815[(9)] = inst_34774__$1);

return statearr_34815;
})();
if(inst_34776){
var statearr_34816_34841 = state_34810__$1;
(statearr_34816_34841[(1)] = (5));

} else {
var statearr_34817_34842 = state_34810__$1;
(statearr_34817_34842[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (15))){
var inst_34800 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34818_34843 = state_34810__$1;
(statearr_34818_34843[(2)] = inst_34800);

(statearr_34818_34843[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (13))){
var state_34810__$1 = state_34810;
var statearr_34819_34844 = state_34810__$1;
(statearr_34819_34844[(2)] = null);

(statearr_34819_34844[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (6))){
var inst_34770 = (state_34810[(8)]);
var inst_34795 = inst_34770.length;
var inst_34796 = (inst_34795 > (0));
var state_34810__$1 = state_34810;
if(cljs.core.truth_(inst_34796)){
var statearr_34820_34845 = state_34810__$1;
(statearr_34820_34845[(1)] = (12));

} else {
var statearr_34821_34846 = state_34810__$1;
(statearr_34821_34846[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (3))){
var inst_34808 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34810__$1,inst_34808);
} else {
if((state_val_34811 === (12))){
var inst_34770 = (state_34810[(8)]);
var inst_34798 = cljs.core.vec(inst_34770);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34810__$1,(15),out,inst_34798);
} else {
if((state_val_34811 === (2))){
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34810__$1,(4),ch);
} else {
if((state_val_34811 === (11))){
var inst_34774 = (state_34810[(9)]);
var inst_34778 = (state_34810[(10)]);
var inst_34788 = (state_34810[(2)]);
var inst_34789 = [];
var inst_34790 = inst_34789.push(inst_34774);
var inst_34770 = inst_34789;
var inst_34771 = inst_34778;
var state_34810__$1 = (function (){var statearr_34822 = state_34810;
(statearr_34822[(7)] = inst_34771);

(statearr_34822[(11)] = inst_34790);

(statearr_34822[(8)] = inst_34770);

(statearr_34822[(12)] = inst_34788);

return statearr_34822;
})();
var statearr_34823_34847 = state_34810__$1;
(statearr_34823_34847[(2)] = null);

(statearr_34823_34847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (9))){
var inst_34770 = (state_34810[(8)]);
var inst_34786 = cljs.core.vec(inst_34770);
var state_34810__$1 = state_34810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34810__$1,(11),out,inst_34786);
} else {
if((state_val_34811 === (5))){
var inst_34771 = (state_34810[(7)]);
var inst_34774 = (state_34810[(9)]);
var inst_34778 = (state_34810[(10)]);
var inst_34778__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34774) : f.call(null,inst_34774));
var inst_34779 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34778__$1,inst_34771);
var inst_34780 = cljs.core.keyword_identical_QMARK_(inst_34771,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_34781 = ((inst_34779) || (inst_34780));
var state_34810__$1 = (function (){var statearr_34824 = state_34810;
(statearr_34824[(10)] = inst_34778__$1);

return statearr_34824;
})();
if(cljs.core.truth_(inst_34781)){
var statearr_34825_34848 = state_34810__$1;
(statearr_34825_34848[(1)] = (8));

} else {
var statearr_34826_34849 = state_34810__$1;
(statearr_34826_34849[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (14))){
var inst_34803 = (state_34810[(2)]);
var inst_34804 = cljs.core.async.close_BANG_(out);
var state_34810__$1 = (function (){var statearr_34828 = state_34810;
(statearr_34828[(13)] = inst_34803);

return statearr_34828;
})();
var statearr_34829_34850 = state_34810__$1;
(statearr_34829_34850[(2)] = inst_34804);

(statearr_34829_34850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (10))){
var inst_34793 = (state_34810[(2)]);
var state_34810__$1 = state_34810;
var statearr_34830_34851 = state_34810__$1;
(statearr_34830_34851[(2)] = inst_34793);

(statearr_34830_34851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34811 === (8))){
var inst_34774 = (state_34810[(9)]);
var inst_34778 = (state_34810[(10)]);
var inst_34770 = (state_34810[(8)]);
var inst_34783 = inst_34770.push(inst_34774);
var tmp34827 = inst_34770;
var inst_34770__$1 = tmp34827;
var inst_34771 = inst_34778;
var state_34810__$1 = (function (){var statearr_34831 = state_34810;
(statearr_34831[(7)] = inst_34771);

(statearr_34831[(8)] = inst_34770__$1);

(statearr_34831[(14)] = inst_34783);

return statearr_34831;
})();
var statearr_34832_34852 = state_34810__$1;
(statearr_34832_34852[(2)] = null);

(statearr_34832_34852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__32612__auto___34838,out))
;
return ((function (switch__32540__auto__,c__32612__auto___34838,out){
return (function() {
var cljs$core$async$state_machine__32541__auto__ = null;
var cljs$core$async$state_machine__32541__auto____0 = (function (){
var statearr_34833 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34833[(0)] = cljs$core$async$state_machine__32541__auto__);

(statearr_34833[(1)] = (1));

return statearr_34833;
});
var cljs$core$async$state_machine__32541__auto____1 = (function (state_34810){
while(true){
var ret_value__32542__auto__ = (function (){try{while(true){
var result__32543__auto__ = switch__32540__auto__(state_34810);
if(cljs.core.keyword_identical_QMARK_(result__32543__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__32543__auto__;
}
break;
}
}catch (e34834){if((e34834 instanceof Object)){
var ex__32544__auto__ = e34834;
var statearr_34835_34853 = state_34810;
(statearr_34835_34853[(5)] = ex__32544__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34834;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__32542__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34854 = state_34810;
state_34810 = G__34854;
continue;
} else {
return ret_value__32542__auto__;
}
break;
}
});
cljs$core$async$state_machine__32541__auto__ = function(state_34810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__32541__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__32541__auto____1.call(this,state_34810);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__32541__auto____0;
cljs$core$async$state_machine__32541__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__32541__auto____1;
return cljs$core$async$state_machine__32541__auto__;
})()
;})(switch__32540__auto__,c__32612__auto___34838,out))
})();
var state__32614__auto__ = (function (){var statearr_34836 = (f__32613__auto__.cljs$core$IFn$_invoke$arity$0 ? f__32613__auto__.cljs$core$IFn$_invoke$arity$0() : f__32613__auto__.call(null));
(statearr_34836[(6)] = c__32612__auto___34838);

return statearr_34836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__32614__auto__);
});})(c__32612__auto___34838,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
