/*
 * Decompiled with CFR 0.152.
 */
package com.vi.aws.logging.log4jappenders;

import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.vi.aws.logging.log4jappenders.Config;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="CloudWatchAppender", category="Core", elementType="appender", printObject=true)
public class CloudWatchAppender
extends AbstractAppender {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
    private static final String AWS_INSTANCE_ID = Config.retrieveInstanceId();
    private final BlockingQueue<InputLogEvent> queue = new LinkedBlockingQueue<InputLogEvent>(10000);
    private volatile boolean shutdown = false;
    private final int flushPeriodMillis;
    private Thread deliveryThread;
    private final Object monitor = new Object();
    private String sequenceTokenCache = null;
    private long lastReportedTimestamp = -1L;
    private String logGroupName;
    private String logStreamName;
    private AWSLogsClient awsLogsClient = null;
    private volatile boolean queueFull = false;
    private Runnable messageProcessor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CloudWatchAppender.this.debug("Draining queue for " + CloudWatchAppender.this.logStreamName + " stream every " + CloudWatchAppender.this.flushPeriodMillis / 1000 + "s...");
            while (!CloudWatchAppender.this.shutdown) {
                try {
                    CloudWatchAppender.this.flush();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (CloudWatchAppender.this.shutdown || CloudWatchAppender.this.queue.size() >= 256) continue;
                try {
                    Object t = CloudWatchAppender.this.monitor;
                    synchronized (t) {
                        CloudWatchAppender.this.monitor.wait(CloudWatchAppender.this.flushPeriodMillis);
                    }
                }
                catch (InterruptedException ix) {
                    ix.printStackTrace();
                }
            }
            while (!CloudWatchAppender.this.queue.isEmpty()) {
                CloudWatchAppender.this.flush();
            }
        }
    };

    @PluginFactory
    public static CloudWatchAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="awsLogGroupName") String awsLogGroupName, @PluginAttribute(value="awsLogStreamName") String awsLogStreamName, @PluginAttribute(value="awsLogStreamFlushPeriodInSeconds") String awsLogStreamFlushPeriodInSeconds, @PluginElement(value="Layout") Layout<Serializable> layout) {
        return new CloudWatchAppender(name == null ? "CloudWatchAppender" : name, awsLogGroupName == null ? "unknown" : awsLogGroupName, awsLogStreamName, awsLogStreamFlushPeriodInSeconds, layout);
    }

    private CloudWatchAppender(String name, String awsLogGroupName, String awsLogStreamName, String awsLogStreamFlushPeriodInSeconds, Layout<Serializable> layout) {
        super(name, null, layout == null ? PatternLayout.createDefaultLayout() : layout, false);
        int flushPeriod = 5;
        if (awsLogStreamFlushPeriodInSeconds != null) {
            try {
                flushPeriod = Integer.parseInt(awsLogStreamFlushPeriodInSeconds);
            }
            catch (NumberFormatException nfe) {
                this.debug("Bad awsLogStreamFlushPeriodInSeconds (" + awsLogStreamFlushPeriodInSeconds + "), defaulting to: " + 5 + "s");
            }
        } else {
            this.debug("No awsLogStreamFlushPeriodInSeconds specified, defaulted to 5s");
        }
        this.flushPeriodMillis = flushPeriod * 1000;
        try {
            String finalLogStreamName;
            this.awsLogsClient = new AWSLogsClient();
            this.logGroupName = awsLogGroupName;
            String logStreamNamePrefix = awsLogStreamName;
            if (logStreamNamePrefix == null) {
                logStreamNamePrefix = Config.ENV_LOG_STREAM_NAME;
            }
            if (logStreamNamePrefix == null) {
                logStreamNamePrefix = AWS_INSTANCE_ID;
            }
            do {
                finalLogStreamName = logStreamNamePrefix + " " + this.getTimeNow();
                this.sequenceTokenCache = this.createLogGroupAndLogStreamIfNeeded(this.logGroupName, finalLogStreamName);
            } while (this.sequenceTokenCache != null);
            this.logStreamName = finalLogStreamName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void flush() {
        int drained;
        ArrayList logEvents = new ArrayList(256);
        do {
            drained = this.queue.drainTo(logEvents, 256);
            if (logEvents.isEmpty()) break;
            Collections.sort(logEvents, new Comparator<InputLogEvent>(){

                @Override
                public int compare(InputLogEvent o1, InputLogEvent o2) {
                    return o1.getTimestamp().compareTo(o2.getTimestamp());
                }
            });
            if (this.lastReportedTimestamp > 0L) {
                InputLogEvent event;
                Iterator iterator = logEvents.iterator();
                while (iterator.hasNext() && (event = (InputLogEvent)iterator.next()).getTimestamp() < this.lastReportedTimestamp) {
                    event.setTimestamp(Long.valueOf(this.lastReportedTimestamp));
                }
            }
            this.lastReportedTimestamp = ((InputLogEvent)logEvents.get(logEvents.size() - 1)).getTimestamp();
            PutLogEventsRequest putLogEventsRequest = new PutLogEventsRequest(this.logGroupName, this.logStreamName, logEvents);
            putLogEventsRequest.setSequenceToken(this.sequenceTokenCache);
            try {
                PutLogEventsResult putLogEventsResult = this.awsLogsClient.putLogEvents(putLogEventsRequest);
                this.sequenceTokenCache = putLogEventsResult.getNextSequenceToken();
            }
            catch (DataAlreadyAcceptedException daae) {
                this.debug("DataAlreadyAcceptedException, will reset the token to the expected one");
                this.sequenceTokenCache = daae.getExpectedSequenceToken();
            }
            catch (InvalidSequenceTokenException iste) {
                this.debug("InvalidSequenceTokenException, will reset the token to the expected one");
                this.sequenceTokenCache = iste.getExpectedSequenceToken();
            }
            catch (Exception e) {
                this.debug("Error writing logs");
                e.printStackTrace();
            }
            logEvents.clear();
        } while (drained >= 256);
    }

    public void append(LogEvent event) {
        InputLogEvent awsLogEvent = new InputLogEvent();
        long timestamp = event.getTimeMillis();
        String message = new String(this.getLayout().toByteArray(event));
        awsLogEvent.setTimestamp(Long.valueOf(timestamp));
        awsLogEvent.setMessage(message);
        if (!this.queue.offer(awsLogEvent) && !this.queueFull) {
            this.debug("Log queue is full!");
            this.queueFull = true;
        } else if (this.queueFull) {
            this.queueFull = false;
        }
    }

    private String createLogGroupAndLogStreamIfNeeded(String logGroupName, String logStreamName) {
        DescribeLogGroupsResult describeLogGroupsResult = this.awsLogsClient.describeLogGroups(new DescribeLogGroupsRequest().withLogGroupNamePrefix(logGroupName));
        boolean createLogGroup = true;
        if (describeLogGroupsResult != null && describeLogGroupsResult.getLogGroups() != null && !describeLogGroupsResult.getLogGroups().isEmpty()) {
            for (LogGroup lg : describeLogGroupsResult.getLogGroups()) {
                if (!logGroupName.equals(lg.getLogGroupName())) continue;
                createLogGroup = false;
                break;
            }
        }
        if (createLogGroup) {
            this.debug("Creating logGroup: " + logGroupName);
            CreateLogGroupRequest createLogGroupRequest = new CreateLogGroupRequest(logGroupName);
            this.awsLogsClient.createLogGroup(createLogGroupRequest);
        }
        String logSequenceToken = null;
        boolean createLogStream = true;
        DescribeLogStreamsRequest describeLogStreamsRequest = new DescribeLogStreamsRequest(logGroupName).withLogStreamNamePrefix(logStreamName);
        DescribeLogStreamsResult describeLogStreamsResult = this.awsLogsClient.describeLogStreams(describeLogStreamsRequest);
        if (describeLogStreamsResult != null && describeLogStreamsResult.getLogStreams() != null && !describeLogStreamsResult.getLogStreams().isEmpty()) {
            for (LogStream ls : describeLogStreamsResult.getLogStreams()) {
                if (!logStreamName.equals(ls.getLogStreamName())) continue;
                createLogStream = false;
                logSequenceToken = ls.getUploadSequenceToken();
            }
        }
        if (createLogStream) {
            this.debug("Creating logStream: " + logStreamName);
            CreateLogStreamRequest createLogStreamRequest = new CreateLogStreamRequest(logGroupName, logStreamName);
            this.awsLogsClient.createLogStream(createLogStreamRequest);
        }
        return logSequenceToken;
    }

    public void start() {
        super.start();
        this.debug("Starting cloudWatchAppender for: " + this.logGroupName + ":" + this.logStreamName);
        this.deliveryThread = new Thread(this.messageProcessor, "CloudWatchAppenderDeliveryThread");
        this.deliveryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        this.shutdown = true;
        if (this.deliveryThread != null) {
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notify();
            }
            try {
                this.deliveryThread.join(10000L);
            }
            catch (InterruptedException ix) {
                ix.printStackTrace();
            }
        }
        if (this.queue.size() > 0) {
            this.flush();
        }
    }

    private String getTimeNow() {
        return this.simpleDateFormat.format(new Date());
    }

    private void debug(String s) {
        System.out.println(this.getTimeNow() + " CloudWatchAppender: " + s);
    }
}

