(ns leiningen.doc
  (:refer-clojure :exclude [doc])
  (:use [leinjacker.eval :only (eval-in-project)])
  (:require [leinjacker.deps :as deps]))

(defn- get-options [project]
  (-> project
      (select-keys [:name :version :description])
      (merge {:sources ["src"]}
             (get project :codox)) ;; Default gets overwritten if set in :codox
      (update-in [:codox :src-uri-mapping]
                 #(into {} (map (fn [[k v]] [k (eval v)]) %)))))

(defn doc
  "Generate API documentation from source code."
  [project]
  (eval-in-project
   (deps/add-if-missing project '[ccfontes/codox.core "0.6.7-SNAPSHOT"])
   `(codox.main/generate-docs '~(get-options project))
   `(require 'codox.main)))
