/*
 * Decompiled with CFR 0.152.
 */
package bitpay.model;

import bitpay.model.BitPay;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Rates {
    private JSONArray rates;
    private BitPay bp;

    public Rates(HttpResponse response, BitPay bp) {
        try {
            JSONArray rates;
            String line;
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder content = new StringBuilder();
            while (null != (line = rd.readLine())) {
                content.append(line);
            }
            Object obj = JSONValue.parse((String)content.toString());
            this.rates = rates = (JSONArray)obj;
            this.bp = bp;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JSONArray getRates() {
        return this.rates;
    }

    public void update() {
        this.rates = this.bp.getRates().getRates();
    }

    public double getRate(String currencyCode) {
        double val = 0.0;
        for (Object rate : this.rates) {
            JSONObject obj = (JSONObject)rate;
            if (!obj.get((Object)"code").equals(currencyCode)) continue;
            val = (Double)obj.get((Object)"rate");
        }
        return val;
    }
}

