/*
 * Decompiled with CFR 0.152.
 */
package bitpay.model;

import bitpay.model.Invoice;
import bitpay.model.InvoiceParams;
import bitpay.model.Rates;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitPay {
    private static final String BASE_URL = "https://bitpay.com/api/";
    private String apiKey;
    private HttpClient client;
    String auth;
    private String currency;

    public BitPay(String apiKey, String currency) {
        this.apiKey = apiKey;
        this.currency = currency;
        this.auth = new String(Base64.encodeBase64((byte[])(this.apiKey + ": ").getBytes()));
        this.client = HttpClientBuilder.create().build();
    }

    public Invoice createInvoice(double price) {
        if (this.currency.length() > 3) {
            throw new IllegalArgumentException("Must be a valid currency code");
        }
        String url = "https://bitpay.com/api/invoice";
        try {
            HttpPost post = new HttpPost(url);
            post.addHeader("Authorization", "Basic " + this.auth);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getParams(price, this.currency), "UTF-8"));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            return this.createInvoiceObjectFromResponse(response);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Invoice createInvoice(double price, InvoiceParams params) {
        if (this.currency.length() > 3) {
            throw new IllegalArgumentException("Must be a valid currency code");
        }
        String url = "https://bitpay.com/api/invoice";
        try {
            HttpPost post = new HttpPost(url);
            post.addHeader("Authorization", "Basic " + this.auth);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getParams(price, this.currency, params), "UTF-8"));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            return this.createInvoiceObjectFromResponse(response);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Invoice getInvoice(String invoiceId) {
        String url = "https://bitpay.com/api/invoice/" + invoiceId;
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", "Basic " + this.auth);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)get);
            return this.createInvoiceObjectFromResponse(response);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Rates getRates() {
        String url = "https://bitpay.com/api/rates";
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", "Basic " + this.auth);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)get);
            return new Rates(response, this);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<NameValuePair> getParams(double price, String currency) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add((NameValuePair)new BasicNameValuePair("price", price + ""));
        params.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return params;
    }

    private List<NameValuePair> getParams(double price, String currency, InvoiceParams optionalParams) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        for (BasicNameValuePair param : optionalParams.getNameValuePairs()) {
            params.add((NameValuePair)param);
        }
        params.add((NameValuePair)new BasicNameValuePair("price", price + ""));
        params.add((NameValuePair)new BasicNameValuePair("currency", currency));
        return params;
    }

    private Invoice createInvoiceObjectFromResponse(HttpResponse response) throws IOException, JSONException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder content = new StringBuilder();
        while (null != (line = rd.readLine())) {
            content.append(line);
        }
        Object obj = JSONValue.parse((String)content.toString());
        JSONObject finalResult = (JSONObject)obj;
        if (finalResult.get((Object)"error") != null) {
            System.out.println("Error: " + finalResult.get((Object)"error"));
        }
        return new Invoice(finalResult);
    }
}

