# mandrill

A Clojure library for consuming the
[Mandrill](https://mandrillapp.com) API.

## Usage

Available on [Clojars](http://clojars.org).

```clojure
[cc.rightangle/mandrill "0.1.1"]
```

```clojure
(ns your.app
  (:require [rightangle.mandrill.client :as client]))

; Give Mandrill a default API key. This can also be overridden per-request, and
; is totally optional if you want to merge it into your API requests yourself.
; Read on for an example.
(client/set-api-key! "YOUR-SECRET-KEY")

; Create a default Mandrill client. You can also specify a map of clj-http
; parameters.
(def mandrill (client/create))
;(def mandrill (client/create {:socket-timeout 1000}))

; Build up an interesting message to send.
(def msg {:message {:to [{:email "nobody@example.com"
                          :name "Nobody"}]
                    :from_email "you@yourdomain.com"
                    :subject "This is a test"
                    :text "Really interesting text-only content."}})
; You can override the key per-request, per the Mandrill docs.
;(def msg {:key "YOUR KEY"
;          :message {...}})

; Send the message using the configured Mandrill client.
; Functions are named consistent with the Mandrill REST API endpoints.
(client/messages-send mandrill msg)
```

## Features

Currently only the
[messages](https://mandrillapp.com/api/docs/messages.JSON.html) calls are
implemented.

## License

Copyright © 2014 Right Angle Consulting LLC

Distributed under the [ISC License](http://opensource.org/licenses/ISC)
