# mandrill

A Clojure library for consuming the
[Mandrill](https://mandrillapp.com) API.

## Usage

Available on [Clojars](http://clojars.org).

```clojure
[cc.rightangle/mandrill "0.1.0"]
```

```clojure
(ns your.app
  (:require [rightangle.mandrill.client :as client]))

(client/set-api-key! "YOUR-SECRET-KEY")

(def mandrill-client (client/create))

(client/messages-send mandrill-client {:message {:to [{:email "nobody@example.com"
                                                       :name "Nobody"}]
                                                 :from_email "you@yourdomain.com"
                                                 :subject "This is a test"}})
```

## Details

You can pass an optional hash to `rightangle.mandrill.client/create` which will
be passed to `clj-http`.

You can override the API key by including it in any of the requests. It will
take precedence over anything set with `set-api-key!`.

## Features

Currently only the
[messages](https://mandrillapp.com/api/docs/messages.JSON.html) calls are
implemented.

## License

Copyright © 2014 Right Angle Consulting LLC

Distributed under the [ISC License](http://opensource.org/licenses/ISC)
