(ns cc.riddy.grid
  (:require [potemkin :refer [import-vars]]
            [cc.riddy.grid.impl]
            [cc.riddy.grid.everywhere]
            [cc.riddy.grid.operations]
            [cc.riddy.grid.transforms]
            [cc.riddy.grid.convert]
            [cc.riddy.grid.print]))

(import-vars
  [cc.riddy.grid.impl
    grid
    width
    height
    with-index-mode
    set-index-mode!]
  [cc.riddy.grid.everywhere
    everywhere]
  [cc.riddy.grid.operations
    add-rows
    add-cols
    drop-rows
    drop-cols
    map-vals
    map-kv
    concat-lr
    concat-tb]
  [cc.riddy.grid.transforms
    transpose
    rotate-right
    rotate-left
    rotate-180
    flip-lr
    flip-tb]
  [cc.riddy.grid.convert
    to-vec
    to-vecs
    to-map
    to-maps]
  [cc.riddy.grid.print
    print-table
    table-str])
