/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.net.MalformedURLException;
import java.net.URL;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

final class URLEntityJSONImpl
implements URLEntity {
    private int start = -1;
    private int end = -1;
    private URL url;
    private URL expandedURL;
    private String displayURL;
    private static final long serialVersionUID = 1165188478018146676L;

    URLEntityJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    URLEntityJSONImpl(int start, int end, String url, String expandedURL, String displayURL) {
        this.start = start;
        this.end = end;
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            try {
                this.url = new URL("http://example.com/");
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        try {
            this.expandedURL = new URL(expandedURL);
        }
        catch (MalformedURLException e) {
            try {
                this.expandedURL = new URL("http://example.com/");
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        this.displayURL = displayURL;
    }

    URLEntityJSONImpl() {
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.start = indicesArray.getInt(0);
            this.end = indicesArray.getInt(1);
            try {
                this.url = new URL(json.getString("url"));
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            if (!json.isNull("expanded_url")) {
                try {
                    this.expandedURL = new URL(json.getString("expanded_url"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!json.isNull("display_url")) {
                this.displayURL = json.getString("display_url");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public URL getExpandedURL() {
        return this.expandedURL;
    }

    public String getDisplayURL() {
        return this.displayURL;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLEntityJSONImpl that = (URLEntityJSONImpl)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        if (this.displayURL != null ? !this.displayURL.equals(that.displayURL) : that.displayURL != null) {
            return false;
        }
        if (this.expandedURL != null ? !this.expandedURL.toString().equalsIgnoreCase(that.expandedURL.toString()) : that.expandedURL != null) {
            return false;
        }
        return !(this.url != null ? !this.url.toString().equalsIgnoreCase(that.url.toString()) : that.url != null);
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.url != null ? this.url.toString().hashCode() : 0);
        result = 31 * result + (this.expandedURL != null ? this.expandedURL.toString().hashCode() : 0);
        result = 31 * result + (this.displayURL != null ? this.displayURL.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "URLEntityJSONImpl{start=" + this.start + ", end=" + this.end + ", url=" + this.url + ", expandedURL=" + this.expandedURL + ", displayURL=" + this.displayURL + '}';
    }
}

