(ns qbits.tape.tailer
  (:require [qbits.commons.enum :as enum]
            [qbits.commons.ns :as n]
            [qbits.tape.codec :as codec]
            [clojure.datafy :as d]
            [clojure.core.protocols :as p])
  (:import (net.openhft.chronicle.queue ChronicleQueue
                                        ExcerptTailer
                                        TailerDirection)))

(def ->tailer-direction (enum/enum->fn TailerDirection))

(defn ^ExcerptTailer make
  ([^ChronicleQueue queue]
   (make queue nil))
  ([^ChronicleQueue queue opts]
   (.createTailer queue)))

(defprotocol ITailer
  (read! [tailer])
  (set-direction! [tailer dir])
  (to-index! [tailer i])
  (to-end! [tailer])
  (to-start! [tailer])
  (index [tailer]))

(extend-type ExcerptTailer
  ITailer
  (read! [^ExcerptTailer tailer]
    (with-open [ctx (.readingDocument tailer)]
      (when (.isPresent ctx)
        (-> ctx
            .wire .read .bytes
            java.nio.ByteBuffer/wrap
            codec/read))))

  (set-direction! [tailer direction]
    (.direction tailer (->tailer-direction direction)))

  (to-index! [^ExcerptTailer tailer i]
    (.moveToIndex tailer i))

  (to-end! [tailer]
    (.toEnd tailer))

  (to-start! [tailer]
    (.toStart tailer))

  (index [tailer]
    (.index tailer)))

(extend-protocol p/Datafiable
  ExcerptTailer
  (datafy [^ExcerptTailer tailer]
    {::cycle (.cycle tailer)
     ::index (index tailer)
     ::source-id (.sourceId tailer)
     ::queue (.queue tailer)
     ::direction (.direction tailer)
     ::state (.state tailer)}))
