(ns qbits.tape.queue
  (:require [qbits.commons.enum :as enum]
            [clojure.datafy :as d]
            [clojure.core.protocols :as p])
  (:import (net.openhft.chronicle.queue ChronicleQueue
                                        RollCycles)
           (net.openhft.chronicle.queue.impl.single SingleChronicleQueueBuilder
                                                    SingleChronicleQueue)))

(set! *warn-on-reflection* true)

(def ->roll-cycle (enum/enum->fn RollCycles))

(extend-protocol p/Datafiable
  SingleChronicleQueue
  (datafy [^SingleChronicleQueue q]
    ;; https://github.com/OpenHFT/Chronicle-Queue/blob/master/src/main/java/net/openhft/chronicle/queue/impl/single/SingleChronicleQueue.java
    {::source-id (.sourceId q)
     ::last-acknowledged-index-replicated (.lastAcknowledgedIndexReplicated q)
     ::last-index-replicated (.lastIndexReplicated q)
     ::file (.fileAbsolutePath q)
     ::index-count (.indexCount q)
     ::index-spacing (.indexSpacing q)
     ::roll-cycle (.rollCycle q)
     ::delta-checkpoint-interval (.deltaCheckpointInterval q)
     ::buffered (.buffered q)
     ::cycle (.cycle q)
     ::closed? (.isClosed q)}))

(defn closed?
  [^SingleChronicleQueue queue]
  (.isClosed queue))

(defn make
  "Creates and return a new queue"
  ([dir]
   (make dir nil))
  ([dir {:as opts
         :keys [roll-cycle]
         :or {roll-cycle :small-daily}}]
   (cond-> (ChronicleQueue/singleBuilder ^String dir)
     roll-cycle
     (.rollCycle (->roll-cycle roll-cycle))
     :then (.build))))
