(ns qbits.tape.listener
  (:require [clojure.java.io :as io]
            [clojure.tools.logging :as log]
            [clojure.java.shell :as shell]
            [clojure.datafy :as d])
  (:import (net.openhft.chronicle.queue.impl StoreFileListener)
           (net.openhft.chronicle.queue RollCycle)
           (java.io File FileOutputStream)
           (java.util.zip GZIPOutputStream)))

(defmulti action* (fn [k file] k))

(defmethod action* :gzip
  [_ ^File file]
  (let [name (.getName file)
        parent (.getParent file)]
    (log/infof "Compressing %s" file)
    ;; shelling out like Calimero
    ;; FIXME
    (shell/sh "sh" "-c" (format "tar -cvzf %s.tar.gz %s -C %s" name name parent))))

(defmethod action* :delete
  [_ file]
  (log/infof "Deleting %s" file)
  (io/delete-file file))

(defmethod action* :log [_ file]
  (log/infof "To be cleaned up %s" file))

(defn match-cycle-file?
  [s]
  (re-find #"^\d{4}\d{2}\d{2}\.c4$" s))

(defn make
  ([queue]
   (make queue nil))
  ([queue {:as opts
           :keys [action keep-max]
           :or {action :log
                keep-max 3
                ;; not implemented yet
                max-size -1 }}]
   (let [cleanup (fn []
                   (let [qd (d/datafy queue)
                         files (some->> (:qbits.tape.queue/file qd)
                                        io/file
                                        .listFiles
                                        (filter #(-> ^File % .getName match-cycle-file?)))
                         num-files (count files)]
                     (when (> num-files keep-max)
                       (let [files-to-act-on (drop keep-max (reverse (sort files)))]
                         (log/infof "Acting on %s" files-to-act-on)
                         (run! (partial action* action)
                               files-to-act-on)))))]
     (reify StoreFileListener
       (onReleased [_ _cycle _file]
         (log/infof "Got relase on %s %s" _cycle _file)
         (cleanup)))
     (cleanup))))
