(ns qbits.tape.appender
  (:require [clojure.data.fressian :as fressian]
            [clojure.datafy :as d]
            [clojure.core.protocols :as p]
            [qbits.tape.codec :as codec])
  (:import (net.openhft.chronicle.queue ChronicleQueue
                                        ExcerptAppender)
           (net.openhft.chronicle.bytes Bytes)))

(set! *warn-on-reflection* true)

(defprotocol IAppender
  (write! [appender x])
  (last-index [appender]))

(defn ^ExcerptAppender make
  ([^ChronicleQueue queue]
   (make queue nil))
  ([^ChronicleQueue queue opts]
   (.acquireAppender queue)))

(extend-type ExcerptAppender
  IAppender
  (write! [^ExcerptAppender appender x]
    (let [rw (Bytes/wrapForRead (codec/write x))]
      (with-open [ctx (.writingDocument appender)]
        (-> ctx .wire .write (.bytes rw))
        (.index ctx))))
  (last-index [appender]
    (.lastIndexAppended appender)))

(extend-protocol p/Datafiable
  ExcerptAppender
  (datafy [^ExcerptAppender appender]
    {::cycle (.cycle appender)
     ::last-index-appended (.lastIndexAppended appender)
     ::source-id (.sourceId appender)
     ::queue (.queue appender)}))
