(ns qbits.spandex.dsl
  (:require
   [qbits.spandex :as s]
   [qbits.spandex.utils :as utils]))

(defn add-doc
  ([client server index type doc {:keys [id query-string]}]
   (s/request client
                  {:method :post
                   :query-string query-string
                   :url (utils/url server index type id)
                   :body doc}))
  ([client index type doc]
   (add-doc client index type doc nil)))

(defn get-doc
  ([client index type id]
   (get-doc client index type id nil))
  ([client server index type id {:keys [query-string]}]
   (s/request client
                  {:method :get
                   :query-string query-string
                   :url (utils/url server index type id)})))

(defn mget-doc
  ([client query]
   (mget-doc query nil))
  ([client query {:keys [index type query-params]}]
   (s/request client
                  {:method :get
                   :query-string query-string
                   :url (utils/url server index type "_mget")
                   :body query})))

;; (defn update-doc
;;   ([client query {:keys [index type query-params]}]
;;    (update-doc client query nil))
;;   ([client query {:keys [index type query-params]}]
;;    (utils/request client
;;                   {:method :delete
;;                    :url (utils/url server index type "_update")
;;                    :query-params query-params
;;                    :body (json/generate-string query)})))

(defn delete-doc
  ([client index type id]
   (delete-doc client index type id nil))
  ([client index type id {:keys [query-string]}]
   (s/request client
                  {:method :delete
                   :url (utils/url server index type id)
                   :query-string query-string})))

(defn delete-by-query
  [client server query {:keys [index type query-params]}]
  (s/request client
                 {:method :delete
                  :url (utils/url server index type "_query")
                  :query-params query-params
                  :body (json/generate-string query)}))

(defn search-doc
  [client server search-query & {:keys [index type query-params]}]
  (s/request client
             {:method :get
              :url (utils/url server index type "_search")
              :query-params query-params
              :body (json/generate-string search-query)}))

(defn percolate
  [client server index name query & {:keys [query-params]}]
  (s/request client
                 {:method :put
                  :url (utils/url server ".percolator" index name)
                  :query-params query-params
                  :body (json/generate-string query)}))

(defn count-docs
  [client server query & {:keys [index type query-params]}]
  (utils/request client
                 {:method :get
                  :url (utils/url server index type  "_count")
                  :query-params query-params
                  :body (json/generate-string query)}))

(defn bulk
  [client server bulk-lines & {:keys [query-params]}]
  (utils/request client
                 {:method :put
                  :url (utils/url server "_bulk")
                  :query-params query-params
                  :auto-transform false
                  :headers {"content-type" "text/plain"}
                  :body (->> bulk-lines
                             (map #(str (json/generate-string %) "\n"))
                             (apply str))}))
