/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.ws;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.httpkit.ProtocolException;
import org.httpkit.ws.BinaryFrame;
import org.httpkit.ws.CloseFrame;
import org.httpkit.ws.PingFrame;
import org.httpkit.ws.TextFrame;
import org.httpkit.ws.WSFrame;

public class WSDecoder {
    public static final byte OPCODE_CONT = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private State state = State.FRAME_START;
    private byte[] content;
    private int idx = 0;
    private int payloadLength;
    private int payloadRead;
    private int maskingKey;
    private boolean finalFlag;
    private int opcode = -1;

    public WSFrame decode(ByteBuffer buffer) throws ProtocolException {
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case FRAME_START: {
                    byte b = buffer.get();
                    this.finalFlag = (b & 0x80) != 0;
                    int tmpOp = b & 0xF;
                    if (this.opcode != -1 && tmpOp != this.opcode) {
                        throw new ProtocolException("opcode mismatch: pre: " + this.opcode + ", now: " + tmpOp);
                    }
                    this.opcode = tmpOp;
                    b = buffer.get();
                    boolean masked = (b & 0x80) != 0;
                    this.payloadLength = b & 0x7F;
                    if (this.payloadLength == 126) {
                        this.payloadLength = buffer.getShort() & 0xFFFF;
                        if (this.payloadLength < 126) {
                            throw new ProtocolException("invalid data frame length (not using minimal length encoding)");
                        }
                    } else if (this.payloadLength == 127) {
                        long length = buffer.getLong();
                        if (length < 65536L) {
                            throw new ProtocolException("invalid data frame length. max payload length 4M");
                        }
                        this.abortIfTooLarge(length);
                        this.payloadLength = (int)length;
                    }
                    if (this.content == null) {
                        this.content = new byte[this.payloadLength];
                    } else if (this.payloadLength > 0) {
                        this.abortIfTooLarge(this.content.length + this.payloadLength);
                        this.content = Arrays.copyOf(this.content, this.content.length + this.payloadLength);
                    }
                    if (!masked) {
                        throw new ProtocolException("unmasked client to server frame");
                    }
                    this.state = State.MASKING_KEY;
                    break;
                }
                case MASKING_KEY: {
                    this.maskingKey = buffer.getInt();
                    this.state = State.PAYLOAD;
                }
                case PAYLOAD: {
                    int read = Math.min(buffer.remaining(), this.payloadLength - this.payloadRead);
                    if (read > 0) {
                        buffer.get(this.content, this.idx, read);
                        byte[] mask = ByteBuffer.allocate(4).putInt(this.maskingKey).array();
                        for (int i = 0; i < read; ++i) {
                            this.content[i + this.idx] = (byte)(this.content[i + this.idx] ^ mask[i % 4]);
                        }
                        this.payloadRead += read;
                        this.idx += read;
                    }
                    if (this.payloadRead != this.payloadLength) break;
                    if (this.finalFlag) {
                        switch (this.opcode) {
                            case 1: {
                                return new TextFrame(this.content);
                            }
                            case 2: {
                                return new BinaryFrame(this.content);
                            }
                            case 9: {
                                return new PingFrame(this.content);
                            }
                            case 8: {
                                return new CloseFrame(this.content);
                            }
                        }
                        throw new ProtocolException("not impl for opcode: " + this.opcode);
                    }
                    this.state = State.FRAME_START;
                    this.payloadRead = 0;
                }
            }
        }
        return null;
    }

    public void abortIfTooLarge(long length) throws ProtocolException {
        if (length > 0x400000L) {
            throw new ProtocolException("Max payload length 4m, get: " + length);
        }
    }

    public void reset() {
        this.state = State.FRAME_START;
        this.payloadRead = 0;
        this.idx = 0;
        this.opcode = -1;
        this.content = null;
    }

    public static enum State {
        FRAME_START,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

