/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.httpkit.HttpMethod;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.LineTooLargeException;
import org.httpkit.ProtocolException;
import org.httpkit.RequestTooLargeException;
import org.httpkit.server.HttpRequest;

public class RequestDecoder {
    private State state = State.READ_INITIAL;
    private int readRemaining = 0;
    private int readCount = 0;
    HttpRequest request;
    private Map<String, String> headers = new TreeMap<String, String>();
    byte[] content;
    int lineBufferIdx = 0;
    private byte[] lineBuffer = new byte[1024];
    private final int maxBody;
    private final int maxLine;

    public RequestDecoder(int maxBody, int maxLine) {
        this.maxBody = maxBody;
        this.maxLine = maxLine;
    }

    private void createRequest(String sb) throws ProtocolException {
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString((String)sb))) {
            try {
                HttpMethod method = HttpMethod.valueOf(sb.substring(aStart, aEnd).toUpperCase());
                HttpVersion version = HttpVersion.HTTP_1_1;
                if ("HTTP/1.0".equals(sb.substring(cStart, cEnd))) {
                    version = HttpVersion.HTTP_1_0;
                }
                this.request = new HttpRequest(method, sb.substring(bStart, bEnd), version);
            }
            catch (Exception e) {
                throw new ProtocolException("method not understand");
            }
        } else {
            throw new ProtocolException("not http?");
        }
    }

    public HttpRequest decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException, RequestTooLargeException {
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case ALL_READ: {
                    return this.request;
                }
                case READ_INITIAL: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.createRequest(line);
                    this.state = State.READ_HEADER;
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = State.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.throwIfBodyIsTooLarge();
                    if (this.content == null) {
                        this.content = new byte[this.readRemaining];
                    } else if (this.content.length < this.readCount + this.readRemaining) {
                        int newLength = (int)((double)(this.readRemaining + this.readCount) * 1.3);
                        this.content = Arrays.copyOf(this.content, newLength);
                    }
                    this.state = State.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.finish();
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.state = State.READ_CHUNK_DELIMITER;
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.finish();
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = State.READ_CHUNK_SIZE;
                }
            }
        }
        return this.state == State.ALL_READ ? this.request : null;
    }

    private void finish() {
        this.state = State.ALL_READ;
        this.request.setBody(this.content, this.readCount);
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13 && buffer.hasRemaining()) {
            buffer.get();
        }
    }

    void readFixedLength(ByteBuffer buffer) {
        int toRead = Math.min(buffer.remaining(), this.readRemaining);
        buffer.get(this.content, this.readCount, toRead);
        this.readRemaining -= toRead;
        this.readCount += toRead;
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException, RequestTooLargeException, ProtocolException {
        String line = this.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        this.request.setHeaders(this.headers);
        String te = this.headers.get("transfer-encoding");
        if ("chunked".equals(te)) {
            this.state = State.READ_CHUNK_SIZE;
        } else {
            String cl = this.headers.get("content-length");
            if (cl != null) {
                try {
                    this.readRemaining = Integer.parseInt(cl);
                    if (this.readRemaining > 0) {
                        this.throwIfBodyIsTooLarge();
                        this.content = new byte[this.readRemaining];
                        this.state = State.READ_FIXED_LENGTH_CONTENT;
                    }
                    this.state = State.ALL_READ;
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException(e.getMessage());
                }
            } else {
                this.state = State.ALL_READ;
            }
        }
    }

    String readLine(ByteBuffer buffer) throws LineTooLargeException {
        boolean more = true;
        while (buffer.hasRemaining() && more) {
            byte b = buffer.get();
            if (b == 13) {
                if (!buffer.hasRemaining() || buffer.get() != 10) continue;
                more = false;
                continue;
            }
            if (b == 10) {
                more = false;
                continue;
            }
            if (this.lineBufferIdx == this.maxLine - 2) {
                throw new LineTooLargeException("line length exceed " + this.lineBuffer.length);
            }
            if (this.lineBufferIdx == this.lineBuffer.length) {
                this.lineBuffer = Arrays.copyOf(this.lineBuffer, this.lineBuffer.length * 2);
            }
            this.lineBuffer[this.lineBufferIdx] = b;
            ++this.lineBufferIdx;
        }
        String line = null;
        if (!more) {
            line = new String(this.lineBuffer, 0, this.lineBufferIdx);
            this.lineBufferIdx = 0;
        }
        return line;
    }

    public void reset() {
        this.state = State.READ_INITIAL;
        this.headers = new TreeMap<String, String>();
        this.readCount = 0;
        this.content = null;
        this.lineBufferIdx = 0;
        this.request = null;
    }

    private void throwIfBodyIsTooLarge() throws RequestTooLargeException {
        if (this.readCount + this.readRemaining > this.maxBody) {
            throw new RequestTooLargeException("request body " + (this.readCount + this.readRemaining) + "; max request body " + this.maxBody);
        }
    }

    public static enum State {
        ALL_READ,
        READ_INITIAL,
        READ_HEADER,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_FOOTER,
        READ_CHUNK_DELIMITER;

    }
}

