/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;

public class HttpsTest {
    public static void main(String[] args) throws IOException {
        HttpsURLConnection con = (HttpsURLConnection)new URL("https://github.com").openConnection();
        HttpsTest.print_https_cert(con);
        HttpsTest.print_content(con);
    }

    private static void print_content(HttpsURLConnection con) {
        if (con != null) {
            try {
                String input;
                System.out.println("****** Content of the URL ********");
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                while ((input = br.readLine()) != null) {
                    System.out.println(input);
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void print_https_cert(HttpsURLConnection con) {
        if (con != null) {
            try {
                Certificate[] certs;
                System.out.println("Response Code : " + con.getResponseCode());
                System.out.println("Cipher Suite : " + con.getCipherSuite());
                System.out.println("\n");
                for (Certificate cert : certs = con.getServerCertificates()) {
                    System.out.println("Cert Type : " + cert.getType());
                    System.out.println("Cert Hash Code : " + cert.hashCode());
                    System.out.println("Cert Public Key Algorithm : " + cert.getPublicKey().getAlgorithm());
                    System.out.println("Cert Public Key Format : " + cert.getPublicKey().getFormat());
                    System.out.println("\n");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

