/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class EncodingBenchmark {
    static final Charset ASCII = Charset.forName("ISO-8859-1");
    static final int TIMES = 1000000;
    static final int LOOP = 4;

    static byte[] getBytes(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            char c = s.charAt(i);
            bytes[i] = c >= '\u0080' ? 63 : (byte)s.charAt(i);
        }
        return bytes;
    }

    public static byte[] jdkGetBytes(String s) {
        try {
            return s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static void makeSureSame(String s) {
        byte[] jdkGetBytes;
        byte[] home = EncodingBenchmark.getBytes(s);
        if (home.length != (jdkGetBytes = EncodingBenchmark.jdkGetBytes(s)).length) {
            System.out.println("error");
        }
        for (int i = 0; i < jdkGetBytes.length; ++i) {
            if (home[i] == jdkGetBytes[i]) continue;
            System.out.println("-----------");
        }
    }

    private static String newString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    private static String jdkNewString(byte[] bytes) {
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static void testEncoding(String s) {
        int i;
        long time;
        int ji;
        byte[] bytes = EncodingBenchmark.jdkGetBytes(s);
        if (!EncodingBenchmark.newString(bytes).equals(EncodingBenchmark.jdkNewString(bytes))) {
            System.out.println("error");
        }
        for (ji = 0; ji < 4; ++ji) {
            time = System.currentTimeMillis();
            for (i = 0; i < 1000000; ++i) {
                EncodingBenchmark.newString(bytes);
            }
            System.out.println("decoding: home " + (System.currentTimeMillis() - time));
        }
        for (ji = 0; ji < 4; ++ji) {
            time = System.currentTimeMillis();
            for (i = 0; i < 1000000; ++i) {
                EncodingBenchmark.jdkNewString(bytes);
            }
            System.out.println("decoding: jdk string " + (System.currentTimeMillis() - time));
        }
        for (ji = 0; ji < 4; ++ji) {
            time = System.currentTimeMillis();
            for (i = 0; i < 1000000; ++i) {
                new String(bytes, ASCII);
            }
            System.out.println("decoding: jdk charset " + (System.currentTimeMillis() - time));
        }
    }

    public static void main(String[] args) {
        String s = "[2013-02-24 22:45:05 - BrowserActivity] Installing BrowserActivity.apk[2013-02-24 22:45:01 - BrowserActivity] Performing com.meiweisq.BrowserActivity activity launch[2013-02-24 22:45:18 - BrowserActivity] ActivityManager: Starting: Intent { act=android.intent.action.MAIN cat=[ xxx ] cmp=xxxx }";
        EncodingBenchmark.makeSureSame(s);
        EncodingBenchmark.testEncoding(s);
        EncodingBenchmark.testDecoding(s);
    }

    private static void testDecoding(String s) {
        int i;
        long time;
        int ji;
        for (ji = 0; ji < 4; ++ji) {
            time = System.currentTimeMillis();
            for (i = 0; i < 1000000; ++i) {
                EncodingBenchmark.jdkGetBytes(s);
            }
            System.out.println("encoding: jdk getBytes string " + (System.currentTimeMillis() - time));
        }
        for (ji = 0; ji < 4; ++ji) {
            time = System.currentTimeMillis();
            for (i = 0; i < 1000000; ++i) {
                EncodingBenchmark.getBytes(s);
            }
            System.out.println("encoding: home getBytes " + (System.currentTimeMillis() - time));
        }
    }
}

