/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.httpkit.DynamicBytes;
import org.httpkit.HttpUtils;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpServer;
import org.httpkit.server.LinkingRunnable;
import org.httpkit.server.ServerAtta;
import org.httpkit.ws.WSEncoder;
import org.httpkit.ws.WsServerAtta;

public class AsyncChannel {
    private final SelectionKey key;
    private final HttpServer server;
    public final AtomicReference<Boolean> closedRan = new AtomicReference<Boolean>(false);
    final AtomicReference<IFn> closeHandler = new AtomicReference<Object>(null);
    final AtomicReference<IFn> receiveHandler = new AtomicReference<Object>(null);
    private volatile boolean isHeaderSent = false;
    LinkingRunnable serialTask;
    private static final byte[] finalChunkBytes = "0\r\n\r\n".getBytes();
    private static final byte[] newLineBytes = "\r\n".getBytes();
    static Keyword K_BY_SERVER = Keyword.intern((String)"server-close");
    static Keyword K_CLIENT_CLOSED = Keyword.intern((String)"client-close");
    static Keyword K_WS_1000 = Keyword.intern((String)"normal");
    static Keyword K_WS_1001 = Keyword.intern((String)"going-away");
    static Keyword K_WS_1002 = Keyword.intern((String)"protocol-error");
    static Keyword K_WS_1003 = Keyword.intern((String)"unsupported");
    static Keyword K_UNKNOWN = Keyword.intern((String)"unknown");

    public AsyncChannel(SelectionKey key, HttpServer server) {
        this.key = key;
        this.server = server;
    }

    public void reset() {
        this.closedRan.lazySet(false);
        this.closeHandler.lazySet(null);
        this.receiveHandler.lazySet(null);
        this.isHeaderSent = false;
        this.serialTask = null;
    }

    private static ByteBuffer chunkSize(int size) {
        String s = Integer.toHexString(size) + "\r\n";
        return ByteBuffer.wrap(s.getBytes());
    }

    private void firstWrite(Object data, boolean close) throws IOException {
        ByteBuffer[] buffers;
        int status = 200;
        Object body = data;
        TreeMap<String, Object> headers = new TreeMap<String, String>();
        if (data instanceof Map) {
            Map resp = (Map)data;
            headers = ClojureRing.getHeaders(resp, false);
            status = ClojureRing.getStatus(resp);
            body = resp.get(ClojureRing.BODY);
        }
        if (headers.isEmpty()) {
            headers.put("Content-Type", "text/html; charset=utf-8");
        }
        if (close) {
            buffers = ClojureRing.encode(status, headers, body);
        } else {
            headers.put("Transfer-Encoding", "chunked");
            ByteBuffer[] bb = ClojureRing.encode(status, headers, body);
            buffers = body == null ? bb : new ByteBuffer[]{bb[0], AsyncChannel.chunkSize(bb[1].remaining()), bb[1], ByteBuffer.wrap(newLineBytes)};
        }
        if (close) {
            this.onClose(0);
        }
        this.write(buffers);
    }

    private void writeChunk(Object body, boolean close) throws IOException {
        ByteBuffer t;
        if (body instanceof Map) {
            body = ((Map)body).get(ClojureRing.BODY);
        }
        if (body != null && (t = HttpUtils.bodyBuffer(body)).hasRemaining()) {
            ByteBuffer size = AsyncChannel.chunkSize(t.remaining());
            ByteBuffer[] buffers = new ByteBuffer[]{size, t, ByteBuffer.wrap(newLineBytes)};
            this.write(buffers);
        }
        if (close) {
            this.serverClose(0);
        }
    }

    public void setReceiveHandler(IFn fn) {
        if (!this.receiveHandler.compareAndSet(null, fn)) {
            throw new IllegalStateException("receive handler exist: " + this.receiveHandler.get());
        }
    }

    public void messageReceived(Object mesg) {
        IFn f = this.receiveHandler.get();
        if (f != null) {
            f.invoke(mesg);
        }
    }

    public void sendHandshake(Map<String, Object> headers) {
        this.write(ClojureRing.encode(101, headers, null));
    }

    public void setCloseHandler(IFn fn) {
        if (!this.closeHandler.compareAndSet(null, fn)) {
            throw new IllegalStateException("close handler exist: " + this.closeHandler.get());
        }
        if (this.closedRan.get().booleanValue()) {
            fn.invoke((Object)K_UNKNOWN);
        }
    }

    public void onClose(int status) {
        IFn f;
        if (this.closedRan.compareAndSet(false, true) && (f = this.closeHandler.get()) != null) {
            f.invoke((Object)AsyncChannel.readable(status));
        }
    }

    public boolean serverClose(int status) {
        if (!this.closedRan.compareAndSet(false, true)) {
            return false;
        }
        if (this.isWebSocket()) {
            this.write(WSEncoder.encode((byte)8, ByteBuffer.allocate(2).putShort((short)status).array()));
        } else {
            this.write(ByteBuffer.wrap(finalChunkBytes));
        }
        IFn f = this.closeHandler.get();
        if (f != null) {
            f.invoke((Object)AsyncChannel.readable(0));
        }
        return true;
    }

    public boolean send(Object data, boolean close) throws IOException {
        if (this.closedRan.get().booleanValue()) {
            return false;
        }
        if (this.isWebSocket()) {
            Object tmp;
            if (data instanceof Map && (tmp = ((Map)data).get(ClojureRing.BODY)) != null) {
                data = tmp;
            }
            if (data instanceof String) {
                this.write(WSEncoder.encode((byte)1, ((String)data).getBytes(HttpUtils.UTF_8)));
            } else if (data instanceof byte[]) {
                this.write(WSEncoder.encode((byte)2, (byte[])data));
            } else if (data instanceof InputStream) {
                DynamicBytes bytes = HttpUtils.readAll((InputStream)data);
                this.write(WSEncoder.encode((byte)2, bytes.get(), bytes.length()));
            } else if (data != null) {
                throw new IllegalArgumentException("only accept string, byte[], InputStream, get" + data);
            }
            if (close) {
                this.serverClose(1000);
            }
        } else if (this.isHeaderSent) {
            this.writeChunk(data, close);
        } else {
            this.isHeaderSent = true;
            this.firstWrite(data, close);
        }
        return true;
    }

    public String toString() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return s.getLocalSocketAddress() + "<->" + s.getRemoteSocketAddress();
    }

    private void write(ByteBuffer ... buffers) {
        ((ServerAtta)this.key.attachment()).addBuffer(buffers);
        this.server.queueWrite(this.key);
    }

    public boolean isWebSocket() {
        return this.key.attachment() instanceof WsServerAtta;
    }

    public boolean isClosed() {
        return this.closedRan.get();
    }

    private static Keyword readable(int status) {
        switch (status) {
            case 0: {
                return K_BY_SERVER;
            }
            case -1: {
                return K_CLIENT_CLOSED;
            }
            case 1000: {
                return K_WS_1000;
            }
            case 1001: {
                return K_WS_1001;
            }
            case 1002: {
                return K_WS_1002;
            }
            case 1003: {
                return K_WS_1003;
            }
        }
        return K_UNKNOWN;
    }
}

