/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit;

import java.nio.charset.Charset;
import java.util.Arrays;

public class DynamicBytes {
    private byte[] data;
    private int idx = 0;

    public DynamicBytes(int size) {
        this.data = new byte[size];
    }

    private void expandIfNeeded(int more) {
        if (this.idx + more > this.data.length) {
            int after = (int)((double)(this.idx + more) * 1.33);
            this.data = Arrays.copyOf(this.data, after);
        }
    }

    public byte[] get() {
        return this.data;
    }

    public int length() {
        return this.idx;
    }

    public DynamicBytes append(byte b) {
        this.expandIfNeeded(1);
        this.data[this.idx++] = b;
        return this;
    }

    public String toString() {
        return "DynamicBytes[len=" + this.idx + ", cap=" + this.data.length + ']';
    }

    public DynamicBytes append(byte[] d, int length) {
        this.expandIfNeeded(length);
        System.arraycopy(d, 0, this.data, this.idx, length);
        this.idx += length;
        return this;
    }

    public DynamicBytes append(String str) {
        int length = str.length();
        this.expandIfNeeded(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            this.data[this.idx++] = c < '\u0080' ? (int)c : 63;
        }
        return this;
    }

    public DynamicBytes append(String str, Charset c) {
        byte[] bs = str.getBytes(c);
        return this.append(bs, bs.length);
    }
}

