(ns playground
  (:use casyn.core)
  (:require [casyn.core :as c]
            [lamina.core :as lc]))

(def ks "casyn_test_ks")
(def cf "test_cf")
(def ccf "counter_cf")


;; (defschema ts :row :bytes :columns {:default [[:bytes :int] :long]})

 ;; (def c (c/make-cluster "localhost" 9160 "models"
 ;;                         ;; :failover :try-all
 ;;                         ;; :pool {:max-active 12 :max-idle 12 :max-total 12}
 ;;                         ))

;; (def x (c/client-fn c))


;; (println(do
;;    (x increment "DailyCount" "PP11" (composite ["tar-17" (int 1721)]) 17)))

;; ;; (println (composite-expression [:gt? "tar-17"]))


;; (prn  @(x get-slice "DailyCount" "PP11"
;;           :start (composite-expression [:eq? "tar-17"] [:eq? (int 1716)])
;;           :finish (composite-expression [:eq? "tar-17"] [:eq? (int 1720)])
;;           :schema ts :as :map))


;; (prn @(x get-row "DailyCount" "PP11":schema ts))

(println :addks)

;; (prn (c/make-client))

(try
  @(c/add-keyspace (c/make-client)
                   ks
                   "SimpleStrategy"
                   [[cf
                     :column-metadata [[:n0 :utf-8]
                                       [:n1 :utf-8 :n1_index :utf-8]
                                       [:n2 :long :n2_index :long]]]
                    [ccf
                     :default-validation-class :counter
                     :replicate-on-write true]]
                   :strategy-options {"replication_factor" "1"})

  (catch Exception e nil))
(println :addksok)




(c/defschema test-schema
  :row :utf-8
  :super :utf-8
  :columns
  {:default [:utf-8 :utf-8]
   :exceptions {"age" :long}})

(def cl (c/make-cluster "localhost" 9160 ks
                        :failover :try-all
                        :auto-discovery false
                        ;; :pool {:max-active 12 :max-idle 12 :max-total 12}
                        ))
(println :make-clusterok)
(prn cl)
(prn (.nodes (.balancer cl)))

(def client-x (c/client-fn cl))


(prn @(client-x c/insert-column
                cf
                "1"
                "n1" "col-value"))

(prn @(client-x c/insert-column
                cf
                "1"
                "n2" 123123))

(prn @(client-x c/insert-column
                cf
                "1"
                "n3" 123))



(def t @(client-x execute-cql-query "SELECT * FROM test_cf;"))

;; (prn (.default_name_type (:schema (meta t))))


(println   @(client-x execute-cql-query "SELECT * FROM test_cf;"))


;; (prn client-x)

;; (prn (.nodes (.balancer cl)))

;; (use 'casyn.auto-discovery)

;; (prn (cp/refresh cl (prn (discover cl))))
;; ;; (connection/close  client-pool)

;; (prn @(client-x c/insert-column
;;                 cf
;;                 "1"
;;                 "col-name" "col-value"))



;; (prn
;;  @(client-x c/get-column
;;             cf
;;             "1"
;;             "col-name"))


;; ;; (println @(lc/run-pipeline
;; ;;            (client-x c/insert-column
;; ;;                      cf
;; ;;                      "1"
;; ;;                      "col-name" "col-value")

;; ;;          (fn [_]
;; ;;            @(client-x c/get-column
;; ;;                       cf
;; ;;                       "1"
;; ;;                       "col-name")

;; ;;            )
;; ;;          ))

;; (time
;;  (dotimes [d 20000]
;;    (client-x c/insert-column
;;               cf
;;               "1"
;;               "col-name" "col-value")))

;; ;; (println @(lc/run-pipeline
;; ;;   (client-x c/insert-column
;; ;;             cf
;; ;;             "1"
;; ;;             "col-name" "col-value")
;; ;;   (fn [asdf]
;; ;;     (println @(client-x c/get-column
;; ;;                         cf
;; ;;                         "1"
;; ;;                         "col-name")))))
