(ns qbits.caffeine
  (:refer-clojure :exclude [get])
  (:require
   [qbits.caffeine.utils :as u]
   [qbits.caffeine.options :as options])
  (:import
   (com.github.benmanes.caffeine.cache
    Cache
    Caffeine
    LoadingCache
    CacheLoader)))

(defn ^CacheLoader cache-loader [f]
  (reify CacheLoader
    (load [this k]
      (f k))))

(defn make
  (^LoadingCache [options f]
   (-> (Caffeine/newBuilder)
       (options/set-cache-options! options)
       (.build (cache-loader f))))
  (^Cache [options]
   (-> (Caffeine/newBuilder)
       (options/set-cache-options! options)
       (.build))))

(defn get
  ([^LoadingCache c k f]
   (.get c k (u/func f)))
  ([^Cache c k]
   (get c k nil)))

(defn cleanup!
  [^Cache c]
  (.cleanUp c))

(defn estimated-size [^Cache c]
  (.estimatedSize c))

(defn get-all-present [^Cache c ks]
  (.getAllPresent c ks))

(defn get-if-present [^Cache c k]
  (.getIfPresent c k))

(defn invalidate!
  ([^Cache c]
   (.invalidateAll c))
  ([^Cache c k]
   (.invalidate c k)))

(defn policy [^Cache c]
  (.policy c))

(defn put! [^Cache c k v]
  (.put c k v))

(defn put-all! [^Cache c m]
  (.putAll c m))

(defn stats [^Cache c]
  (.stats c))

;; loading cache specific
(defn get-all [^LoadingCache c k]
  (.getAll c k))

(defn refresh! [^LoadingCache c k]
  (.refresh c k))
