(def project-version "3.1.0")
(defproject cc.qbits/alia-all "3.1.0"
  :description "Cassandra CQL3 client for Clojure - datastax/java-driver wrapper"
  :url "https://github.com/mpenet/alia"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[cc.qbits/alia ~project-version]
                 [cc.qbits/alia-manifold ~project-version]
                 [cc.qbits/alia-async ~project-version]
                 [cc.qbits/alia-joda-time ~project-version]
                 [cc.qbits/alia-nippy ~project-version]
                 [cc.qbits/alia-eaio-uuid ~project-version]]
  :profiles {:dev  {:dependencies [[org.xerial.snappy/snappy-java "1.0.5"]
                                   [cc.qbits/hayt "3.0.1"]
                                   [net.jpountz.lz4/lz4 "1.2.0"]
                                   [clj-time "0.11.0"]
                                   [com.taoensso/nippy "2.9.0"]
                                   [cc.qbits/tardis "1.0.0"]
                                   [codox "0.9.1"]
                                   [manifold "0.1.2"]
                                   [org.slf4j/slf4j-log4j12 "1.7.3"]]}}
  :sub ["libs/alia"
        "libs/alia-manifold"
        "libs/alia-async"
        "libs/alia-joda-time"
        "libs/alia-nippy"
        "libs/alia-eaio-uuid"]
  :jar-exclusions [#"log4j.properties"]
  :codox {:source-uri "https://github.com/mpenet/alia/blob/master/{filepath}#L{line}"
          :metadata {:doc/format :markdown}
          :namespaces :all}
  :global-vars {*warn-on-reflection* true})
