(ns geppetto.repeat
  (:use [geppetto.runs])
  (:use [geppetto.records])
  (:use [geppetto.parameters]))

(defn repeat-run
  [runid run-fn datadir git recordsdir nthreads]
  (let [run (get-run runid)
        params-string (format "{:control %s :comparison %s}"
                         (prn-str (:control run))
                         (prn-str (:comparison run)))]
    (println run)
    (println (explode-params (vectorize-params (:control (read-params params-string)))))
    (println (run-with-new-record run-fn params-string
               datadir (:seed run) git recordsdir nthreads
               (:repetitions run) false false true))))
