(ns leiningen.new.cbilson-web-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "cbilson-web-app"))

(defn cbilson-web-app
  "Create an om+compojure application"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' cbilson-web-app project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore" data)]

             ["src/{{sanitized}}/app.clj" (render "app.clj" data)]

             ["src-cljs/{{sanitized}}/app.cljs" (render "app.cljs" data)]
             ["src-cljs/{{sanitized}}/util.cljs" (render "util.cljs" data)]

             ["resources/public/index.html" (render "index.html" data)]
             ["resources/public/css/foundation.min.css" (render "foundation.min.css" data)]
             ["resources/public/css/app.css" (render "app.css" data)]

             ["dev/user.clj" (render "user.clj" data)]
             ["dev/user.cljs" (render "user.cljs" data)])))
