/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.util.EventDispatcher;

public class EventDispatcherImpl
implements EventDispatcher {
    private boolean _ignore = false;
    private final Map<String, Object> _events = new ConcurrentHashMap<String, Object>(4);
    private final List<EventDispatcher> _attached = new CopyOnWriteArrayList<EventDispatcher>();

    @Override
    public EventDispatcher getEventDispatcher() {
        return this;
    }

    @Override
    public void attachEventDispatcher(EventDispatcher ev) {
        if (ev == null) {
            return;
        }
        this._attached.add(ev);
    }

    @Override
    public void detachEventDispatcher(EventDispatcher ev) {
        if (ev == null) {
            return;
        }
        this._attached.remove(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEvent(String eventName, Object args) {
        if (this._ignore) {
            return;
        }
        if (args == null) {
            args = "[null value]";
        }
        this._events.put(eventName, args);
        Map<String, Object> map = this._events;
        synchronized (map) {
            this._events.notifyAll();
        }
        for (EventDispatcher e : this._attached) {
            e.notifyEvent(eventName, args);
        }
    }

    @Override
    public Object getEventValue(String name) {
        if (this._ignore) {
            return null;
        }
        return this._events.get(name);
    }

    @Override
    public Set<String> getEvents() {
        if (this._ignore) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this._events.keySet());
    }

    @Override
    public void ignoreEvents() {
        this._ignore = true;
        this._events.clear();
    }

    @Override
    public void unIgnoreEvents() {
        this._ignore = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object waitEventValue(String name) {
        if (this._ignore) {
            return null;
        }
        while (true) {
            Map<String, Object> map = this._events;
            synchronized (map) {
                Object val = this._events.get(name);
                if (val != null) {
                    return val;
                }
                try {
                    this._events.wait(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }
}

