/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;

public class ConvertToHash {
    public static Hash getHash(String peer) {
        Destination d;
        byte[] b;
        if (peer == null) {
            return null;
        }
        String peerLC = peer.toLowerCase(Locale.US);
        if (peer.length() == 44 && !peerLC.endsWith(".i2p") && (b = Base64.decode(peer)) != null && b.length == 32) {
            return Hash.create(b);
        }
        if (peer.length() == 48 && peerLC.endsWith(".i2p") && (b = Base64.decode(peer.substring(0, 44))) != null && b.length == 32) {
            return Hash.create(b);
        }
        if (peer.length() >= 520 && peerLC.endsWith(".i2p")) {
            try {
                d = new Destination();
                d.fromBase64(peer.substring(0, peer.length() - 4));
                return d.calculateHash();
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        if (peer.length() >= 516 && !peerLC.endsWith(".i2p")) {
            try {
                d = new Destination();
                d.fromBase64(peer);
                return d.calculateHash();
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        if (peer.length() == 60 && peerLC.endsWith(".b32.i2p") && (b = Base32.decode(peer.substring(0, 52))) != null && b.length == 32) {
            return Hash.create(b);
        }
        if (peer.length() == 52 && !peerLC.endsWith(".i2p") && (b = Base32.decode(peer)) != null && b.length == 32) {
            return Hash.create(b);
        }
        d = I2PAppContext.getGlobalContext().namingService().lookup(peer);
        if (d != null) {
            return d.calculateHash();
        }
        return null;
    }
}

