/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;

public abstract class Addresses {
    private static final Map<String, byte[]> _IPAddress;

    public static boolean isConnected() {
        return !Addresses.getAddresses(true, false, false).isEmpty();
    }

    public static String getAnyAddress() {
        SortedSet<String> a = Addresses.getAddresses();
        if (!a.isEmpty()) {
            return a.first();
        }
        return null;
    }

    public static SortedSet<String> getAddresses() {
        return Addresses.getAddresses(false, false);
    }

    public static SortedSet<String> getAllAddresses() {
        return Addresses.getAddresses(true, true);
    }

    public static SortedSet<String> getAddresses(boolean includeLocal, boolean includeIPv6) {
        return Addresses.getAddresses(includeLocal, includeLocal, includeIPv6);
    }

    public static SortedSet<String> getAddresses(boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        boolean haveIPv4 = false;
        boolean haveIPv6 = false;
        TreeSet<String> rv = new TreeSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (int i = 0; i < allMyIps.length; ++i) {
                    if (allMyIps[i] instanceof Inet4Address) {
                        haveIPv4 = true;
                    } else {
                        haveIPv6 = true;
                    }
                    if (!Addresses.shouldInclude(allMyIps[i], includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                    rv.add(Addresses.stripScope(allMyIps[i].getHostAddress()));
                }
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            if (ifcs != null) {
                while (ifcs.hasMoreElements()) {
                    NetworkInterface ifc = ifcs.nextElement();
                    Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        if (addr instanceof Inet4Address) {
                            haveIPv4 = true;
                        } else {
                            haveIPv6 = true;
                        }
                        if (!Addresses.shouldInclude(addr, includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                        rv.add(Addresses.stripScope(addr.getHostAddress()));
                    }
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (includeLoopbackAndWildcard) {
            if (haveIPv4) {
                rv.add("0.0.0.0");
            }
            if (includeIPv6 && haveIPv6) {
                rv.add("0:0:0:0:0:0:0:0");
            }
        }
        return rv;
    }

    private static String stripScope(String ip) {
        int pct = ip.indexOf("%");
        if (pct > 0) {
            ip = ip.substring(0, pct);
        }
        return ip;
    }

    private static boolean shouldInclude(InetAddress ia, boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        return !(ia.isLinkLocalAddress() || ia.isMulticastAddress() || !includeLoopbackAndWildcard && (ia.isAnyLocalAddress() || ia.isLoopbackAddress()) || !includeSiteLocal && (ia.isSiteLocalAddress() || ia.getAddress().length == 16 && (ia.getAddress()[0] & 0xFE) == 252) || !includeIPv6 && !(ia instanceof Inet4Address));
    }

    public static String toString(byte[] addr) {
        if (addr == null) {
            return "null";
        }
        try {
            return InetAddress.getByAddress(addr).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return "bad IP length " + addr.length;
        }
    }

    public static String toString(byte[] addr, int port) {
        if (addr == null) {
            return "null:" + port;
        }
        try {
            String ip = InetAddress.getByAddress(addr).getHostAddress();
            if (addr.length != 16) {
                return ip + ':' + port;
            }
            return '[' + ip + "]:" + port;
        }
        catch (UnknownHostException uhe) {
            return "(bad IP length " + addr.length + "):" + port;
        }
    }

    public static int getPort(String port) {
        int rv = 0;
        if (port != null) {
            try {
                int iport = Integer.parseInt(port);
                if (iport > 0 && iport <= 65535) {
                    rv = iport;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(String host) {
        byte[] rv;
        block11: {
            if (host == null) {
                return null;
            }
            Map<String, byte[]> map = _IPAddress;
            synchronized (map) {
                rv = _IPAddress.get(host);
            }
            if (rv == null) {
                try {
                    boolean isIPv4;
                    boolean bl = isIPv4 = host.replaceAll("[0-9\\.]", "").length() == 0;
                    if (isIPv4 && host.replaceAll("[0-9]", "").length() != 3) {
                        return null;
                    }
                    rv = InetAddress.getByName(host).getAddress();
                    if (!isIPv4 && host.replaceAll("[0-9a-fA-F:]", "").length() != 0) break block11;
                    Map<String, byte[]> map2 = _IPAddress;
                    synchronized (map2) {
                        _IPAddress.put(host, rv);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<String, byte[]> map = _IPAddress;
        synchronized (map) {
            _IPAddress.clear();
        }
    }

    public static void main(String[] args) {
        System.err.println("External IPv4 Addresses:");
        SortedSet<String> a = Addresses.getAddresses(false, false, false);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("\nExternal and Local IPv4 Addresses:");
        a = Addresses.getAddresses(true, false, false);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("\nAll External Addresses:");
        a = Addresses.getAddresses(false, false, true);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("\nAll External and Local Addresses:");
        a = Addresses.getAddresses(true, false, true);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("\nAll addresses:");
        a = Addresses.getAddresses(true, true, true);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("\nIs connected? " + Addresses.isConnected());
    }

    static {
        int size;
        I2PAppContext ctx = I2PAppContext.getCurrentContext();
        if (ctx != null && ctx.isRouterContext()) {
            long maxMemory = SystemVersion.getMaxMemory();
            long min = 128L;
            long max = 4096L;
            size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 262144L));
        } else {
            size = 32;
        }
        _IPAddress = new LHMCache<String, byte[]>(size);
    }
}

