/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;

class MessageStatusMessageHandler
extends HandlerImpl {
    public MessageStatusMessageHandler(I2PAppContext context) {
        super(context, 22);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        MessageStatusMessage msg = (MessageStatusMessage)message;
        int status = msg.getStatus();
        long id = msg.getMessageId();
        switch (status) {
            case 0: {
                ReceiveMessageBeginMessage m = new ReceiveMessageBeginMessage();
                m.setMessageId(id);
                m.setSessionId(msg.getSessionId());
                try {
                    session.sendMessage(m);
                }
                catch (I2PSessionException ise) {
                    this._log.error("Error asking for the message", ise);
                }
                return;
            }
            case 1: {
                session.receiveStatus((int)id, msg.getNonce(), status);
                return;
            }
        }
        if (msg.isSuccessful()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Message delivery succeeded for message " + id);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Message delivery FAILED (" + status + ") for message " + id);
        }
        session.receiveStatus((int)id, msg.getNonce(), status);
    }
}

