/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.i2p.I2PAppContext;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.util.Log;

public class I2PSSLSocketFactory {
    public static final List<String> EXCLUDE_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
    public static final List<String> INCLUDE_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
    public static final List<String> EXCLUDE_CIPHERS = Collections.unmodifiableList(Arrays.asList("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_DH_anon_WITH_AES_128_GCM_SHA256", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA256", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_RSA_WITH_NULL_SHA256", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA"));
    public static final List<String> INCLUDE_CIPHERS = Collections.emptyList();
    private final SSLSocketFactory _factory;

    public I2PSSLSocketFactory(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        this._factory = I2PSSLSocketFactory.initSSLContext(context, loadSystemCerts, relativeCertPath);
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket rv = (SSLSocket)this._factory.createSocket(host, port);
        I2PSSLSocketFactory.setProtocolsAndCiphers(rv);
        return rv;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket rv = (SSLSocket)this._factory.createSocket(host, port);
        I2PSSLSocketFactory.setProtocolsAndCiphers(rv);
        return rv;
    }

    private static SSLSocketFactory initSSLContext(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        int adds;
        KeyStore ks;
        Log log = context.logManager().getLog(I2PSSLSocketFactory.class);
        if (loadSystemCerts) {
            ks = KeyStoreUtil.loadSystemKeyStore();
            if (ks == null) {
                throw new GeneralSecurityException("Key Store init error");
            }
        } else {
            try {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, "".toCharArray());
            }
            catch (IOException ioe) {
                throw new GeneralSecurityException("Key Store init error", ioe);
            }
        }
        File dir = new File(context.getConfigDir(), relativeCertPath);
        int totalAdds = adds = KeyStoreUtil.addCerts(dir, ks);
        if (adds > 0 && log.shouldLog(20)) {
            log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        File dir2 = new File(context.getBaseDir(), relativeCertPath);
        if (!dir.getAbsolutePath().equals(dir2.getAbsolutePath())) {
            adds = KeyStoreUtil.addCerts(dir2, ks);
            totalAdds += adds;
            if (adds > 0 && log.shouldLog(20)) {
                log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (totalAdds > 0 || loadSystemCerts) {
            if (log.shouldLog(20)) {
                log.info("Loaded total of " + totalAdds + " new trusted certificates");
            }
        } else {
            String msg = "No trusted certificates loaded (looked in " + dir.getAbsolutePath() + (dir.getAbsolutePath().equals(dir2.getAbsolutePath()) ? "" : " and " + dir2.getAbsolutePath()) + ", SSL connections will fail. " + "Copy the cert in " + relativeCertPath + " from the router to the directory.";
            throw new GeneralSecurityException(msg);
        }
        SSLContext sslc = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        sslc.init(null, tmf.getTrustManagers(), context.random());
        return sslc.getSocketFactory();
    }

    public static void setProtocolsAndCiphers(SSLSocket socket) {
        socket.setEnabledProtocols(I2PSSLSocketFactory.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        socket.setEnabledCipherSuites(I2PSSLSocketFactory.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
    }

    public static void setProtocolsAndCiphers(SSLServerSocket socket) {
        String[] p = I2PSSLSocketFactory.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols());
        for (int i = 0; i < p.length; ++i) {
            if (!p.equals("SSLv3")) continue;
            return;
        }
        socket.setEnabledProtocols(p);
        socket.setEnabledCipherSuites(I2PSSLSocketFactory.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
    }

    private static String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        return I2PSSLSocketFactory.select(enabledProtocols, supportedProtocols, INCLUDE_PROTOCOLS, EXCLUDE_PROTOCOLS);
    }

    private static String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        return I2PSSLSocketFactory.select(enabledCipherSuites, supportedCipherSuites, INCLUDE_CIPHERS, EXCLUDE_CIPHERS);
    }

    private static String[] select(String[] enabledArr, String[] supportedArr, List<String> toEnable, List<String> toExclude) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PSSLSocketFactory.class);
        HashSet<String> selected = new HashSet<String>(enabledArr.length);
        selected.addAll(Arrays.asList(enabledArr));
        selected.removeAll(toExclude);
        HashSet<String> supported = new HashSet<String>(supportedArr.length);
        supported.addAll(Arrays.asList(supportedArr));
        for (String s : toEnable) {
            if (supported.contains(s)) {
                if (!selected.add(s) || !log.shouldLog(20)) continue;
                log.info("Added, previously disabled: " + s);
                continue;
            }
            if (!log.shouldLog(20)) continue;
            log.info("Not supported in this JVM: " + s);
        }
        if (selected.isEmpty()) {
            log.logAlways(30, "No TLS support for SSLEepGet, falling back");
            return enabledArr;
        }
        if (log.shouldLog(10)) {
            ArrayList foo = new ArrayList(selected);
            Collections.sort(foo);
            log.debug("Selected: " + foo);
        }
        return selected.toArray(new String[selected.size()]);
    }
}

