/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.util.Arrays;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;

public class SigningPrivateKey
extends SimpleDataStructure {
    private static final SigType DEF_TYPE = SigType.DSA_SHA1;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPrivkeyLen();
    private final SigType _type;

    public SigningPrivateKey() {
        this(DEF_TYPE);
    }

    public SigningPrivateKey(SigType type) {
        this._type = type;
    }

    public SigningPrivateKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public SigningPrivateKey(SigType type, byte[] data) {
        this._type = type;
        this.setData(data);
    }

    public SigningPrivateKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        return this._type.getPrivkeyLen();
    }

    public SigType getType() {
        return this._type;
    }

    public SigningPublicKey toPublic() {
        return KeyGenerator.getSigningPublicKey(this);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(' ').append((Object)this._type).append(": ");
        int length = this.length();
        if (this._data == null) {
            buf.append("null");
        } else if (length <= 32) {
            buf.append(this.toBase64());
        } else {
            buf.append("size: ").append(Integer.toString(length));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return DataHelper.hashCode((Object)this._type) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SigningPrivateKey)) {
            return false;
        }
        SigningPrivateKey s = (SigningPrivateKey)obj;
        return this._type == s._type && Arrays.equals(this._data, s._data);
    }
}

