/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.client.naming.HostsTxtNamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.client.naming.NamingServiceUpdater;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public abstract class NamingService {
    protected final Log _log;
    protected final I2PAppContext _context;
    protected final Set<NamingServiceListener> _listeners;
    protected final Set<NamingServiceUpdater> _updaters;
    public static final String PROP_IMPL = "i2p.naming.impl";
    private static final String DEFAULT_IMPL = "net.i2p.client.naming.BlockfileNamingService";
    private static final String BACKUP_IMPL = "net.i2p.client.naming.HostsTxtNamingService";

    protected NamingService(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._listeners = new CopyOnWriteArraySet<NamingServiceListener>();
        this._updaters = new CopyOnWriteArraySet<NamingServiceUpdater>();
    }

    public Destination lookup(String hostname) {
        return this.lookup(hostname, null, null);
    }

    public String reverseLookup(Destination dest) {
        return this.reverseLookup(dest, null);
    }

    public String reverseLookup(Hash h) {
        return null;
    }

    protected Destination lookupBase64(String hostname) {
        try {
            Destination result = new Destination();
            result.fromBase64(hostname);
            return result;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad B64 dest [" + hostname + "]", dfe);
            }
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Properties getConfiguration() {
        return null;
    }

    public boolean setConfiguration(Properties p) {
        return true;
    }

    public List<NamingService> getNamingServices() {
        return null;
    }

    public NamingService getParent() {
        return null;
    }

    public boolean addNamingService(NamingService ns) {
        return this.addNamingService(ns, false);
    }

    public boolean addNamingService(NamingService ns, boolean head) {
        return false;
    }

    public boolean removeNamingService(NamingService ns) {
        return false;
    }

    public int size() {
        return this.size(null);
    }

    public int size(Properties options) {
        return -1;
    }

    public Map<String, Destination> getEntries() {
        return this.getEntries(null);
    }

    public Map<String, Destination> getEntries(Properties options) {
        return Collections.emptyMap();
    }

    public Map<String, String> getBase64Entries(Properties options) {
        return Collections.emptyMap();
    }

    public Set<String> getNames() {
        return this.getNames(null);
    }

    public Set<String> getNames(Properties options) {
        return Collections.emptySet();
    }

    public boolean put(String hostname, Destination d) {
        return this.put(hostname, d, null);
    }

    public boolean put(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean putIfAbsent(String hostname, Destination d) {
        return this.putIfAbsent(hostname, d, null);
    }

    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean putAll(Map<String, Destination> entries, Properties options) {
        boolean rv = true;
        for (Map.Entry<String, Destination> entry : entries.entrySet()) {
            if (this.put(entry.getKey(), entry.getValue(), options)) continue;
            rv = false;
        }
        return rv;
    }

    public boolean update(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean remove(String hostname) {
        return this.remove(hostname, null);
    }

    public boolean remove(String hostname, Properties options) {
        return false;
    }

    public void requestUpdate(Properties options) {
        for (NamingServiceUpdater nsu : this._updaters) {
            nsu.update(options);
        }
    }

    public void registerListener(NamingServiceListener nsl) {
        this._listeners.add(nsl);
    }

    public void unregisterListener(NamingServiceListener nsl) {
        this._listeners.remove(nsl);
    }

    public void registerUpdater(NamingServiceUpdater nsu) {
        this._updaters.add(nsu);
    }

    public void unregisterUpdater(NamingServiceUpdater nsu) {
        this._updaters.remove(nsu);
    }

    public abstract Destination lookup(String var1, Properties var2, Properties var3);

    public String reverseLookup(Destination d, Properties options) {
        return null;
    }

    public Destination lookupBase32(String hostname, int timeout) {
        return null;
    }

    public Destination lookup(Hash hash, int timeout) {
        return null;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public static final synchronized NamingService createInstance(I2PAppContext context) {
        NamingService instance = null;
        String impl = context.getProperty(PROP_IMPL, DEFAULT_IMPL);
        try {
            Class<?> cls = Class.forName(impl);
            Constructor<?> con = cls.getConstructor(I2PAppContext.class);
            instance = (NamingService)con.newInstance(context);
        }
        catch (Exception ex) {
            Log log = context.logManager().getLog(NamingService.class);
            if (!impl.equals(BACKUP_IMPL)) {
                log.error("Cannot load naming service " + impl + ", using HostsTxtNamingService", ex);
                instance = new HostsTxtNamingService(context);
            }
            log.error("Cannot load naming service " + impl + ", only .b32.i2p lookups will succeed", ex);
            instance = new DummyNamingService(context);
        }
        return instance;
    }
}

