/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.util.ResettableGZIPOutputStream;
import net.i2p.util.SystemVersion;

public class ReusableGZIPOutputStream
extends ResettableGZIPOutputStream {
    private static final boolean ENABLE_CACHING = !SystemVersion.isApache() && !SystemVersion.isAndroid();
    private static final LinkedBlockingQueue<ReusableGZIPOutputStream> _available = ENABLE_CACHING ? new LinkedBlockingQueue(16) : null;
    private final ByteArrayOutputStream _buffer;

    public static ReusableGZIPOutputStream acquire() {
        ReusableGZIPOutputStream rv = null;
        if (ENABLE_CACHING) {
            rv = _available.poll();
        }
        if (rv == null) {
            rv = new ReusableGZIPOutputStream();
        }
        return rv;
    }

    public static void release(ReusableGZIPOutputStream out) {
        out.reset();
        if (ENABLE_CACHING) {
            _available.offer(out);
        }
    }

    private ReusableGZIPOutputStream() {
        super(new ByteArrayOutputStream(40960));
        this._buffer = (ByteArrayOutputStream)this.out;
    }

    @Override
    public void reset() {
        super.reset();
        this._buffer.reset();
        this.def.setLevel(9);
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public byte[] getData() {
        return this._buffer.toByteArray();
    }
}

