/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.Hash384;
import net.i2p.crypto.Hash512;
import net.i2p.crypto.RSAConstants;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SHA1Hash;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.data.Hash;
import net.i2p.data.SimpleDataStructure;

public enum SigType {
    DSA_SHA1(0, 128, 20, 20, 40, SigAlgo.DSA, "SHA-1", "SHA1withDSA", CryptoConstants.DSA_SHA1_SPEC, "0"),
    ECDSA_SHA256_P256(1, 64, 32, 32, 64, SigAlgo.EC, "SHA-256", "SHA256withECDSA", ECConstants.P256_SPEC, "0.9.12"),
    ECDSA_SHA384_P384(2, 96, 48, 48, 96, SigAlgo.EC, "SHA-384", "SHA384withECDSA", ECConstants.P384_SPEC, "0.9.12"),
    ECDSA_SHA512_P521(3, 132, 66, 64, 132, SigAlgo.EC, "SHA-512", "SHA512withECDSA", ECConstants.P521_SPEC, "0.9.12"),
    RSA_SHA256_2048(4, 256, 512, 32, 256, SigAlgo.RSA, "SHA-256", "SHA256withRSA", RSAConstants.F4_2048_SPEC, "0.9.12"),
    RSA_SHA384_3072(5, 384, 768, 48, 384, SigAlgo.RSA, "SHA-384", "SHA384withRSA", RSAConstants.F4_3072_SPEC, "0.9.12"),
    RSA_SHA512_4096(6, 512, 1024, 64, 512, SigAlgo.RSA, "SHA-512", "SHA512withRSA", RSAConstants.F4_4096_SPEC, "0.9.12"),
    EdDSA_SHA512_Ed25519(7, 32, 32, 64, 64, SigAlgo.EdDSA, "SHA-512", "SHA512withEdDSA", EdDSANamedCurveTable.getByName("ed25519-sha-512"), "0.9.17");

    private final int code;
    private final int pubkeyLen;
    private final int privkeyLen;
    private final int hashLen;
    private final int sigLen;
    private final SigAlgo base;
    private final String digestName;
    private final String algoName;
    private final String since;
    private final AlgorithmParameterSpec params;
    private final boolean isAvail;
    private static final Map<Integer, SigType> BY_CODE;

    private SigType(int cod, int pubLen, int privLen, int hLen, int sLen, SigAlgo baseAlgo, String mdName, String aName, AlgorithmParameterSpec pSpec, String supportedSince) {
        this.code = cod;
        this.pubkeyLen = pubLen;
        this.privkeyLen = privLen;
        this.hashLen = hLen;
        this.sigLen = sLen;
        this.base = baseAlgo;
        this.digestName = mdName;
        this.algoName = aName;
        this.params = pSpec;
        this.since = supportedSince;
        this.isAvail = this.x_isAvailable();
    }

    public int getCode() {
        return this.code;
    }

    public int getPubkeyLen() {
        return this.pubkeyLen;
    }

    public int getPrivkeyLen() {
        return this.privkeyLen;
    }

    public int getHashLen() {
        return this.hashLen;
    }

    public int getSigLen() {
        return this.sigLen;
    }

    public SigAlgo getBaseAlgorithm() {
        return this.base;
    }

    public String getAlgorithmName() {
        return this.algoName;
    }

    public AlgorithmParameterSpec getParams() throws InvalidParameterSpecException {
        if (this.params == null) {
            throw new InvalidParameterSpecException(this.toString() + " is not available in this JVM");
        }
        return this.params;
    }

    public MessageDigest getDigestInstance() {
        if (this.digestName.equals("SHA-1")) {
            return SHA1.getInstance();
        }
        if (this.digestName.equals("SHA-256")) {
            return SHA256Generator.getDigestInstance();
        }
        try {
            return MessageDigest.getInstance(this.digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public SimpleDataStructure getHashInstance() {
        switch (this.getHashLen()) {
            case 20: {
                return new SHA1Hash();
            }
            case 32: {
                return new Hash();
            }
            case 48: {
                return new Hash384();
            }
            case 64: {
                return new Hash512();
            }
        }
        throw new UnsupportedOperationException("Unsupported hash length: " + this.getHashLen());
    }

    public String getSupportedSince() {
        return this.since;
    }

    public boolean isAvailable() {
        return this.isAvail;
    }

    private boolean x_isAvailable() {
        if (DSA_SHA1 == this) {
            return true;
        }
        try {
            this.getParams();
            if (this.getBaseAlgorithm() != SigAlgo.EdDSA) {
                Signature.getInstance(this.getAlgorithmName());
            }
            this.getDigestInstance();
            this.getHashInstance();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isAvailable(int code) {
        SigType type = SigType.getByCode(code);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public static boolean isAvailable(String stype) {
        SigType type = SigType.parseSigType(stype);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public static SigType getByCode(int code) {
        return BY_CODE.get(code);
    }

    public static SigType parseSigType(String stype) {
        try {
            String uc = stype.toUpperCase(Locale.US);
            if (uc.equals("EDDSA_SHA512_ED25519")) {
                return EdDSA_SHA512_Ed25519;
            }
            return SigType.valueOf(uc);
        }
        catch (IllegalArgumentException iae) {
            try {
                int code = Integer.parseInt(stype);
                return SigType.getByCode(code);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    static {
        BY_CODE = new HashMap<Integer, SigType>();
        for (SigType type : SigType.values()) {
            if (BY_CODE.put(type.getCode(), type) == null) continue;
            throw new IllegalStateException("Duplicate SigType code");
        }
    }
}

