/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionDemultiplexer;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.client.I2PSessionImpl2;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.MessageState;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.SendMessageStatusListener;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.data.i2cp.MessagePayloadMessage;

class I2PSessionMuxedImpl
extends I2PSessionImpl2 {
    private final I2PSessionDemultiplexer _demultiplexer;
    private static final int PROTO_BYTE = 9;
    private static final int FROMPORT_BYTES = 4;
    private static final int TOPORT_BYTES = 6;

    public I2PSessionMuxedImpl(I2PAppContext ctx, InputStream destKeyStream, Properties options) throws I2PSessionException {
        super(ctx, destKeyStream, options);
        this._demultiplexer = new I2PSessionDemultiplexer(ctx);
        super.setSessionListener(this._demultiplexer);
        this._availabilityNotifier = new MuxedAvailabilityNotifier();
    }

    @Override
    public void setSessionListener(I2PSessionListener lsnr) {
        this._demultiplexer.addListener(lsnr, 0, 0);
    }

    @Override
    public void addSessionListener(I2PSessionListener lsnr, int proto, int port) {
        this._demultiplexer.addListener(lsnr, proto, port);
    }

    @Override
    public void addMuxedSessionListener(I2PSessionMuxedListener l, int proto, int port) {
        this._demultiplexer.addMuxedListener(l, proto, port);
    }

    @Override
    public void removeListener(int proto, int port) {
        this._demultiplexer.removeListener(proto, port);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length, null, null, 0L, 0, 0, 0);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int proto, int fromport, int toport) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length, null, null, 0L, proto, fromport, toport);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expires) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, keyUsed, tagsSent, 0L, 0, 0, 0);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, int proto, int fromport, int toport) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, keyUsed, tagsSent, 0L, proto, fromport, toport);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expires, int proto, int fromPort, int toPort) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, keyUsed, tagsSent, 0L, proto, fromPort, toPort, 0);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expires, int proto, int fromPort, int toPort, int flags) throws I2PSessionException {
        payload = this.prepPayload(payload, offset, size, proto, fromPort, toPort);
        if (this._noEffort) {
            return this.sendNoEffort(dest, payload, expires, flags);
        }
        return this.sendBestEffort(dest, payload, expires, flags);
    }

    @Override
    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, int proto, int fromPort, int toPort, SendMessageOptions options) throws I2PSessionException {
        payload = this.prepPayload(payload, offset, size, proto, fromPort, toPort);
        this.sendNoEffort(dest, payload, options);
        return true;
    }

    @Override
    public long sendMessage(Destination dest, byte[] payload, int offset, int size, int proto, int fromPort, int toPort, SendMessageOptions options, SendMessageStatusListener listener) throws I2PSessionException {
        payload = this.prepPayload(payload, offset, size, proto, fromPort, toPort);
        long nonce = this._sendMessageNonce.incrementAndGet();
        long expires = Math.max(this._context.clock().now() + 60000L, options.getTime());
        MessageState state = new MessageState(this._context, nonce, this, expires, listener);
        this._sendingStates.put(nonce, state);
        this._producer.sendMessage(this, dest, nonce, payload, options);
        return nonce;
    }

    private byte[] prepPayload(byte[] payload, int offset, int size, int proto, int fromPort, int toPort) throws I2PSessionException {
        if (this.isClosed()) {
            throw new I2PSessionException("Already closed");
        }
        this.updateActivity();
        payload = this.shouldCompress(size) ? DataHelper.compress(payload, offset, size) : DataHelper.compress(payload, offset, size, 0);
        I2PSessionMuxedImpl.setProto(payload, proto);
        I2PSessionMuxedImpl.setFromPort(payload, fromPort);
        I2PSessionMuxedImpl.setToPort(payload, toPort);
        this._context.statManager().addRateData("i2cp.tx.msgCompressed", payload.length);
        this._context.statManager().addRateData("i2cp.tx.msgExpanded", size);
        return payload;
    }

    private void sendNoEffort(Destination dest, byte[] payload, SendMessageOptions options) throws I2PSessionException {
        this._producer.sendMessage(this, dest, 0L, payload, options);
    }

    @Override
    public void addNewMessage(MessagePayloadMessage msg) {
        Long mid = msg.getMessageId();
        this._availableMessages.put(mid, msg);
        long id = msg.getMessageId();
        byte[] data = msg.getPayload().getUnencryptedData();
        if (data == null || data.length <= 0) {
            if (this._log.shouldLog(50)) {
                this._log.log(50, this.getPrefix() + "addNewMessage of a message with no unencrypted data", new Exception("Empty message"));
            }
            return;
        }
        int size = data.length;
        if (size < 10) {
            this._log.error(this.getPrefix() + "length too short for gzip header: " + size);
            return;
        }
        ((MuxedAvailabilityNotifier)this._availabilityNotifier).available(id, size, I2PSessionMuxedImpl.getProto(msg), I2PSessionMuxedImpl.getFromPort(msg), I2PSessionMuxedImpl.getToPort(msg));
    }

    private static int getProto(MessagePayloadMessage msg) {
        int rv = I2PSessionMuxedImpl.getByte(msg, 9) & 0xFF;
        return rv == 255 ? 0 : rv;
    }

    private static int getFromPort(MessagePayloadMessage msg) {
        return (I2PSessionMuxedImpl.getByte(msg, 4) & 0xFF) << 8 | I2PSessionMuxedImpl.getByte(msg, 5) & 0xFF;
    }

    private static int getToPort(MessagePayloadMessage msg) {
        return (I2PSessionMuxedImpl.getByte(msg, 6) & 0xFF) << 8 | I2PSessionMuxedImpl.getByte(msg, 7) & 0xFF;
    }

    private static int getByte(MessagePayloadMessage msg, int i) {
        return msg.getPayload().getUnencryptedData()[i] & 0xFF;
    }

    private static void setProto(byte[] payload, int p) {
        payload[9] = (byte)(p & 0xFF);
    }

    private static void setFromPort(byte[] payload, int p) {
        payload[4] = (byte)(p >> 8 & 0xFF);
        payload[5] = (byte)(p & 0xFF);
    }

    private static void setToPort(byte[] payload, int p) {
        payload[6] = (byte)(p >> 8 & 0xFF);
        payload[7] = (byte)(p & 0xFF);
    }

    private static class MsgData {
        public final int id;
        public final int size;
        public final int proto;
        public final int fromPort;
        public final int toPort;

        public MsgData(int i, int s, int p, int f, int t) {
            this.id = i;
            this.size = s;
            this.proto = p;
            this.fromPort = f;
            this.toPort = t;
        }
    }

    protected class MuxedAvailabilityNotifier
    extends I2PSessionImpl.AvailabilityNotifier {
        private final LinkedBlockingQueue<MsgData> _msgs;
        private volatile boolean _alive = false;
        private static final int POISON_SIZE = -99999;
        private final AtomicBoolean stopping = new AtomicBoolean(false);

        public MuxedAvailabilityNotifier() {
            this._msgs = new LinkedBlockingQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopNotifying() {
            boolean again = true;
            AtomicBoolean atomicBoolean = this.stopping;
            synchronized (atomicBoolean) {
                if (!this.stopping.getAndSet(true)) {
                    if (this._alive) {
                        this._msgs.clear();
                        while (again) {
                            try {
                                this._msgs.put(new MsgData(0, -99999, 0, 0, 0));
                                again = false;
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                    this._alive = false;
                    this.stopping.set(false);
                }
            }
        }

        @Override
        public void available(long msgId, int size) {
            throw new IllegalArgumentException("no");
        }

        public void available(long msgId, int size, int proto, int fromPort, int toPort) {
            try {
                this._msgs.put(new MsgData((int)(msgId & 0xFFFFFFFFFFFFFFFFL), size, proto, fromPort, toPort));
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this._alive = true;
            while (this._alive) {
                MsgData msg;
                try {
                    msg = this._msgs.take();
                }
                catch (InterruptedException ie) {
                    I2PSessionMuxedImpl.this._log.debug("I2PSessionMuxedImpl.run() InterruptedException " + String.valueOf(this._msgs.size()) + " Messages, Alive " + this._alive);
                    continue;
                }
                if (msg.size == -99999) break;
                try {
                    I2PSessionMuxedImpl.this._demultiplexer.messageAvailable(I2PSessionMuxedImpl.this, msg.id, msg.size, msg.proto, msg.fromPort, msg.toPort);
                }
                catch (Exception e) {
                    I2PSessionMuxedImpl.this._log.error("Error notifying app of message availability", e);
                }
            }
        }
    }
}

