(ns leiningen.new.caudal-template
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "caudal-template"))

(defn caudal-template
  "FIXME: write documentation"
  [name]
  (let [data {:name      name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' caudal-template project.")
    (->files data
             ["src/{{sanitized}}/custom.clj" (render "custom.clj" data)]
             ["src/{{sanitized}}/main.clj"   (render "main.clj" data)]
             ["bin/start-caudal.sh"          (render "start-caudal.sh" data)]
             ["data/input.txt"               (render "input.txt" data)]
             ["config/caudal-config.edn"     (render "caudal-config.edn" data)]
             ["log4j.properties"             (render "log4j.properties" data)]
             ["project.clj"                  (render "project.clj" data)])))
